/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCodeInterpreterSessionRequest extends BedrockAgentCoreRequest implements
        ToCopyableBuilder<StartCodeInterpreterSessionRequest.Builder, StartCodeInterpreterSessionRequest> {
    private static final SdkField<String> CODE_INTERPRETER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeInterpreterIdentifier")
            .getter(getter(StartCodeInterpreterSessionRequest::codeInterpreterIdentifier))
            .setter(setter(Builder::codeInterpreterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("codeInterpreterIdentifier").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartCodeInterpreterSessionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> SESSION_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sessionTimeoutSeconds").getter(getter(StartCodeInterpreterSessionRequest::sessionTimeoutSeconds))
            .setter(setter(Builder::sessionTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionTimeoutSeconds").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartCodeInterpreterSessionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CODE_INTERPRETER_IDENTIFIER_FIELD, NAME_FIELD, SESSION_TIMEOUT_SECONDS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String codeInterpreterIdentifier;

    private final String name;

    private final Integer sessionTimeoutSeconds;

    private final String clientToken;

    private StartCodeInterpreterSessionRequest(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterIdentifier = builder.codeInterpreterIdentifier;
        this.name = builder.name;
        this.sessionTimeoutSeconds = builder.sessionTimeoutSeconds;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The unique identifier of the code interpreter to use for this session. This identifier specifies which code
     * interpreter environment to initialize for the session.
     * </p>
     * 
     * @return The unique identifier of the code interpreter to use for this session. This identifier specifies which
     *         code interpreter environment to initialize for the session.
     */
    public final String codeInterpreterIdentifier() {
        return codeInterpreterIdentifier;
    }

    /**
     * <p>
     * The name of the code interpreter session. This name helps you identify and manage the session. The name does not
     * need to be unique.
     * </p>
     * 
     * @return The name of the code interpreter session. This name helps you identify and manage the session. The name
     *         does not need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time in seconds after which the session automatically terminates if there is no activity. The default value
     * is 3600 seconds (1 hour). The minimum allowed value is 60 seconds, and the maximum allowed value is 28800 seconds
     * (8 hours).
     * </p>
     * 
     * @return The time in seconds after which the session automatically terminates if there is no activity. The default
     *         value is 3600 seconds (1 hour). The minimum allowed value is 60 seconds, and the maximum allowed value is
     *         28800 seconds (8 hours).
     */
    public final Integer sessionTimeoutSeconds() {
        return sessionTimeoutSeconds;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. This parameter
     * helps prevent the creation of duplicate sessions if there are temporary network issues.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         This parameter helps prevent the creation of duplicate sessions if there are temporary network issues.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeInterpreterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCodeInterpreterSessionRequest)) {
            return false;
        }
        StartCodeInterpreterSessionRequest other = (StartCodeInterpreterSessionRequest) obj;
        return Objects.equals(codeInterpreterIdentifier(), other.codeInterpreterIdentifier())
                && Objects.equals(name(), other.name()) && Objects.equals(sessionTimeoutSeconds(), other.sessionTimeoutSeconds())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCodeInterpreterSessionRequest")
                .add("CodeInterpreterIdentifier", codeInterpreterIdentifier()).add("Name", name())
                .add("SessionTimeoutSeconds", sessionTimeoutSeconds()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeInterpreterIdentifier":
            return Optional.ofNullable(clazz.cast(codeInterpreterIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sessionTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(sessionTimeoutSeconds()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("codeInterpreterIdentifier", CODE_INTERPRETER_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sessionTimeoutSeconds", SESSION_TIMEOUT_SECONDS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCodeInterpreterSessionRequest, T> g) {
        return obj -> g.apply((StartCodeInterpreterSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartCodeInterpreterSessionRequest> {
        /**
         * <p>
         * The unique identifier of the code interpreter to use for this session. This identifier specifies which code
         * interpreter environment to initialize for the session.
         * </p>
         * 
         * @param codeInterpreterIdentifier
         *        The unique identifier of the code interpreter to use for this session. This identifier specifies which
         *        code interpreter environment to initialize for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeInterpreterIdentifier(String codeInterpreterIdentifier);

        /**
         * <p>
         * The name of the code interpreter session. This name helps you identify and manage the session. The name does
         * not need to be unique.
         * </p>
         * 
         * @param name
         *        The name of the code interpreter session. This name helps you identify and manage the session. The
         *        name does not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time in seconds after which the session automatically terminates if there is no activity. The default
         * value is 3600 seconds (1 hour). The minimum allowed value is 60 seconds, and the maximum allowed value is
         * 28800 seconds (8 hours).
         * </p>
         * 
         * @param sessionTimeoutSeconds
         *        The time in seconds after which the session automatically terminates if there is no activity. The
         *        default value is 3600 seconds (1 hour). The minimum allowed value is 60 seconds, and the maximum
         *        allowed value is 28800 seconds (8 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeoutSeconds(Integer sessionTimeoutSeconds);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. This
         * parameter helps prevent the creation of duplicate sessions if there are temporary network issues.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. This parameter helps prevent the creation of duplicate sessions if there are temporary network
         *        issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreRequest.BuilderImpl implements Builder {
        private String codeInterpreterIdentifier;

        private String name;

        private Integer sessionTimeoutSeconds;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCodeInterpreterSessionRequest model) {
            super(model);
            codeInterpreterIdentifier(model.codeInterpreterIdentifier);
            name(model.name);
            sessionTimeoutSeconds(model.sessionTimeoutSeconds);
            clientToken(model.clientToken);
        }

        public final String getCodeInterpreterIdentifier() {
            return codeInterpreterIdentifier;
        }

        public final void setCodeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
        }

        @Override
        public final Builder codeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getSessionTimeoutSeconds() {
            return sessionTimeoutSeconds;
        }

        public final void setSessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
        }

        @Override
        public final Builder sessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCodeInterpreterSessionRequest build() {
            return new StartCodeInterpreterSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
