/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBrowserSessionRequest extends BedrockAgentCoreRequest implements
        ToCopyableBuilder<StartBrowserSessionRequest.Builder, StartBrowserSessionRequest> {
    private static final SdkField<String> BROWSER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserIdentifier").getter(getter(StartBrowserSessionRequest::browserIdentifier))
            .setter(setter(Builder::browserIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("browserIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartBrowserSessionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> SESSION_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sessionTimeoutSeconds").getter(getter(StartBrowserSessionRequest::sessionTimeoutSeconds))
            .setter(setter(Builder::sessionTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionTimeoutSeconds").build())
            .build();

    private static final SdkField<ViewPort> VIEW_PORT_FIELD = SdkField.<ViewPort> builder(MarshallingType.SDK_POJO)
            .memberName("viewPort").getter(getter(StartBrowserSessionRequest::viewPort)).setter(setter(Builder::viewPort))
            .constructor(ViewPort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewPort").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartBrowserSessionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_IDENTIFIER_FIELD,
            NAME_FIELD, SESSION_TIMEOUT_SECONDS_FIELD, VIEW_PORT_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String browserIdentifier;

    private final String name;

    private final Integer sessionTimeoutSeconds;

    private final ViewPort viewPort;

    private final String clientToken;

    private StartBrowserSessionRequest(BuilderImpl builder) {
        super(builder);
        this.browserIdentifier = builder.browserIdentifier;
        this.name = builder.name;
        this.sessionTimeoutSeconds = builder.sessionTimeoutSeconds;
        this.viewPort = builder.viewPort;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The unique identifier of the browser to use for this session. This identifier specifies which browser environment
     * to initialize for the session.
     * </p>
     * 
     * @return The unique identifier of the browser to use for this session. This identifier specifies which browser
     *         environment to initialize for the session.
     */
    public final String browserIdentifier() {
        return browserIdentifier;
    }

    /**
     * <p>
     * The name of the browser session. This name helps you identify and manage the session. The name does not need to
     * be unique.
     * </p>
     * 
     * @return The name of the browser session. This name helps you identify and manage the session. The name does not
     *         need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time in seconds after which the session automatically terminates if there is no activity. The default value
     * is 3600 seconds (1 hour). The minimum allowed value is 60 seconds, and the maximum allowed value is 28800 seconds
     * (8 hours).
     * </p>
     * 
     * @return The time in seconds after which the session automatically terminates if there is no activity. The default
     *         value is 3600 seconds (1 hour). The minimum allowed value is 60 seconds, and the maximum allowed value is
     *         28800 seconds (8 hours).
     */
    public final Integer sessionTimeoutSeconds() {
        return sessionTimeoutSeconds;
    }

    /**
     * <p>
     * The dimensions of the browser viewport for this session. This determines the visible area of the web content and
     * affects how web pages are rendered. If not specified, Amazon Bedrock uses a default viewport size.
     * </p>
     * 
     * @return The dimensions of the browser viewport for this session. This determines the visible area of the web
     *         content and affects how web pages are rendered. If not specified, Amazon Bedrock uses a default viewport
     *         size.
     */
    public final ViewPort viewPort() {
        return viewPort;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. This parameter
     * helps prevent the creation of duplicate sessions if there are temporary network issues.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         This parameter helps prevent the creation of duplicate sessions if there are temporary network issues.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(browserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(viewPort());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBrowserSessionRequest)) {
            return false;
        }
        StartBrowserSessionRequest other = (StartBrowserSessionRequest) obj;
        return Objects.equals(browserIdentifier(), other.browserIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(sessionTimeoutSeconds(), other.sessionTimeoutSeconds())
                && Objects.equals(viewPort(), other.viewPort()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartBrowserSessionRequest").add("BrowserIdentifier", browserIdentifier()).add("Name", name())
                .add("SessionTimeoutSeconds", sessionTimeoutSeconds()).add("ViewPort", viewPort())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserIdentifier":
            return Optional.ofNullable(clazz.cast(browserIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sessionTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(sessionTimeoutSeconds()));
        case "viewPort":
            return Optional.ofNullable(clazz.cast(viewPort()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("browserIdentifier", BROWSER_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sessionTimeoutSeconds", SESSION_TIMEOUT_SECONDS_FIELD);
        map.put("viewPort", VIEW_PORT_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartBrowserSessionRequest, T> g) {
        return obj -> g.apply((StartBrowserSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartBrowserSessionRequest> {
        /**
         * <p>
         * The unique identifier of the browser to use for this session. This identifier specifies which browser
         * environment to initialize for the session.
         * </p>
         * 
         * @param browserIdentifier
         *        The unique identifier of the browser to use for this session. This identifier specifies which browser
         *        environment to initialize for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserIdentifier(String browserIdentifier);

        /**
         * <p>
         * The name of the browser session. This name helps you identify and manage the session. The name does not need
         * to be unique.
         * </p>
         * 
         * @param name
         *        The name of the browser session. This name helps you identify and manage the session. The name does
         *        not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time in seconds after which the session automatically terminates if there is no activity. The default
         * value is 3600 seconds (1 hour). The minimum allowed value is 60 seconds, and the maximum allowed value is
         * 28800 seconds (8 hours).
         * </p>
         * 
         * @param sessionTimeoutSeconds
         *        The time in seconds after which the session automatically terminates if there is no activity. The
         *        default value is 3600 seconds (1 hour). The minimum allowed value is 60 seconds, and the maximum
         *        allowed value is 28800 seconds (8 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeoutSeconds(Integer sessionTimeoutSeconds);

        /**
         * <p>
         * The dimensions of the browser viewport for this session. This determines the visible area of the web content
         * and affects how web pages are rendered. If not specified, Amazon Bedrock uses a default viewport size.
         * </p>
         * 
         * @param viewPort
         *        The dimensions of the browser viewport for this session. This determines the visible area of the web
         *        content and affects how web pages are rendered. If not specified, Amazon Bedrock uses a default
         *        viewport size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewPort(ViewPort viewPort);

        /**
         * <p>
         * The dimensions of the browser viewport for this session. This determines the visible area of the web content
         * and affects how web pages are rendered. If not specified, Amazon Bedrock uses a default viewport size.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViewPort.Builder} avoiding the need to
         * create one manually via {@link ViewPort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewPort.Builder#build()} is called immediately and its result is
         * passed to {@link #viewPort(ViewPort)}.
         * 
         * @param viewPort
         *        a consumer that will call methods on {@link ViewPort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewPort(ViewPort)
         */
        default Builder viewPort(Consumer<ViewPort.Builder> viewPort) {
            return viewPort(ViewPort.builder().applyMutation(viewPort).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. This
         * parameter helps prevent the creation of duplicate sessions if there are temporary network issues.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. This parameter helps prevent the creation of duplicate sessions if there are temporary network
         *        issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreRequest.BuilderImpl implements Builder {
        private String browserIdentifier;

        private String name;

        private Integer sessionTimeoutSeconds;

        private ViewPort viewPort;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBrowserSessionRequest model) {
            super(model);
            browserIdentifier(model.browserIdentifier);
            name(model.name);
            sessionTimeoutSeconds(model.sessionTimeoutSeconds);
            viewPort(model.viewPort);
            clientToken(model.clientToken);
        }

        public final String getBrowserIdentifier() {
            return browserIdentifier;
        }

        public final void setBrowserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
        }

        @Override
        public final Builder browserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getSessionTimeoutSeconds() {
            return sessionTimeoutSeconds;
        }

        public final void setSessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
        }

        @Override
        public final Builder sessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
            return this;
        }

        public final ViewPort.Builder getViewPort() {
            return viewPort != null ? viewPort.toBuilder() : null;
        }

        public final void setViewPort(ViewPort.BuilderImpl viewPort) {
            this.viewPort = viewPort != null ? viewPort.build() : null;
        }

        @Override
        public final Builder viewPort(ViewPort viewPort) {
            this.viewPort = viewPort;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBrowserSessionRequest build() {
            return new StartBrowserSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
