/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains search criteria for retrieving memory records.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchCriteria implements SdkPojo, Serializable, ToCopyableBuilder<SearchCriteria.Builder, SearchCriteria> {
    private static final SdkField<String> SEARCH_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("searchQuery").getter(getter(SearchCriteria::searchQuery)).setter(setter(Builder::searchQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchQuery").build()).build();

    private static final SdkField<String> MEMORY_STRATEGY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryStrategyId").getter(getter(SearchCriteria::memoryStrategyId))
            .setter(setter(Builder::memoryStrategyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategyId").build()).build();

    private static final SdkField<Integer> TOPK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("topK")
            .getter(getter(SearchCriteria::topK)).setter(setter(Builder::topK))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topK").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_QUERY_FIELD,
            MEMORY_STRATEGY_ID_FIELD, TOPK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String searchQuery;

    private final String memoryStrategyId;

    private final Integer topK;

    private SearchCriteria(BuilderImpl builder) {
        this.searchQuery = builder.searchQuery;
        this.memoryStrategyId = builder.memoryStrategyId;
        this.topK = builder.topK;
    }

    /**
     * <p>
     * The search query to use for finding relevant memory records.
     * </p>
     * 
     * @return The search query to use for finding relevant memory records.
     */
    public final String searchQuery() {
        return searchQuery;
    }

    /**
     * <p>
     * The memory strategy identifier to filter memory records by.
     * </p>
     * 
     * @return The memory strategy identifier to filter memory records by.
     */
    public final String memoryStrategyId() {
        return memoryStrategyId;
    }

    /**
     * <p>
     * The maximum number of top-scoring memory records to return. This value is used for semantic search ranking.
     * </p>
     * 
     * @return The maximum number of top-scoring memory records to return. This value is used for semantic search
     *         ranking.
     */
    public final Integer topK() {
        return topK;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(searchQuery());
        hashCode = 31 * hashCode + Objects.hashCode(memoryStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(topK());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCriteria)) {
            return false;
        }
        SearchCriteria other = (SearchCriteria) obj;
        return Objects.equals(searchQuery(), other.searchQuery()) && Objects.equals(memoryStrategyId(), other.memoryStrategyId())
                && Objects.equals(topK(), other.topK());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchCriteria")
                .add("SearchQuery", searchQuery() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MemoryStrategyId", memoryStrategyId()).add("TopK", topK()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "searchQuery":
            return Optional.ofNullable(clazz.cast(searchQuery()));
        case "memoryStrategyId":
            return Optional.ofNullable(clazz.cast(memoryStrategyId()));
        case "topK":
            return Optional.ofNullable(clazz.cast(topK()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("searchQuery", SEARCH_QUERY_FIELD);
        map.put("memoryStrategyId", MEMORY_STRATEGY_ID_FIELD);
        map.put("topK", TOPK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchCriteria, T> g) {
        return obj -> g.apply((SearchCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchCriteria> {
        /**
         * <p>
         * The search query to use for finding relevant memory records.
         * </p>
         * 
         * @param searchQuery
         *        The search query to use for finding relevant memory records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchQuery(String searchQuery);

        /**
         * <p>
         * The memory strategy identifier to filter memory records by.
         * </p>
         * 
         * @param memoryStrategyId
         *        The memory strategy identifier to filter memory records by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryStrategyId(String memoryStrategyId);

        /**
         * <p>
         * The maximum number of top-scoring memory records to return. This value is used for semantic search ranking.
         * </p>
         * 
         * @param topK
         *        The maximum number of top-scoring memory records to return. This value is used for semantic search
         *        ranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topK(Integer topK);
    }

    static final class BuilderImpl implements Builder {
        private String searchQuery;

        private String memoryStrategyId;

        private Integer topK;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchCriteria model) {
            searchQuery(model.searchQuery);
            memoryStrategyId(model.memoryStrategyId);
            topK(model.topK);
        }

        public final String getSearchQuery() {
            return searchQuery;
        }

        public final void setSearchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
        }

        @Override
        public final Builder searchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        public final String getMemoryStrategyId() {
            return memoryStrategyId;
        }

        public final void setMemoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
        }

        @Override
        public final Builder memoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
            return this;
        }

        public final Integer getTopK() {
            return topK;
        }

        public final void setTopK(Integer topK) {
            this.topK = topK;
        }

        @Override
        public final Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        @Override
        public SearchCriteria build() {
            return new SearchCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
