/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about resource content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceContent implements SdkPojo, Serializable, ToCopyableBuilder<ResourceContent.Builder, ResourceContent> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ResourceContent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uri")
            .getter(getter(ResourceContent::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mimeType").getter(getter(ResourceContent::mimeType)).setter(setter(Builder::mimeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mimeType").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(ResourceContent::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<SdkBytes> BLOB_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("blob").getter(getter(ResourceContent::blob)).setter(setter(Builder::blob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, URI_FIELD,
            MIME_TYPE_FIELD, TEXT_FIELD, BLOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String uri;

    private final String mimeType;

    private final String text;

    private final SdkBytes blob;

    private ResourceContent(BuilderImpl builder) {
        this.type = builder.type;
        this.uri = builder.uri;
        this.mimeType = builder.mimeType;
        this.text = builder.text;
        this.blob = builder.blob;
    }

    /**
     * <p>
     * The type of resource content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource content.
     * @see ResourceContentType
     */
    public final ResourceContentType type() {
        return ResourceContentType.fromValue(type);
    }

    /**
     * <p>
     * The type of resource content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource content.
     * @see ResourceContentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The URI of the resource content.
     * </p>
     * 
     * @return The URI of the resource content.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * The MIME type of the resource content.
     * </p>
     * 
     * @return The MIME type of the resource content.
     */
    public final String mimeType() {
        return mimeType;
    }

    /**
     * <p>
     * The text resource content.
     * </p>
     * 
     * @return The text resource content.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The binary resource content.
     * </p>
     * 
     * @return The binary resource content.
     */
    public final SdkBytes blob() {
        return blob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(mimeType());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(blob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceContent)) {
            return false;
        }
        ResourceContent other = (ResourceContent) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(uri(), other.uri())
                && Objects.equals(mimeType(), other.mimeType()) && Objects.equals(text(), other.text())
                && Objects.equals(blob(), other.blob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceContent").add("Type", typeAsString()).add("Uri", uri()).add("MimeType", mimeType())
                .add("Text", text()).add("Blob", blob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "mimeType":
            return Optional.ofNullable(clazz.cast(mimeType()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "blob":
            return Optional.ofNullable(clazz.cast(blob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("uri", URI_FIELD);
        map.put("mimeType", MIME_TYPE_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("blob", BLOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceContent, T> g) {
        return obj -> g.apply((ResourceContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceContent> {
        /**
         * <p>
         * The type of resource content.
         * </p>
         * 
         * @param type
         *        The type of resource content.
         * @see ResourceContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceContentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of resource content.
         * </p>
         * 
         * @param type
         *        The type of resource content.
         * @see ResourceContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceContentType
         */
        Builder type(ResourceContentType type);

        /**
         * <p>
         * The URI of the resource content.
         * </p>
         * 
         * @param uri
         *        The URI of the resource content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The MIME type of the resource content.
         * </p>
         * 
         * @param mimeType
         *        The MIME type of the resource content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mimeType(String mimeType);

        /**
         * <p>
         * The text resource content.
         * </p>
         * 
         * @param text
         *        The text resource content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The binary resource content.
         * </p>
         * 
         * @param blob
         *        The binary resource content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blob(SdkBytes blob);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String uri;

        private String mimeType;

        private String text;

        private SdkBytes blob;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceContent model) {
            type(model.type);
            uri(model.uri);
            mimeType(model.mimeType);
            text(model.text);
            blob(model.blob);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceContentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getMimeType() {
            return mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final ByteBuffer getBlob() {
            return blob == null ? null : blob.asByteBuffer();
        }

        public final void setBlob(ByteBuffer blob) {
            blob(blob == null ? null : SdkBytes.fromByteBuffer(blob));
        }

        @Override
        public final Builder blob(SdkBytes blob) {
            this.blob = blob;
            return this;
        }

        @Override
        public ResourceContent build() {
            return new ResourceContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
