/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a stream that provides a visual representation of a browser session in Amazon Bedrock. This
 * stream enables agents to observe the current state of the browser, including rendered web pages, visual elements, and
 * the results of interactions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LiveViewStream implements SdkPojo, Serializable, ToCopyableBuilder<LiveViewStream.Builder, LiveViewStream> {
    private static final SdkField<String> STREAM_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamEndpoint").getter(getter(LiveViewStream::streamEndpoint)).setter(setter(Builder::streamEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streamEndpoint;

    private LiveViewStream(BuilderImpl builder) {
        this.streamEndpoint = builder.streamEndpoint;
    }

    /**
     * <p>
     * The endpoint URL for the live view stream. This URL is used to establish a connection to receive visual updates
     * from the browser session.
     * </p>
     * 
     * @return The endpoint URL for the live view stream. This URL is used to establish a connection to receive visual
     *         updates from the browser session.
     */
    public final String streamEndpoint() {
        return streamEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveViewStream)) {
            return false;
        }
        LiveViewStream other = (LiveViewStream) obj;
        return Objects.equals(streamEndpoint(), other.streamEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LiveViewStream").add("StreamEndpoint", streamEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamEndpoint":
            return Optional.ofNullable(clazz.cast(streamEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streamEndpoint", STREAM_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LiveViewStream, T> g) {
        return obj -> g.apply((LiveViewStream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LiveViewStream> {
        /**
         * <p>
         * The endpoint URL for the live view stream. This URL is used to establish a connection to receive visual
         * updates from the browser session.
         * </p>
         * 
         * @param streamEndpoint
         *        The endpoint URL for the live view stream. This URL is used to establish a connection to receive
         *        visual updates from the browser session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamEndpoint(String streamEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String streamEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(LiveViewStream model) {
            streamEndpoint(model.streamEndpoint);
        }

        public final String getStreamEndpoint() {
            return streamEndpoint;
        }

        public final void setStreamEndpoint(String streamEndpoint) {
            this.streamEndpoint = streamEndpoint;
        }

        @Override
        public final Builder streamEndpoint(String streamEndpoint) {
            this.streamEndpoint = streamEndpoint;
            return this;
        }

        @Override
        public LiveViewStream build() {
            return new LiveViewStream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
