/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMemoryRecordsResponse extends BedrockAgentCoreResponse implements
        ToCopyableBuilder<ListMemoryRecordsResponse.Builder, ListMemoryRecordsResponse> {
    private static final SdkField<List<MemoryRecordSummary>> MEMORY_RECORD_SUMMARIES_FIELD = SdkField
            .<List<MemoryRecordSummary>> builder(MarshallingType.LIST)
            .memberName("memoryRecordSummaries")
            .getter(getter(ListMemoryRecordsResponse::memoryRecordSummaries))
            .setter(setter(Builder::memoryRecordSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryRecordSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemoryRecordSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemoryRecordSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMemoryRecordsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_RECORD_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MemoryRecordSummary> memoryRecordSummaries;

    private final String nextToken;

    private ListMemoryRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.memoryRecordSummaries = builder.memoryRecordSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemoryRecordSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMemoryRecordSummaries() {
        return memoryRecordSummaries != null && !(memoryRecordSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of memory record summaries that match the specified criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemoryRecordSummaries} method.
     * </p>
     * 
     * @return The list of memory record summaries that match the specified criteria.
     */
    public final List<MemoryRecordSummary> memoryRecordSummaries() {
        return memoryRecordSummaries;
    }

    /**
     * <p>
     * The token to use in a subsequent request to get the next set of results. This value is null when there are no
     * more results to return.
     * </p>
     * 
     * @return The token to use in a subsequent request to get the next set of results. This value is null when there
     *         are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMemoryRecordSummaries() ? memoryRecordSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMemoryRecordsResponse)) {
            return false;
        }
        ListMemoryRecordsResponse other = (ListMemoryRecordsResponse) obj;
        return hasMemoryRecordSummaries() == other.hasMemoryRecordSummaries()
                && Objects.equals(memoryRecordSummaries(), other.memoryRecordSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMemoryRecordsResponse")
                .add("MemoryRecordSummaries", hasMemoryRecordSummaries() ? memoryRecordSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memoryRecordSummaries":
            return Optional.ofNullable(clazz.cast(memoryRecordSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("memoryRecordSummaries", MEMORY_RECORD_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMemoryRecordsResponse, T> g) {
        return obj -> g.apply((ListMemoryRecordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMemoryRecordsResponse> {
        /**
         * <p>
         * The list of memory record summaries that match the specified criteria.
         * </p>
         * 
         * @param memoryRecordSummaries
         *        The list of memory record summaries that match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryRecordSummaries(Collection<MemoryRecordSummary> memoryRecordSummaries);

        /**
         * <p>
         * The list of memory record summaries that match the specified criteria.
         * </p>
         * 
         * @param memoryRecordSummaries
         *        The list of memory record summaries that match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryRecordSummaries(MemoryRecordSummary... memoryRecordSummaries);

        /**
         * <p>
         * The list of memory record summaries that match the specified criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #memoryRecordSummaries(List<MemoryRecordSummary>)}.
         * 
         * @param memoryRecordSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryRecordSummaries(java.util.Collection<MemoryRecordSummary>)
         */
        Builder memoryRecordSummaries(Consumer<MemoryRecordSummary.Builder>... memoryRecordSummaries);

        /**
         * <p>
         * The token to use in a subsequent request to get the next set of results. This value is null when there are no
         * more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use in a subsequent request to get the next set of results. This value is null when there
         *        are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockAgentCoreResponse.BuilderImpl implements Builder {
        private List<MemoryRecordSummary> memoryRecordSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMemoryRecordsResponse model) {
            super(model);
            memoryRecordSummaries(model.memoryRecordSummaries);
            nextToken(model.nextToken);
        }

        public final List<MemoryRecordSummary.Builder> getMemoryRecordSummaries() {
            List<MemoryRecordSummary.Builder> result = MemoryRecordSummaryListCopier.copyToBuilder(this.memoryRecordSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemoryRecordSummaries(Collection<MemoryRecordSummary.BuilderImpl> memoryRecordSummaries) {
            this.memoryRecordSummaries = MemoryRecordSummaryListCopier.copyFromBuilder(memoryRecordSummaries);
        }

        @Override
        public final Builder memoryRecordSummaries(Collection<MemoryRecordSummary> memoryRecordSummaries) {
            this.memoryRecordSummaries = MemoryRecordSummaryListCopier.copy(memoryRecordSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memoryRecordSummaries(MemoryRecordSummary... memoryRecordSummaries) {
            memoryRecordSummaries(Arrays.asList(memoryRecordSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memoryRecordSummaries(Consumer<MemoryRecordSummary.Builder>... memoryRecordSummaries) {
            memoryRecordSummaries(Stream.of(memoryRecordSummaries)
                    .map(c -> MemoryRecordSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMemoryRecordsResponse build() {
            return new ListMemoryRecordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
