/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBrowserSessionsRequest extends BedrockAgentCoreRequest implements
        ToCopyableBuilder<ListBrowserSessionsRequest.Builder, ListBrowserSessionsRequest> {
    private static final SdkField<String> BROWSER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserIdentifier").getter(getter(ListBrowserSessionsRequest::browserIdentifier))
            .setter(setter(Builder::browserIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("browserIdentifier").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListBrowserSessionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBrowserSessionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListBrowserSessionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_IDENTIFIER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String browserIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final String status;

    private ListBrowserSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.browserIdentifier = builder.browserIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the browser to list sessions for. If specified, only sessions for this browser are
     * returned. If not specified, sessions for all browsers are returned.
     * </p>
     * 
     * @return The unique identifier of the browser to list sessions for. If specified, only sessions for this browser
     *         are returned. If not specified, sessions for all browsers are returned.
     */
    public final String browserIdentifier() {
        return browserIdentifier;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. The default value is 10. Valid values range from 1 to
     * 100. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. The default value is 10. Valid values range
     *         from 1 to 100. To retrieve the remaining results, make another call with the returned
     *         <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results. If not specified, Amazon Bedrock returns the first page of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results. If not specified, Amazon Bedrock returns the first page of
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The status of the browser sessions to list. Valid values include ACTIVE, STOPPING, and STOPPED. If not specified,
     * sessions with any status are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BrowserSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the browser sessions to list. Valid values include ACTIVE, STOPPING, and STOPPED. If not
     *         specified, sessions with any status are returned.
     * @see BrowserSessionStatus
     */
    public final BrowserSessionStatus status() {
        return BrowserSessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the browser sessions to list. Valid values include ACTIVE, STOPPING, and STOPPED. If not specified,
     * sessions with any status are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BrowserSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the browser sessions to list. Valid values include ACTIVE, STOPPING, and STOPPED. If not
     *         specified, sessions with any status are returned.
     * @see BrowserSessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(browserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBrowserSessionsRequest)) {
            return false;
        }
        ListBrowserSessionsRequest other = (ListBrowserSessionsRequest) obj;
        return Objects.equals(browserIdentifier(), other.browserIdentifier()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBrowserSessionsRequest").add("BrowserIdentifier", browserIdentifier())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserIdentifier":
            return Optional.ofNullable(clazz.cast(browserIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("browserIdentifier", BROWSER_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBrowserSessionsRequest, T> g) {
        return obj -> g.apply((ListBrowserSessionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBrowserSessionsRequest> {
        /**
         * <p>
         * The unique identifier of the browser to list sessions for. If specified, only sessions for this browser are
         * returned. If not specified, sessions for all browsers are returned.
         * </p>
         * 
         * @param browserIdentifier
         *        The unique identifier of the browser to list sessions for. If specified, only sessions for this
         *        browser are returned. If not specified, sessions for all browsers are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserIdentifier(String browserIdentifier);

        /**
         * <p>
         * The maximum number of results to return in a single call. The default value is 10. Valid values range from 1
         * to 100. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. The default value is 10. Valid values range
         *        from 1 to 100. To retrieve the remaining results, make another call with the returned
         *        <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results. If not specified, Amazon Bedrock returns the first page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results. If not specified, Amazon Bedrock returns the first page
         *        of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The status of the browser sessions to list. Valid values include ACTIVE, STOPPING, and STOPPED. If not
         * specified, sessions with any status are returned.
         * </p>
         * 
         * @param status
         *        The status of the browser sessions to list. Valid values include ACTIVE, STOPPING, and STOPPED. If not
         *        specified, sessions with any status are returned.
         * @see BrowserSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserSessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the browser sessions to list. Valid values include ACTIVE, STOPPING, and STOPPED. If not
         * specified, sessions with any status are returned.
         * </p>
         * 
         * @param status
         *        The status of the browser sessions to list. Valid values include ACTIVE, STOPPING, and STOPPED. If not
         *        specified, sessions with any status are returned.
         * @see BrowserSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserSessionStatus
         */
        Builder status(BrowserSessionStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreRequest.BuilderImpl implements Builder {
        private String browserIdentifier;

        private Integer maxResults;

        private String nextToken;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBrowserSessionsRequest model) {
            super(model);
            browserIdentifier(model.browserIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            status(model.status);
        }

        public final String getBrowserIdentifier() {
            return browserIdentifier;
        }

        public final void setBrowserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
        }

        @Override
        public final Builder browserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BrowserSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBrowserSessionsRequest build() {
            return new ListBrowserSessionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
