/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeAgentRuntimeResponse extends BedrockAgentCoreResponse implements
        ToCopyableBuilder<InvokeAgentRuntimeResponse.Builder, InvokeAgentRuntimeResponse> {
    private static final SdkField<String> RUNTIME_SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("runtimeSessionId")
            .getter(getter(InvokeAgentRuntimeResponse::runtimeSessionId))
            .setter(setter(Builder::runtimeSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("X-Amzn-Bedrock-AgentCore-Runtime-Session-Id").build()).build();

    private static final SdkField<String> MCP_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mcpSessionId").getter(getter(InvokeAgentRuntimeResponse::mcpSessionId))
            .setter(setter(Builder::mcpSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Mcp-Session-Id").build()).build();

    private static final SdkField<String> MCP_PROTOCOL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mcpProtocolVersion").getter(getter(InvokeAgentRuntimeResponse::mcpProtocolVersion))
            .setter(setter(Builder::mcpProtocolVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Mcp-Protocol-Version").build())
            .build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(InvokeAgentRuntimeResponse::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Trace-Id").build()).build();

    private static final SdkField<String> TRACE_PARENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceParent").getter(getter(InvokeAgentRuntimeResponse::traceParent))
            .setter(setter(Builder::traceParent))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("traceparent").build()).build();

    private static final SdkField<String> TRACE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceState").getter(getter(InvokeAgentRuntimeResponse::traceState)).setter(setter(Builder::traceState))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("tracestate").build()).build();

    private static final SdkField<String> BAGGAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("baggage")
            .getter(getter(InvokeAgentRuntimeResponse::baggage)).setter(setter(Builder::baggage))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("baggage").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(InvokeAgentRuntimeResponse::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("statusCode").getter(getter(InvokeAgentRuntimeResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("statusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_SESSION_ID_FIELD,
            MCP_SESSION_ID_FIELD, MCP_PROTOCOL_VERSION_FIELD, TRACE_ID_FIELD, TRACE_PARENT_FIELD, TRACE_STATE_FIELD,
            BAGGAGE_FIELD, CONTENT_TYPE_FIELD, STATUS_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String runtimeSessionId;

    private final String mcpSessionId;

    private final String mcpProtocolVersion;

    private final String traceId;

    private final String traceParent;

    private final String traceState;

    private final String baggage;

    private final String contentType;

    private final Integer statusCodeValue;

    private InvokeAgentRuntimeResponse(BuilderImpl builder) {
        super(builder);
        this.runtimeSessionId = builder.runtimeSessionId;
        this.mcpSessionId = builder.mcpSessionId;
        this.mcpProtocolVersion = builder.mcpProtocolVersion;
        this.traceId = builder.traceId;
        this.traceParent = builder.traceParent;
        this.traceState = builder.traceState;
        this.baggage = builder.baggage;
        this.contentType = builder.contentType;
        this.statusCodeValue = builder.statusCodeValue;
    }

    /**
     * <p>
     * The identifier of the runtime session.
     * </p>
     * 
     * @return The identifier of the runtime session.
     */
    public final String runtimeSessionId() {
        return runtimeSessionId;
    }

    /**
     * <p>
     * The identifier of the MCP session.
     * </p>
     * 
     * @return The identifier of the MCP session.
     */
    public final String mcpSessionId() {
        return mcpSessionId;
    }

    /**
     * <p>
     * The version of the MCP protocol being used.
     * </p>
     * 
     * @return The version of the MCP protocol being used.
     */
    public final String mcpProtocolVersion() {
        return mcpProtocolVersion;
    }

    /**
     * <p>
     * The trace identifier for request tracking.
     * </p>
     * 
     * @return The trace identifier for request tracking.
     */
    public final String traceId() {
        return traceId;
    }

    /**
     * <p>
     * The parent trace information for distributed tracing.
     * </p>
     * 
     * @return The parent trace information for distributed tracing.
     */
    public final String traceParent() {
        return traceParent;
    }

    /**
     * <p>
     * The trace state information for distributed tracing.
     * </p>
     * 
     * @return The trace state information for distributed tracing.
     */
    public final String traceState() {
        return traceState;
    }

    /**
     * <p>
     * Additional context information for distributed tracing.
     * </p>
     * 
     * @return Additional context information for distributed tracing.
     */
    public final String baggage() {
        return baggage;
    }

    /**
     * <p>
     * The MIME type of the response data. This indicates how to interpret the response data. Common values include
     * application/json for JSON data.
     * </p>
     * 
     * @return The MIME type of the response data. This indicates how to interpret the response data. Common values
     *         include application/json for JSON data.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The HTTP status code of the response. A status code of 200 indicates a successful operation. Other status codes
     * indicate various error conditions.
     * </p>
     * 
     * @return The HTTP status code of the response. A status code of 200 indicates a successful operation. Other status
     *         codes indicate various error conditions.
     */
    public final Integer statusCode() {
        return statusCodeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(runtimeSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(mcpSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(mcpProtocolVersion());
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        hashCode = 31 * hashCode + Objects.hashCode(traceParent());
        hashCode = 31 * hashCode + Objects.hashCode(traceState());
        hashCode = 31 * hashCode + Objects.hashCode(baggage());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAgentRuntimeResponse)) {
            return false;
        }
        InvokeAgentRuntimeResponse other = (InvokeAgentRuntimeResponse) obj;
        return Objects.equals(runtimeSessionId(), other.runtimeSessionId())
                && Objects.equals(mcpSessionId(), other.mcpSessionId())
                && Objects.equals(mcpProtocolVersion(), other.mcpProtocolVersion()) && Objects.equals(traceId(), other.traceId())
                && Objects.equals(traceParent(), other.traceParent()) && Objects.equals(traceState(), other.traceState())
                && Objects.equals(baggage(), other.baggage()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(statusCode(), other.statusCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeAgentRuntimeResponse").add("RuntimeSessionId", runtimeSessionId())
                .add("McpSessionId", mcpSessionId()).add("McpProtocolVersion", mcpProtocolVersion()).add("TraceId", traceId())
                .add("TraceParent", traceParent()).add("TraceState", traceState()).add("Baggage", baggage())
                .add("ContentType", contentType()).add("StatusCode", statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "runtimeSessionId":
            return Optional.ofNullable(clazz.cast(runtimeSessionId()));
        case "mcpSessionId":
            return Optional.ofNullable(clazz.cast(mcpSessionId()));
        case "mcpProtocolVersion":
            return Optional.ofNullable(clazz.cast(mcpProtocolVersion()));
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        case "traceParent":
            return Optional.ofNullable(clazz.cast(traceParent()));
        case "traceState":
            return Optional.ofNullable(clazz.cast(traceState()));
        case "baggage":
            return Optional.ofNullable(clazz.cast(baggage()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("X-Amzn-Bedrock-AgentCore-Runtime-Session-Id", RUNTIME_SESSION_ID_FIELD);
        map.put("Mcp-Session-Id", MCP_SESSION_ID_FIELD);
        map.put("Mcp-Protocol-Version", MCP_PROTOCOL_VERSION_FIELD);
        map.put("X-Amzn-Trace-Id", TRACE_ID_FIELD);
        map.put("traceparent", TRACE_PARENT_FIELD);
        map.put("tracestate", TRACE_STATE_FIELD);
        map.put("baggage", BAGGAGE_FIELD);
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("statusCode", STATUS_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeAgentRuntimeResponse, T> g) {
        return obj -> g.apply((InvokeAgentRuntimeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeAgentRuntimeResponse> {
        /**
         * <p>
         * The identifier of the runtime session.
         * </p>
         * 
         * @param runtimeSessionId
         *        The identifier of the runtime session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeSessionId(String runtimeSessionId);

        /**
         * <p>
         * The identifier of the MCP session.
         * </p>
         * 
         * @param mcpSessionId
         *        The identifier of the MCP session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcpSessionId(String mcpSessionId);

        /**
         * <p>
         * The version of the MCP protocol being used.
         * </p>
         * 
         * @param mcpProtocolVersion
         *        The version of the MCP protocol being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcpProtocolVersion(String mcpProtocolVersion);

        /**
         * <p>
         * The trace identifier for request tracking.
         * </p>
         * 
         * @param traceId
         *        The trace identifier for request tracking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);

        /**
         * <p>
         * The parent trace information for distributed tracing.
         * </p>
         * 
         * @param traceParent
         *        The parent trace information for distributed tracing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceParent(String traceParent);

        /**
         * <p>
         * The trace state information for distributed tracing.
         * </p>
         * 
         * @param traceState
         *        The trace state information for distributed tracing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceState(String traceState);

        /**
         * <p>
         * Additional context information for distributed tracing.
         * </p>
         * 
         * @param baggage
         *        Additional context information for distributed tracing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baggage(String baggage);

        /**
         * <p>
         * The MIME type of the response data. This indicates how to interpret the response data. Common values include
         * application/json for JSON data.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the response data. This indicates how to interpret the response data. Common values
         *        include application/json for JSON data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The HTTP status code of the response. A status code of 200 indicates a successful operation. Other status
         * codes indicate various error conditions.
         * </p>
         * 
         * @param statusCodeValue
         *        The HTTP status code of the response. A status code of 200 indicates a successful operation. Other
         *        status codes indicate various error conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCodeValue);
    }

    static final class BuilderImpl extends BedrockAgentCoreResponse.BuilderImpl implements Builder {
        private String runtimeSessionId;

        private String mcpSessionId;

        private String mcpProtocolVersion;

        private String traceId;

        private String traceParent;

        private String traceState;

        private String baggage;

        private String contentType;

        private Integer statusCodeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeAgentRuntimeResponse model) {
            super(model);
            runtimeSessionId(model.runtimeSessionId);
            mcpSessionId(model.mcpSessionId);
            mcpProtocolVersion(model.mcpProtocolVersion);
            traceId(model.traceId);
            traceParent(model.traceParent);
            traceState(model.traceState);
            baggage(model.baggage);
            contentType(model.contentType);
            statusCode(model.statusCodeValue);
        }

        public final String getRuntimeSessionId() {
            return runtimeSessionId;
        }

        public final void setRuntimeSessionId(String runtimeSessionId) {
            this.runtimeSessionId = runtimeSessionId;
        }

        @Override
        public final Builder runtimeSessionId(String runtimeSessionId) {
            this.runtimeSessionId = runtimeSessionId;
            return this;
        }

        public final String getMcpSessionId() {
            return mcpSessionId;
        }

        public final void setMcpSessionId(String mcpSessionId) {
            this.mcpSessionId = mcpSessionId;
        }

        @Override
        public final Builder mcpSessionId(String mcpSessionId) {
            this.mcpSessionId = mcpSessionId;
            return this;
        }

        public final String getMcpProtocolVersion() {
            return mcpProtocolVersion;
        }

        public final void setMcpProtocolVersion(String mcpProtocolVersion) {
            this.mcpProtocolVersion = mcpProtocolVersion;
        }

        @Override
        public final Builder mcpProtocolVersion(String mcpProtocolVersion) {
            this.mcpProtocolVersion = mcpProtocolVersion;
            return this;
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getTraceParent() {
            return traceParent;
        }

        public final void setTraceParent(String traceParent) {
            this.traceParent = traceParent;
        }

        @Override
        public final Builder traceParent(String traceParent) {
            this.traceParent = traceParent;
            return this;
        }

        public final String getTraceState() {
            return traceState;
        }

        public final void setTraceState(String traceState) {
            this.traceState = traceState;
        }

        @Override
        public final Builder traceState(String traceState) {
            this.traceState = traceState;
            return this;
        }

        public final String getBaggage() {
            return baggage;
        }

        public final void setBaggage(String baggage) {
            this.baggage = baggage;
        }

        @Override
        public final Builder baggage(String baggage) {
            this.baggage = baggage;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Integer getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public InvokeAgentRuntimeResponse build() {
            return new InvokeAgentRuntimeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
