/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeAgentRuntimeRequest extends BedrockAgentCoreRequest implements
        ToCopyableBuilder<InvokeAgentRuntimeRequest.Builder, InvokeAgentRuntimeRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(InvokeAgentRuntimeRequest::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("accept")
            .getter(getter(InvokeAgentRuntimeRequest::accept)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()).build();

    private static final SdkField<String> MCP_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mcpSessionId").getter(getter(InvokeAgentRuntimeRequest::mcpSessionId))
            .setter(setter(Builder::mcpSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Mcp-Session-Id").build()).build();

    private static final SdkField<String> RUNTIME_SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("runtimeSessionId")
            .getter(getter(InvokeAgentRuntimeRequest::runtimeSessionId))
            .setter(setter(Builder::runtimeSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("X-Amzn-Bedrock-AgentCore-Runtime-Session-Id").build(), DefaultValueTrait.idempotencyToken())
            .build();

    private static final SdkField<String> MCP_PROTOCOL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mcpProtocolVersion").getter(getter(InvokeAgentRuntimeRequest::mcpProtocolVersion))
            .setter(setter(Builder::mcpProtocolVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Mcp-Protocol-Version").build())
            .build();

    private static final SdkField<String> RUNTIME_USER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("runtimeUserId")
            .getter(getter(InvokeAgentRuntimeRequest::runtimeUserId))
            .setter(setter(Builder::runtimeUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("X-Amzn-Bedrock-AgentCore-Runtime-User-Id").build()).build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(InvokeAgentRuntimeRequest::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Trace-Id").build()).build();

    private static final SdkField<String> TRACE_PARENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceParent").getter(getter(InvokeAgentRuntimeRequest::traceParent))
            .setter(setter(Builder::traceParent))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("traceparent").build()).build();

    private static final SdkField<String> TRACE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceState").getter(getter(InvokeAgentRuntimeRequest::traceState)).setter(setter(Builder::traceState))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("tracestate").build()).build();

    private static final SdkField<String> BAGGAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("baggage")
            .getter(getter(InvokeAgentRuntimeRequest::baggage)).setter(setter(Builder::baggage))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("baggage").build()).build();

    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeArn").getter(getter(InvokeAgentRuntimeRequest::agentRuntimeArn))
            .setter(setter(Builder::agentRuntimeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentRuntimeArn").build()).build();

    private static final SdkField<String> QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("qualifier").getter(getter(InvokeAgentRuntimeRequest::qualifier)).setter(setter(Builder::qualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("qualifier").build()).build();

    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("payload")
            .getter(getter(InvokeAgentRuntimeRequest::payload))
            .setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            ACCEPT_FIELD, MCP_SESSION_ID_FIELD, RUNTIME_SESSION_ID_FIELD, MCP_PROTOCOL_VERSION_FIELD, RUNTIME_USER_ID_FIELD,
            TRACE_ID_FIELD, TRACE_PARENT_FIELD, TRACE_STATE_FIELD, BAGGAGE_FIELD, AGENT_RUNTIME_ARN_FIELD, QUALIFIER_FIELD,
            PAYLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contentType;

    private final String accept;

    private final String mcpSessionId;

    private final String runtimeSessionId;

    private final String mcpProtocolVersion;

    private final String runtimeUserId;

    private final String traceId;

    private final String traceParent;

    private final String traceState;

    private final String baggage;

    private final String agentRuntimeArn;

    private final String qualifier;

    private final SdkBytes payload;

    private InvokeAgentRuntimeRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.accept = builder.accept;
        this.mcpSessionId = builder.mcpSessionId;
        this.runtimeSessionId = builder.runtimeSessionId;
        this.mcpProtocolVersion = builder.mcpProtocolVersion;
        this.runtimeUserId = builder.runtimeUserId;
        this.traceId = builder.traceId;
        this.traceParent = builder.traceParent;
        this.traceState = builder.traceState;
        this.baggage = builder.baggage;
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.qualifier = builder.qualifier;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The MIME type of the input data in the payload. This tells the agent runtime how to interpret the payload data.
     * Common values include application/json for JSON data.
     * </p>
     * 
     * @return The MIME type of the input data in the payload. This tells the agent runtime how to interpret the payload
     *         data. Common values include application/json for JSON data.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The desired MIME type for the response from the agent runtime. This tells the agent runtime what format to use
     * for the response data. Common values include application/json for JSON data.
     * </p>
     * 
     * @return The desired MIME type for the response from the agent runtime. This tells the agent runtime what format
     *         to use for the response data. Common values include application/json for JSON data.
     */
    public final String accept() {
        return accept;
    }

    /**
     * <p>
     * The identifier of the MCP session.
     * </p>
     * 
     * @return The identifier of the MCP session.
     */
    public final String mcpSessionId() {
        return mcpSessionId;
    }

    /**
     * <p>
     * The identifier of the runtime session.
     * </p>
     * 
     * @return The identifier of the runtime session.
     */
    public final String runtimeSessionId() {
        return runtimeSessionId;
    }

    /**
     * <p>
     * The version of the MCP protocol being used.
     * </p>
     * 
     * @return The version of the MCP protocol being used.
     */
    public final String mcpProtocolVersion() {
        return mcpProtocolVersion;
    }

    /**
     * <p>
     * The identifier of the runtime user.
     * </p>
     * 
     * @return The identifier of the runtime user.
     */
    public final String runtimeUserId() {
        return runtimeUserId;
    }

    /**
     * <p>
     * The trace identifier for request tracking.
     * </p>
     * 
     * @return The trace identifier for request tracking.
     */
    public final String traceId() {
        return traceId;
    }

    /**
     * <p>
     * The parent trace information for distributed tracing.
     * </p>
     * 
     * @return The parent trace information for distributed tracing.
     */
    public final String traceParent() {
        return traceParent;
    }

    /**
     * <p>
     * The trace state information for distributed tracing.
     * </p>
     * 
     * @return The trace state information for distributed tracing.
     */
    public final String traceState() {
        return traceState;
    }

    /**
     * <p>
     * Additional context information for distributed tracing.
     * </p>
     * 
     * @return Additional context information for distributed tracing.
     */
    public final String baggage() {
        return baggage;
    }

    /**
     * <p>
     * The Amazon Web Services Resource Name (ARN) of the agent runtime to invoke. The ARN uniquely identifies the agent
     * runtime resource in Amazon Bedrock.
     * </p>
     * 
     * @return The Amazon Web Services Resource Name (ARN) of the agent runtime to invoke. The ARN uniquely identifies
     *         the agent runtime resource in Amazon Bedrock.
     */
    public final String agentRuntimeArn() {
        return agentRuntimeArn;
    }

    /**
     * <p>
     * The qualifier to use for the agent runtime. This can be a version number or an endpoint name that points to a
     * specific version. If not specified, Amazon Bedrock uses the default version of the agent runtime.
     * </p>
     * 
     * @return The qualifier to use for the agent runtime. This can be a version number or an endpoint name that points
     *         to a specific version. If not specified, Amazon Bedrock uses the default version of the agent runtime.
     */
    public final String qualifier() {
        return qualifier;
    }

    /**
     * <p>
     * The input data to send to the agent runtime. The format of this data depends on the specific agent configuration
     * and must match the specified content type. For most agents, this is a JSON object containing the user's request.
     * </p>
     * 
     * @return The input data to send to the agent runtime. The format of this data depends on the specific agent
     *         configuration and must match the specified content type. For most agents, this is a JSON object
     *         containing the user's request.
     */
    public final SdkBytes payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(accept());
        hashCode = 31 * hashCode + Objects.hashCode(mcpSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(mcpProtocolVersion());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeUserId());
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        hashCode = 31 * hashCode + Objects.hashCode(traceParent());
        hashCode = 31 * hashCode + Objects.hashCode(traceState());
        hashCode = 31 * hashCode + Objects.hashCode(baggage());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAgentRuntimeRequest)) {
            return false;
        }
        InvokeAgentRuntimeRequest other = (InvokeAgentRuntimeRequest) obj;
        return Objects.equals(contentType(), other.contentType()) && Objects.equals(accept(), other.accept())
                && Objects.equals(mcpSessionId(), other.mcpSessionId())
                && Objects.equals(runtimeSessionId(), other.runtimeSessionId())
                && Objects.equals(mcpProtocolVersion(), other.mcpProtocolVersion())
                && Objects.equals(runtimeUserId(), other.runtimeUserId()) && Objects.equals(traceId(), other.traceId())
                && Objects.equals(traceParent(), other.traceParent()) && Objects.equals(traceState(), other.traceState())
                && Objects.equals(baggage(), other.baggage()) && Objects.equals(agentRuntimeArn(), other.agentRuntimeArn())
                && Objects.equals(qualifier(), other.qualifier()) && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeAgentRuntimeRequest").add("ContentType", contentType()).add("Accept", accept())
                .add("McpSessionId", mcpSessionId()).add("RuntimeSessionId", runtimeSessionId())
                .add("McpProtocolVersion", mcpProtocolVersion()).add("RuntimeUserId", runtimeUserId()).add("TraceId", traceId())
                .add("TraceParent", traceParent()).add("TraceState", traceState()).add("Baggage", baggage())
                .add("AgentRuntimeArn", agentRuntimeArn()).add("Qualifier", qualifier())
                .add("Payload", payload() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "accept":
            return Optional.ofNullable(clazz.cast(accept()));
        case "mcpSessionId":
            return Optional.ofNullable(clazz.cast(mcpSessionId()));
        case "runtimeSessionId":
            return Optional.ofNullable(clazz.cast(runtimeSessionId()));
        case "mcpProtocolVersion":
            return Optional.ofNullable(clazz.cast(mcpProtocolVersion()));
        case "runtimeUserId":
            return Optional.ofNullable(clazz.cast(runtimeUserId()));
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        case "traceParent":
            return Optional.ofNullable(clazz.cast(traceParent()));
        case "traceState":
            return Optional.ofNullable(clazz.cast(traceState()));
        case "baggage":
            return Optional.ofNullable(clazz.cast(baggage()));
        case "agentRuntimeArn":
            return Optional.ofNullable(clazz.cast(agentRuntimeArn()));
        case "qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("Accept", ACCEPT_FIELD);
        map.put("Mcp-Session-Id", MCP_SESSION_ID_FIELD);
        map.put("X-Amzn-Bedrock-AgentCore-Runtime-Session-Id", RUNTIME_SESSION_ID_FIELD);
        map.put("Mcp-Protocol-Version", MCP_PROTOCOL_VERSION_FIELD);
        map.put("X-Amzn-Bedrock-AgentCore-Runtime-User-Id", RUNTIME_USER_ID_FIELD);
        map.put("X-Amzn-Trace-Id", TRACE_ID_FIELD);
        map.put("traceparent", TRACE_PARENT_FIELD);
        map.put("tracestate", TRACE_STATE_FIELD);
        map.put("baggage", BAGGAGE_FIELD);
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("qualifier", QUALIFIER_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeAgentRuntimeRequest, T> g) {
        return obj -> g.apply((InvokeAgentRuntimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeAgentRuntimeRequest> {
        /**
         * <p>
         * The MIME type of the input data in the payload. This tells the agent runtime how to interpret the payload
         * data. Common values include application/json for JSON data.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the input data in the payload. This tells the agent runtime how to interpret the
         *        payload data. Common values include application/json for JSON data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The desired MIME type for the response from the agent runtime. This tells the agent runtime what format to
         * use for the response data. Common values include application/json for JSON data.
         * </p>
         * 
         * @param accept
         *        The desired MIME type for the response from the agent runtime. This tells the agent runtime what
         *        format to use for the response data. Common values include application/json for JSON data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accept(String accept);

        /**
         * <p>
         * The identifier of the MCP session.
         * </p>
         * 
         * @param mcpSessionId
         *        The identifier of the MCP session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcpSessionId(String mcpSessionId);

        /**
         * <p>
         * The identifier of the runtime session.
         * </p>
         * 
         * @param runtimeSessionId
         *        The identifier of the runtime session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeSessionId(String runtimeSessionId);

        /**
         * <p>
         * The version of the MCP protocol being used.
         * </p>
         * 
         * @param mcpProtocolVersion
         *        The version of the MCP protocol being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcpProtocolVersion(String mcpProtocolVersion);

        /**
         * <p>
         * The identifier of the runtime user.
         * </p>
         * 
         * @param runtimeUserId
         *        The identifier of the runtime user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeUserId(String runtimeUserId);

        /**
         * <p>
         * The trace identifier for request tracking.
         * </p>
         * 
         * @param traceId
         *        The trace identifier for request tracking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);

        /**
         * <p>
         * The parent trace information for distributed tracing.
         * </p>
         * 
         * @param traceParent
         *        The parent trace information for distributed tracing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceParent(String traceParent);

        /**
         * <p>
         * The trace state information for distributed tracing.
         * </p>
         * 
         * @param traceState
         *        The trace state information for distributed tracing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceState(String traceState);

        /**
         * <p>
         * Additional context information for distributed tracing.
         * </p>
         * 
         * @param baggage
         *        Additional context information for distributed tracing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baggage(String baggage);

        /**
         * <p>
         * The Amazon Web Services Resource Name (ARN) of the agent runtime to invoke. The ARN uniquely identifies the
         * agent runtime resource in Amazon Bedrock.
         * </p>
         * 
         * @param agentRuntimeArn
         *        The Amazon Web Services Resource Name (ARN) of the agent runtime to invoke. The ARN uniquely
         *        identifies the agent runtime resource in Amazon Bedrock.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeArn(String agentRuntimeArn);

        /**
         * <p>
         * The qualifier to use for the agent runtime. This can be a version number or an endpoint name that points to a
         * specific version. If not specified, Amazon Bedrock uses the default version of the agent runtime.
         * </p>
         * 
         * @param qualifier
         *        The qualifier to use for the agent runtime. This can be a version number or an endpoint name that
         *        points to a specific version. If not specified, Amazon Bedrock uses the default version of the agent
         *        runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        /**
         * <p>
         * The input data to send to the agent runtime. The format of this data depends on the specific agent
         * configuration and must match the specified content type. For most agents, this is a JSON object containing
         * the user's request.
         * </p>
         * 
         * @param payload
         *        The input data to send to the agent runtime. The format of this data depends on the specific agent
         *        configuration and must match the specified content type. For most agents, this is a JSON object
         *        containing the user's request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreRequest.BuilderImpl implements Builder {
        private String contentType;

        private String accept;

        private String mcpSessionId;

        private String runtimeSessionId;

        private String mcpProtocolVersion;

        private String runtimeUserId;

        private String traceId;

        private String traceParent;

        private String traceState;

        private String baggage;

        private String agentRuntimeArn;

        private String qualifier;

        private SdkBytes payload;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeAgentRuntimeRequest model) {
            super(model);
            contentType(model.contentType);
            accept(model.accept);
            mcpSessionId(model.mcpSessionId);
            runtimeSessionId(model.runtimeSessionId);
            mcpProtocolVersion(model.mcpProtocolVersion);
            runtimeUserId(model.runtimeUserId);
            traceId(model.traceId);
            traceParent(model.traceParent);
            traceState(model.traceState);
            baggage(model.baggage);
            agentRuntimeArn(model.agentRuntimeArn);
            qualifier(model.qualifier);
            payload(model.payload);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getAccept() {
            return accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final String getMcpSessionId() {
            return mcpSessionId;
        }

        public final void setMcpSessionId(String mcpSessionId) {
            this.mcpSessionId = mcpSessionId;
        }

        @Override
        public final Builder mcpSessionId(String mcpSessionId) {
            this.mcpSessionId = mcpSessionId;
            return this;
        }

        public final String getRuntimeSessionId() {
            return runtimeSessionId;
        }

        public final void setRuntimeSessionId(String runtimeSessionId) {
            this.runtimeSessionId = runtimeSessionId;
        }

        @Override
        public final Builder runtimeSessionId(String runtimeSessionId) {
            this.runtimeSessionId = runtimeSessionId;
            return this;
        }

        public final String getMcpProtocolVersion() {
            return mcpProtocolVersion;
        }

        public final void setMcpProtocolVersion(String mcpProtocolVersion) {
            this.mcpProtocolVersion = mcpProtocolVersion;
        }

        @Override
        public final Builder mcpProtocolVersion(String mcpProtocolVersion) {
            this.mcpProtocolVersion = mcpProtocolVersion;
            return this;
        }

        public final String getRuntimeUserId() {
            return runtimeUserId;
        }

        public final void setRuntimeUserId(String runtimeUserId) {
            this.runtimeUserId = runtimeUserId;
        }

        @Override
        public final Builder runtimeUserId(String runtimeUserId) {
            this.runtimeUserId = runtimeUserId;
            return this;
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getTraceParent() {
            return traceParent;
        }

        public final void setTraceParent(String traceParent) {
            this.traceParent = traceParent;
        }

        @Override
        public final Builder traceParent(String traceParent) {
            this.traceParent = traceParent;
            return this;
        }

        public final String getTraceState() {
            return traceState;
        }

        public final void setTraceState(String traceState) {
            this.traceState = traceState;
        }

        @Override
        public final Builder traceState(String traceState) {
            this.traceState = traceState;
            return this;
        }

        public final String getBaggage() {
            return baggage;
        }

        public final void setBaggage(String baggage) {
            this.baggage = baggage;
        }

        @Override
        public final Builder baggage(String baggage) {
            this.baggage = baggage;
            return this;
        }

        public final String getAgentRuntimeArn() {
            return agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getQualifier() {
            return qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeAgentRuntimeRequest build() {
            return new InvokeAgentRuntimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
