/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceApiKeyRequest extends BedrockAgentCoreRequest implements
        ToCopyableBuilder<GetResourceApiKeyRequest.Builder, GetResourceApiKeyRequest> {
    private static final SdkField<String> WORKLOAD_IDENTITY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadIdentityToken").getter(getter(GetResourceApiKeyRequest::workloadIdentityToken))
            .setter(setter(Builder::workloadIdentityToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityToken").build())
            .build();

    private static final SdkField<String> RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceCredentialProviderName")
            .getter(getter(GetResourceApiKeyRequest::resourceCredentialProviderName))
            .setter(setter(Builder::resourceCredentialProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCredentialProviderName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_IDENTITY_TOKEN_FIELD,
            RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workloadIdentityToken;

    private final String resourceCredentialProviderName;

    private GetResourceApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.workloadIdentityToken = builder.workloadIdentityToken;
        this.resourceCredentialProviderName = builder.resourceCredentialProviderName;
    }

    /**
     * <p>
     * The identity token of the workload you want to get the API Key of.
     * </p>
     * 
     * @return The identity token of the workload you want to get the API Key of.
     */
    public final String workloadIdentityToken() {
        return workloadIdentityToken;
    }

    /**
     * <p>
     * The credential provider name of the resource you are retrieving the API Key of.
     * </p>
     * 
     * @return The credential provider name of the resource you are retrieving the API Key of.
     */
    public final String resourceCredentialProviderName() {
        return resourceCredentialProviderName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadIdentityToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCredentialProviderName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceApiKeyRequest)) {
            return false;
        }
        GetResourceApiKeyRequest other = (GetResourceApiKeyRequest) obj;
        return Objects.equals(workloadIdentityToken(), other.workloadIdentityToken())
                && Objects.equals(resourceCredentialProviderName(), other.resourceCredentialProviderName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceApiKeyRequest")
                .add("WorkloadIdentityToken", workloadIdentityToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResourceCredentialProviderName", resourceCredentialProviderName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workloadIdentityToken":
            return Optional.ofNullable(clazz.cast(workloadIdentityToken()));
        case "resourceCredentialProviderName":
            return Optional.ofNullable(clazz.cast(resourceCredentialProviderName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workloadIdentityToken", WORKLOAD_IDENTITY_TOKEN_FIELD);
        map.put("resourceCredentialProviderName", RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceApiKeyRequest, T> g) {
        return obj -> g.apply((GetResourceApiKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceApiKeyRequest> {
        /**
         * <p>
         * The identity token of the workload you want to get the API Key of.
         * </p>
         * 
         * @param workloadIdentityToken
         *        The identity token of the workload you want to get the API Key of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadIdentityToken(String workloadIdentityToken);

        /**
         * <p>
         * The credential provider name of the resource you are retrieving the API Key of.
         * </p>
         * 
         * @param resourceCredentialProviderName
         *        The credential provider name of the resource you are retrieving the API Key of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCredentialProviderName(String resourceCredentialProviderName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreRequest.BuilderImpl implements Builder {
        private String workloadIdentityToken;

        private String resourceCredentialProviderName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceApiKeyRequest model) {
            super(model);
            workloadIdentityToken(model.workloadIdentityToken);
            resourceCredentialProviderName(model.resourceCredentialProviderName);
        }

        public final String getWorkloadIdentityToken() {
            return workloadIdentityToken;
        }

        public final void setWorkloadIdentityToken(String workloadIdentityToken) {
            this.workloadIdentityToken = workloadIdentityToken;
        }

        @Override
        public final Builder workloadIdentityToken(String workloadIdentityToken) {
            this.workloadIdentityToken = workloadIdentityToken;
            return this;
        }

        public final String getResourceCredentialProviderName() {
            return resourceCredentialProviderName;
        }

        public final void setResourceCredentialProviderName(String resourceCredentialProviderName) {
            this.resourceCredentialProviderName = resourceCredentialProviderName;
        }

        @Override
        public final Builder resourceCredentialProviderName(String resourceCredentialProviderName) {
            this.resourceCredentialProviderName = resourceCredentialProviderName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceApiKeyRequest build() {
            return new GetResourceApiKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
