/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEventRequest extends BedrockAgentCoreRequest implements
        ToCopyableBuilder<GetEventRequest.Builder, GetEventRequest> {
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryId").getter(getter(GetEventRequest::memoryId)).setter(setter(Builder::memoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("memoryId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(GetEventRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<String> ACTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actorId").getter(getter(GetEventRequest::actorId)).setter(setter(Builder::actorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("actorId").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(GetEventRequest::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("eventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_ID_FIELD,
            SESSION_ID_FIELD, ACTOR_ID_FIELD, EVENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String memoryId;

    private final String sessionId;

    private final String actorId;

    private final String eventId;

    private GetEventRequest(BuilderImpl builder) {
        super(builder);
        this.memoryId = builder.memoryId;
        this.sessionId = builder.sessionId;
        this.actorId = builder.actorId;
        this.eventId = builder.eventId;
    }

    /**
     * <p>
     * The identifier of the AgentCore Memory resource containing the event.
     * </p>
     * 
     * @return The identifier of the AgentCore Memory resource containing the event.
     */
    public final String memoryId() {
        return memoryId;
    }

    /**
     * <p>
     * The identifier of the session containing the event.
     * </p>
     * 
     * @return The identifier of the session containing the event.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The identifier of the actor associated with the event.
     * </p>
     * 
     * @return The identifier of the actor associated with the event.
     */
    public final String actorId() {
        return actorId;
    }

    /**
     * <p>
     * The identifier of the event to retrieve.
     * </p>
     * 
     * @return The identifier of the event to retrieve.
     */
    public final String eventId() {
        return eventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(actorId());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventRequest)) {
            return false;
        }
        GetEventRequest other = (GetEventRequest) obj;
        return Objects.equals(memoryId(), other.memoryId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(actorId(), other.actorId()) && Objects.equals(eventId(), other.eventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEventRequest").add("MemoryId", memoryId()).add("SessionId", sessionId())
                .add("ActorId", actorId()).add("EventId", eventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memoryId":
            return Optional.ofNullable(clazz.cast(memoryId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "actorId":
            return Optional.ofNullable(clazz.cast(actorId()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("actorId", ACTOR_ID_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEventRequest, T> g) {
        return obj -> g.apply((GetEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetEventRequest> {
        /**
         * <p>
         * The identifier of the AgentCore Memory resource containing the event.
         * </p>
         * 
         * @param memoryId
         *        The identifier of the AgentCore Memory resource containing the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryId(String memoryId);

        /**
         * <p>
         * The identifier of the session containing the event.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session containing the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The identifier of the actor associated with the event.
         * </p>
         * 
         * @param actorId
         *        The identifier of the actor associated with the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actorId(String actorId);

        /**
         * <p>
         * The identifier of the event to retrieve.
         * </p>
         * 
         * @param eventId
         *        The identifier of the event to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreRequest.BuilderImpl implements Builder {
        private String memoryId;

        private String sessionId;

        private String actorId;

        private String eventId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventRequest model) {
            super(model);
            memoryId(model.memoryId);
            sessionId(model.sessionId);
            actorId(model.actorId);
            eventId(model.eventId);
        }

        public final String getMemoryId() {
            return memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getActorId() {
            return actorId;
        }

        public final void setActorId(String actorId) {
            this.actorId = actorId;
        }

        @Override
        public final Builder actorId(String actorId) {
            this.actorId = actorId;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEventRequest build() {
            return new GetEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
