/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBrowserSessionResponse extends BedrockAgentCoreResponse implements
        ToCopyableBuilder<GetBrowserSessionResponse.Builder, GetBrowserSessionResponse> {
    private static final SdkField<String> BROWSER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserIdentifier").getter(getter(GetBrowserSessionResponse::browserIdentifier))
            .setter(setter(Builder::browserIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserIdentifier").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(GetBrowserSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetBrowserSessionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetBrowserSessionResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ViewPort> VIEW_PORT_FIELD = SdkField.<ViewPort> builder(MarshallingType.SDK_POJO)
            .memberName("viewPort").getter(getter(GetBrowserSessionResponse::viewPort)).setter(setter(Builder::viewPort))
            .constructor(ViewPort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewPort").build()).build();

    private static final SdkField<Integer> SESSION_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sessionTimeoutSeconds").getter(getter(GetBrowserSessionResponse::sessionTimeoutSeconds))
            .setter(setter(Builder::sessionTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionTimeoutSeconds").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetBrowserSessionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<BrowserSessionStream> STREAMS_FIELD = SdkField
            .<BrowserSessionStream> builder(MarshallingType.SDK_POJO).memberName("streams")
            .getter(getter(GetBrowserSessionResponse::streams)).setter(setter(Builder::streams))
            .constructor(BrowserSessionStream::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streams").build()).build();

    private static final SdkField<String> SESSION_REPLAY_ARTIFACT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionReplayArtifact").getter(getter(GetBrowserSessionResponse::sessionReplayArtifact))
            .setter(setter(Builder::sessionReplayArtifact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionReplayArtifact").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetBrowserSessionResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_IDENTIFIER_FIELD,
            SESSION_ID_FIELD, NAME_FIELD, CREATED_AT_FIELD, VIEW_PORT_FIELD, SESSION_TIMEOUT_SECONDS_FIELD, STATUS_FIELD,
            STREAMS_FIELD, SESSION_REPLAY_ARTIFACT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String browserIdentifier;

    private final String sessionId;

    private final String name;

    private final Instant createdAt;

    private final ViewPort viewPort;

    private final Integer sessionTimeoutSeconds;

    private final String status;

    private final BrowserSessionStream streams;

    private final String sessionReplayArtifact;

    private final Instant lastUpdatedAt;

    private GetBrowserSessionResponse(BuilderImpl builder) {
        super(builder);
        this.browserIdentifier = builder.browserIdentifier;
        this.sessionId = builder.sessionId;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.viewPort = builder.viewPort;
        this.sessionTimeoutSeconds = builder.sessionTimeoutSeconds;
        this.status = builder.status;
        this.streams = builder.streams;
        this.sessionReplayArtifact = builder.sessionReplayArtifact;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The identifier of the browser.
     * </p>
     * 
     * @return The identifier of the browser.
     */
    public final String browserIdentifier() {
        return browserIdentifier;
    }

    /**
     * <p>
     * The identifier of the browser session.
     * </p>
     * 
     * @return The identifier of the browser session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The name of the browser session.
     * </p>
     * 
     * @return The name of the browser session.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time at which the browser session was created.
     * </p>
     * 
     * @return The time at which the browser session was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the ViewPort property for this object.
     * 
     * @return The value of the ViewPort property for this object.
     */
    public final ViewPort viewPort() {
        return viewPort;
    }

    /**
     * <p>
     * The timeout period for the browser session in seconds.
     * </p>
     * 
     * @return The timeout period for the browser session in seconds.
     */
    public final Integer sessionTimeoutSeconds() {
        return sessionTimeoutSeconds;
    }

    /**
     * <p>
     * The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BrowserSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
     * @see BrowserSessionStatus
     */
    public final BrowserSessionStatus status() {
        return BrowserSessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BrowserSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
     * @see BrowserSessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The streams associated with this browser session. These include the automation stream and live view stream.
     * </p>
     * 
     * @return The streams associated with this browser session. These include the automation stream and live view
     *         stream.
     */
    public final BrowserSessionStream streams() {
        return streams;
    }

    /**
     * <p>
     * The artifact containing the session replay information.
     * </p>
     * 
     * @return The artifact containing the session replay information.
     */
    public final String sessionReplayArtifact() {
        return sessionReplayArtifact;
    }

    /**
     * <p>
     * The time at which the browser session was last updated.
     * </p>
     * 
     * @return The time at which the browser session was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(browserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(viewPort());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streams());
        hashCode = 31 * hashCode + Objects.hashCode(sessionReplayArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBrowserSessionResponse)) {
            return false;
        }
        GetBrowserSessionResponse other = (GetBrowserSessionResponse) obj;
        return Objects.equals(browserIdentifier(), other.browserIdentifier()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(name(), other.name()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(viewPort(), other.viewPort())
                && Objects.equals(sessionTimeoutSeconds(), other.sessionTimeoutSeconds())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(streams(), other.streams())
                && Objects.equals(sessionReplayArtifact(), other.sessionReplayArtifact())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBrowserSessionResponse").add("BrowserIdentifier", browserIdentifier())
                .add("SessionId", sessionId()).add("Name", name()).add("CreatedAt", createdAt()).add("ViewPort", viewPort())
                .add("SessionTimeoutSeconds", sessionTimeoutSeconds()).add("Status", statusAsString()).add("Streams", streams())
                .add("SessionReplayArtifact", sessionReplayArtifact()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserIdentifier":
            return Optional.ofNullable(clazz.cast(browserIdentifier()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "viewPort":
            return Optional.ofNullable(clazz.cast(viewPort()));
        case "sessionTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(sessionTimeoutSeconds()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "streams":
            return Optional.ofNullable(clazz.cast(streams()));
        case "sessionReplayArtifact":
            return Optional.ofNullable(clazz.cast(sessionReplayArtifact()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("browserIdentifier", BROWSER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("viewPort", VIEW_PORT_FIELD);
        map.put("sessionTimeoutSeconds", SESSION_TIMEOUT_SECONDS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("streams", STREAMS_FIELD);
        map.put("sessionReplayArtifact", SESSION_REPLAY_ARTIFACT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBrowserSessionResponse, T> g) {
        return obj -> g.apply((GetBrowserSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBrowserSessionResponse> {
        /**
         * <p>
         * The identifier of the browser.
         * </p>
         * 
         * @param browserIdentifier
         *        The identifier of the browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserIdentifier(String browserIdentifier);

        /**
         * <p>
         * The identifier of the browser session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the browser session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The name of the browser session.
         * </p>
         * 
         * @param name
         *        The name of the browser session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time at which the browser session was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the browser session was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the ViewPort property for this object.
         *
         * @param viewPort
         *        The new value for the ViewPort property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewPort(ViewPort viewPort);

        /**
         * Sets the value of the ViewPort property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ViewPort.Builder} avoiding the need to
         * create one manually via {@link ViewPort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewPort.Builder#build()} is called immediately and its result is
         * passed to {@link #viewPort(ViewPort)}.
         * 
         * @param viewPort
         *        a consumer that will call methods on {@link ViewPort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewPort(ViewPort)
         */
        default Builder viewPort(Consumer<ViewPort.Builder> viewPort) {
            return viewPort(ViewPort.builder().applyMutation(viewPort).build());
        }

        /**
         * <p>
         * The timeout period for the browser session in seconds.
         * </p>
         * 
         * @param sessionTimeoutSeconds
         *        The timeout period for the browser session in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeoutSeconds(Integer sessionTimeoutSeconds);

        /**
         * <p>
         * The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
         * </p>
         * 
         * @param status
         *        The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
         * @see BrowserSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserSessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
         * </p>
         * 
         * @param status
         *        The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
         * @see BrowserSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserSessionStatus
         */
        Builder status(BrowserSessionStatus status);

        /**
         * <p>
         * The streams associated with this browser session. These include the automation stream and live view stream.
         * </p>
         * 
         * @param streams
         *        The streams associated with this browser session. These include the automation stream and live view
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(BrowserSessionStream streams);

        /**
         * <p>
         * The streams associated with this browser session. These include the automation stream and live view stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link BrowserSessionStream.Builder} avoiding
         * the need to create one manually via {@link BrowserSessionStream#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrowserSessionStream.Builder#build()} is called immediately and
         * its result is passed to {@link #streams(BrowserSessionStream)}.
         * 
         * @param streams
         *        a consumer that will call methods on {@link BrowserSessionStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streams(BrowserSessionStream)
         */
        default Builder streams(Consumer<BrowserSessionStream.Builder> streams) {
            return streams(BrowserSessionStream.builder().applyMutation(streams).build());
        }

        /**
         * <p>
         * The artifact containing the session replay information.
         * </p>
         * 
         * @param sessionReplayArtifact
         *        The artifact containing the session replay information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionReplayArtifact(String sessionReplayArtifact);

        /**
         * <p>
         * The time at which the browser session was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time at which the browser session was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl extends BedrockAgentCoreResponse.BuilderImpl implements Builder {
        private String browserIdentifier;

        private String sessionId;

        private String name;

        private Instant createdAt;

        private ViewPort viewPort;

        private Integer sessionTimeoutSeconds;

        private String status;

        private BrowserSessionStream streams;

        private String sessionReplayArtifact;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBrowserSessionResponse model) {
            super(model);
            browserIdentifier(model.browserIdentifier);
            sessionId(model.sessionId);
            name(model.name);
            createdAt(model.createdAt);
            viewPort(model.viewPort);
            sessionTimeoutSeconds(model.sessionTimeoutSeconds);
            status(model.status);
            streams(model.streams);
            sessionReplayArtifact(model.sessionReplayArtifact);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getBrowserIdentifier() {
            return browserIdentifier;
        }

        public final void setBrowserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
        }

        @Override
        public final Builder browserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ViewPort.Builder getViewPort() {
            return viewPort != null ? viewPort.toBuilder() : null;
        }

        public final void setViewPort(ViewPort.BuilderImpl viewPort) {
            this.viewPort = viewPort != null ? viewPort.build() : null;
        }

        @Override
        public final Builder viewPort(ViewPort viewPort) {
            this.viewPort = viewPort;
            return this;
        }

        public final Integer getSessionTimeoutSeconds() {
            return sessionTimeoutSeconds;
        }

        public final void setSessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
        }

        @Override
        public final Builder sessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BrowserSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final BrowserSessionStream.Builder getStreams() {
            return streams != null ? streams.toBuilder() : null;
        }

        public final void setStreams(BrowserSessionStream.BuilderImpl streams) {
            this.streams = streams != null ? streams.build() : null;
        }

        @Override
        public final Builder streams(BrowserSessionStream streams) {
            this.streams = streams;
            return this;
        }

        public final String getSessionReplayArtifact() {
            return sessionReplayArtifact;
        }

        public final void setSessionReplayArtifact(String sessionReplayArtifact) {
            this.sessionReplayArtifact = sessionReplayArtifact;
        }

        @Override
        public final Builder sessionReplayArtifact(String sessionReplayArtifact) {
            this.sessionReplayArtifact = sessionReplayArtifact;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public GetBrowserSessionResponse build() {
            return new GetBrowserSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
