/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains filter criteria for listing events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterInput implements SdkPojo, Serializable, ToCopyableBuilder<FilterInput.Builder, FilterInput> {
    private static final SdkField<BranchFilter> BRANCH_FIELD = SdkField.<BranchFilter> builder(MarshallingType.SDK_POJO)
            .memberName("branch").getter(getter(FilterInput::branch)).setter(setter(Builder::branch))
            .constructor(BranchFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BranchFilter branch;

    private FilterInput(BuilderImpl builder) {
        this.branch = builder.branch;
    }

    /**
     * <p>
     * The branch filter criteria to apply when listing events.
     * </p>
     * 
     * @return The branch filter criteria to apply when listing events.
     */
    public final BranchFilter branch() {
        return branch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterInput)) {
            return false;
        }
        FilterInput other = (FilterInput) obj;
        return Objects.equals(branch(), other.branch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterInput").add("Branch", branch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branch":
            return Optional.ofNullable(clazz.cast(branch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("branch", BRANCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterInput, T> g) {
        return obj -> g.apply((FilterInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterInput> {
        /**
         * <p>
         * The branch filter criteria to apply when listing events.
         * </p>
         * 
         * @param branch
         *        The branch filter criteria to apply when listing events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(BranchFilter branch);

        /**
         * <p>
         * The branch filter criteria to apply when listing events.
         * </p>
         * This is a convenience method that creates an instance of the {@link BranchFilter.Builder} avoiding the need
         * to create one manually via {@link BranchFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BranchFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #branch(BranchFilter)}.
         * 
         * @param branch
         *        a consumer that will call methods on {@link BranchFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #branch(BranchFilter)
         */
        default Builder branch(Consumer<BranchFilter.Builder> branch) {
            return branch(BranchFilter.builder().applyMutation(branch).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BranchFilter branch;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterInput model) {
            branch(model.branch);
        }

        public final BranchFilter.Builder getBranch() {
            return branch != null ? branch.toBuilder() : null;
        }

        public final void setBranch(BranchFilter.BuilderImpl branch) {
            this.branch = branch != null ? branch.build() : null;
        }

        @Override
        public final Builder branch(BranchFilter branch) {
            this.branch = branch;
            return this;
        }

        @Override
        public FilterInput build() {
            return new FilterInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
