/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMemoryRecordResponse extends BedrockAgentCoreResponse implements
        ToCopyableBuilder<DeleteMemoryRecordResponse.Builder, DeleteMemoryRecordResponse> {
    private static final SdkField<String> MEMORY_RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryRecordId").getter(getter(DeleteMemoryRecordResponse::memoryRecordId))
            .setter(setter(Builder::memoryRecordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryRecordId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_RECORD_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String memoryRecordId;

    private DeleteMemoryRecordResponse(BuilderImpl builder) {
        super(builder);
        this.memoryRecordId = builder.memoryRecordId;
    }

    /**
     * <p>
     * The identifier of the memory record that was deleted.
     * </p>
     * 
     * @return The identifier of the memory record that was deleted.
     */
    public final String memoryRecordId() {
        return memoryRecordId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(memoryRecordId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMemoryRecordResponse)) {
            return false;
        }
        DeleteMemoryRecordResponse other = (DeleteMemoryRecordResponse) obj;
        return Objects.equals(memoryRecordId(), other.memoryRecordId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteMemoryRecordResponse").add("MemoryRecordId", memoryRecordId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memoryRecordId":
            return Optional.ofNullable(clazz.cast(memoryRecordId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("memoryRecordId", MEMORY_RECORD_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteMemoryRecordResponse, T> g) {
        return obj -> g.apply((DeleteMemoryRecordResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteMemoryRecordResponse> {
        /**
         * <p>
         * The identifier of the memory record that was deleted.
         * </p>
         * 
         * @param memoryRecordId
         *        The identifier of the memory record that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryRecordId(String memoryRecordId);
    }

    static final class BuilderImpl extends BedrockAgentCoreResponse.BuilderImpl implements Builder {
        private String memoryRecordId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMemoryRecordResponse model) {
            super(model);
            memoryRecordId(model.memoryRecordId);
        }

        public final String getMemoryRecordId() {
            return memoryRecordId;
        }

        public final void setMemoryRecordId(String memoryRecordId) {
            this.memoryRecordId = memoryRecordId;
        }

        @Override
        public final Builder memoryRecordId(String memoryRecordId) {
            this.memoryRecordId = memoryRecordId;
            return this;
        }

        @Override
        public DeleteMemoryRecordResponse build() {
            return new DeleteMemoryRecordResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
