/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultInvokeCodeInterpreterVisitorBuilder implements InvokeCodeInterpreterResponseHandler.Visitor.Builder {
    private Consumer<CodeInterpreterStreamOutput> onDefault;

    private Consumer<CodeInterpreterResult> onResult;

    @Override
    public InvokeCodeInterpreterResponseHandler.Visitor.Builder onDefault(Consumer<CodeInterpreterStreamOutput> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public InvokeCodeInterpreterResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public InvokeCodeInterpreterResponseHandler.Visitor.Builder onResult(Consumer<CodeInterpreterResult> c) {
        this.onResult = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements InvokeCodeInterpreterResponseHandler.Visitor {
        private final Consumer<CodeInterpreterStreamOutput> onDefault;

        private final Consumer<CodeInterpreterResult> onResult;

        VisitorFromBuilder(DefaultInvokeCodeInterpreterVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : InvokeCodeInterpreterResponseHandler.Visitor.super::visitDefault;
            this.onResult = builder.onResult != null ? builder.onResult
                    : InvokeCodeInterpreterResponseHandler.Visitor.super::visitResult;
        }

        @Override
        public void visitDefault(CodeInterpreterStreamOutput event) {
            onDefault.accept(event);
        }

        @Override
        public void visitResult(CodeInterpreterResult event) {
            onResult.accept(event);
        }
    }
}
