/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains conversational content for an event payload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Conversational implements SdkPojo, Serializable, ToCopyableBuilder<Conversational.Builder, Conversational> {
    private static final SdkField<Content> CONTENT_FIELD = SdkField.<Content> builder(MarshallingType.SDK_POJO)
            .memberName("content").getter(getter(Conversational::content)).setter(setter(Builder::content))
            .constructor(Content::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("role")
            .getter(getter(Conversational::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Content content;

    private final String role;

    private Conversational(BuilderImpl builder) {
        this.content = builder.content;
        this.role = builder.role;
    }

    /**
     * <p>
     * The content of the conversation message.
     * </p>
     * 
     * @return The content of the conversation message.
     */
    public final Content content() {
        return content;
    }

    /**
     * <p>
     * The role of the participant in the conversation (for example, "user" or "assistant").
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the participant in the conversation (for example, "user" or "assistant").
     * @see Role
     */
    public final Role role() {
        return Role.fromValue(role);
    }

    /**
     * <p>
     * The role of the participant in the conversation (for example, "user" or "assistant").
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the participant in the conversation (for example, "user" or "assistant").
     * @see Role
     */
    public final String roleAsString() {
        return role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Conversational)) {
            return false;
        }
        Conversational other = (Conversational) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(roleAsString(), other.roleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Conversational").add("Content", content()).add("Role", roleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("role", ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Conversational, T> g) {
        return obj -> g.apply((Conversational) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Conversational> {
        /**
         * <p>
         * The content of the conversation message.
         * </p>
         * 
         * @param content
         *        The content of the conversation message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Content content);

        /**
         * <p>
         * The content of the conversation message.
         * </p>
         * This is a convenience method that creates an instance of the {@link Content.Builder} avoiding the need to
         * create one manually via {@link Content#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Content.Builder#build()} is called immediately and its result is
         * passed to {@link #content(Content)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link Content.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(Content)
         */
        default Builder content(Consumer<Content.Builder> content) {
            return content(Content.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The role of the participant in the conversation (for example, "user" or "assistant").
         * </p>
         * 
         * @param role
         *        The role of the participant in the conversation (for example, "user" or "assistant").
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder role(String role);

        /**
         * <p>
         * The role of the participant in the conversation (for example, "user" or "assistant").
         * </p>
         * 
         * @param role
         *        The role of the participant in the conversation (for example, "user" or "assistant").
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder role(Role role);
    }

    static final class BuilderImpl implements Builder {
        private Content content;

        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(Conversational model) {
            content(model.content);
            role(model.role);
        }

        public final Content.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(Content.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(Content content) {
            this.content = content;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(Role role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        @Override
        public Conversational build() {
            return new Conversational(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
