/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output produced by executing code in a code interpreter session in Amazon Bedrock. This structure contains the
 * results of code execution, including textual output, structured data, and error information. Agents use these results
 * to generate responses that incorporate computation, data analysis, and visualization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CodeInterpreterResult implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeInterpreterResult.Builder, CodeInterpreterResult>, CodeInterpreterStreamOutput {
    private static final SdkField<List<ContentBlock>> CONTENT_FIELD = SdkField
            .<List<ContentBlock>> builder(MarshallingType.LIST)
            .memberName("content")
            .getter(getter(CodeInterpreterResult::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContentBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContentBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ToolResultStructuredContent> STRUCTURED_CONTENT_FIELD = SdkField
            .<ToolResultStructuredContent> builder(MarshallingType.SDK_POJO).memberName("structuredContent")
            .getter(getter(CodeInterpreterResult::structuredContent)).setter(setter(Builder::structuredContent))
            .constructor(ToolResultStructuredContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structuredContent").build()).build();

    private static final SdkField<Boolean> IS_ERROR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isError").getter(getter(CodeInterpreterResult::isError)).setter(setter(Builder::isError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isError").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            STRUCTURED_CONTENT_FIELD, IS_ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ContentBlock> content;

    private final ToolResultStructuredContent structuredContent;

    private final Boolean isError;

    protected CodeInterpreterResult(BuilderImpl builder) {
        this.content = builder.content;
        this.structuredContent = builder.structuredContent;
        this.isError = builder.isError;
    }

    /**
     * For responses, this returns true if the service returned a value for the Content property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContent() {
        return content != null && !(content instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The textual content of the execution result. This includes standard output from the code execution, such as print
     * statements, console output, and text representations of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContent} method.
     * </p>
     * 
     * @return The textual content of the execution result. This includes standard output from the code execution, such
     *         as print statements, console output, and text representations of results.
     */
    public final List<ContentBlock> content() {
        return content;
    }

    /**
     * <p>
     * The structured content of the execution result. This includes additional metadata about the execution, such as
     * execution time, memory usage, and structured representations of output data. The format depends on the specific
     * code interpreter and execution context.
     * </p>
     * 
     * @return The structured content of the execution result. This includes additional metadata about the execution,
     *         such as execution time, memory usage, and structured representations of output data. The format depends
     *         on the specific code interpreter and execution context.
     */
    public final ToolResultStructuredContent structuredContent() {
        return structuredContent;
    }

    /**
     * <p>
     * Indicates whether the result represents an error. If true, the content contains error messages or exception
     * information. If false, the content contains successful execution results.
     * </p>
     * 
     * @return Indicates whether the result represents an error. If true, the content contains error messages or
     *         exception information. If false, the content contains successful execution results.
     */
    public final Boolean isError() {
        return isError;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContent() ? content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(structuredContent());
        hashCode = 31 * hashCode + Objects.hashCode(isError());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeInterpreterResult)) {
            return false;
        }
        CodeInterpreterResult other = (CodeInterpreterResult) obj;
        return hasContent() == other.hasContent() && Objects.equals(content(), other.content())
                && Objects.equals(structuredContent(), other.structuredContent()) && Objects.equals(isError(), other.isError());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeInterpreterResult").add("Content", hasContent() ? content() : null)
                .add("StructuredContent", structuredContent()).add("IsError", isError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "structuredContent":
            return Optional.ofNullable(clazz.cast(structuredContent()));
        case "isError":
            return Optional.ofNullable(clazz.cast(isError()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final CodeInterpreterResult copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("structuredContent", STRUCTURED_CONTENT_FIELD);
        map.put("isError", IS_ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeInterpreterResult, T> g) {
        return obj -> g.apply((CodeInterpreterResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link CodeInterpreterResult}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(InvokeCodeInterpreterResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeInterpreterResult> {
        /**
         * <p>
         * The textual content of the execution result. This includes standard output from the code execution, such as
         * print statements, console output, and text representations of results.
         * </p>
         * 
         * @param content
         *        The textual content of the execution result. This includes standard output from the code execution,
         *        such as print statements, console output, and text representations of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Collection<ContentBlock> content);

        /**
         * <p>
         * The textual content of the execution result. This includes standard output from the code execution, such as
         * print statements, console output, and text representations of results.
         * </p>
         * 
         * @param content
         *        The textual content of the execution result. This includes standard output from the code execution,
         *        such as print statements, console output, and text representations of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(ContentBlock... content);

        /**
         * <p>
         * The textual content of the execution result. This includes standard output from the code execution, such as
         * print statements, console output, and text representations of results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcore.model.ContentBlock.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrockagentcore.model.ContentBlock#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcore.model.ContentBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #content(List<ContentBlock>)}.
         * 
         * @param content
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(java.util.Collection<ContentBlock>)
         */
        Builder content(Consumer<ContentBlock.Builder>... content);

        /**
         * <p>
         * The structured content of the execution result. This includes additional metadata about the execution, such
         * as execution time, memory usage, and structured representations of output data. The format depends on the
         * specific code interpreter and execution context.
         * </p>
         * 
         * @param structuredContent
         *        The structured content of the execution result. This includes additional metadata about the execution,
         *        such as execution time, memory usage, and structured representations of output data. The format
         *        depends on the specific code interpreter and execution context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder structuredContent(ToolResultStructuredContent structuredContent);

        /**
         * <p>
         * The structured content of the execution result. This includes additional metadata about the execution, such
         * as execution time, memory usage, and structured representations of output data. The format depends on the
         * specific code interpreter and execution context.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolResultStructuredContent.Builder}
         * avoiding the need to create one manually via {@link ToolResultStructuredContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolResultStructuredContent.Builder#build()} is called
         * immediately and its result is passed to {@link #structuredContent(ToolResultStructuredContent)}.
         * 
         * @param structuredContent
         *        a consumer that will call methods on {@link ToolResultStructuredContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #structuredContent(ToolResultStructuredContent)
         */
        default Builder structuredContent(Consumer<ToolResultStructuredContent.Builder> structuredContent) {
            return structuredContent(ToolResultStructuredContent.builder().applyMutation(structuredContent).build());
        }

        /**
         * <p>
         * Indicates whether the result represents an error. If true, the content contains error messages or exception
         * information. If false, the content contains successful execution results.
         * </p>
         * 
         * @param isError
         *        Indicates whether the result represents an error. If true, the content contains error messages or
         *        exception information. If false, the content contains successful execution results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isError(Boolean isError);
    }

    protected static class BuilderImpl implements Builder {
        private List<ContentBlock> content = DefaultSdkAutoConstructList.getInstance();

        private ToolResultStructuredContent structuredContent;

        private Boolean isError;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CodeInterpreterResult model) {
            content(model.content);
            structuredContent(model.structuredContent);
            isError(model.isError);
        }

        public final List<ContentBlock.Builder> getContent() {
            List<ContentBlock.Builder> result = ContentBlockListCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<ContentBlock.BuilderImpl> content) {
            this.content = ContentBlockListCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<ContentBlock> content) {
            this.content = ContentBlockListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(ContentBlock... content) {
            content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<ContentBlock.Builder>... content) {
            content(Stream.of(content).map(c -> ContentBlock.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ToolResultStructuredContent.Builder getStructuredContent() {
            return structuredContent != null ? structuredContent.toBuilder() : null;
        }

        public final void setStructuredContent(ToolResultStructuredContent.BuilderImpl structuredContent) {
            this.structuredContent = structuredContent != null ? structuredContent.build() : null;
        }

        @Override
        public final Builder structuredContent(ToolResultStructuredContent structuredContent) {
            this.structuredContent = structuredContent;
            return this;
        }

        public final Boolean getIsError() {
            return isError;
        }

        public final void setIsError(Boolean isError) {
            this.isError = isError;
        }

        @Override
        public final Builder isError(Boolean isError) {
            this.isError = isError;
            return this;
        }

        @Override
        public CodeInterpreterResult build() {
            return new CodeInterpreterResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
