/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A condensed representation of a browser session in Amazon Bedrock. This structure contains key information about a
 * browser session, including identifiers, status, and timestamps, without the full details of the session configuration
 * and streams.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrowserSessionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BrowserSessionSummary.Builder, BrowserSessionSummary> {
    private static final SdkField<String> BROWSER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserIdentifier").getter(getter(BrowserSessionSummary::browserIdentifier))
            .setter(setter(Builder::browserIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserIdentifier").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(BrowserSessionSummary::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(BrowserSessionSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BrowserSessionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(BrowserSessionSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(BrowserSessionSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_IDENTIFIER_FIELD,
            SESSION_ID_FIELD, NAME_FIELD, STATUS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String browserIdentifier;

    private final String sessionId;

    private final String name;

    private final String status;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private BrowserSessionSummary(BuilderImpl builder) {
        this.browserIdentifier = builder.browserIdentifier;
        this.sessionId = builder.sessionId;
        this.name = builder.name;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The unique identifier of the browser associated with the session. This identifier specifies which browser
     * environment is used for the session.
     * </p>
     * 
     * @return The unique identifier of the browser associated with the session. This identifier specifies which browser
     *         environment is used for the session.
     */
    public final String browserIdentifier() {
        return browserIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the browser session. This identifier is used in operations that interact with the
     * session.
     * </p>
     * 
     * @return The unique identifier of the browser session. This identifier is used in operations that interact with
     *         the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The name of the browser session. This name helps identify and manage the session.
     * </p>
     * 
     * @return The name of the browser session. This name helps identify and manage the session.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BrowserSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
     * @see BrowserSessionStatus
     */
    public final BrowserSessionStatus status() {
        return BrowserSessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BrowserSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
     * @see BrowserSessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the browser session was created. This value is in ISO 8601 format.
     * </p>
     * 
     * @return The timestamp when the browser session was created. This value is in ISO 8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the browser session was last updated. This value is in ISO 8601 format.
     * </p>
     * 
     * @return The timestamp when the browser session was last updated. This value is in ISO 8601 format.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(browserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrowserSessionSummary)) {
            return false;
        }
        BrowserSessionSummary other = (BrowserSessionSummary) obj;
        return Objects.equals(browserIdentifier(), other.browserIdentifier()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrowserSessionSummary").add("BrowserIdentifier", browserIdentifier())
                .add("SessionId", sessionId()).add("Name", name()).add("Status", statusAsString()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserIdentifier":
            return Optional.ofNullable(clazz.cast(browserIdentifier()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("browserIdentifier", BROWSER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrowserSessionSummary, T> g) {
        return obj -> g.apply((BrowserSessionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrowserSessionSummary> {
        /**
         * <p>
         * The unique identifier of the browser associated with the session. This identifier specifies which browser
         * environment is used for the session.
         * </p>
         * 
         * @param browserIdentifier
         *        The unique identifier of the browser associated with the session. This identifier specifies which
         *        browser environment is used for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserIdentifier(String browserIdentifier);

        /**
         * <p>
         * The unique identifier of the browser session. This identifier is used in operations that interact with the
         * session.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the browser session. This identifier is used in operations that interact with
         *        the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The name of the browser session. This name helps identify and manage the session.
         * </p>
         * 
         * @param name
         *        The name of the browser session. This name helps identify and manage the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
         * </p>
         * 
         * @param status
         *        The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
         * @see BrowserSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserSessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
         * </p>
         * 
         * @param status
         *        The current status of the browser session. Possible values include ACTIVE, STOPPING, and STOPPED.
         * @see BrowserSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserSessionStatus
         */
        Builder status(BrowserSessionStatus status);

        /**
         * <p>
         * The timestamp when the browser session was created. This value is in ISO 8601 format.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the browser session was created. This value is in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the browser session was last updated. This value is in ISO 8601 format.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the browser session was last updated. This value is in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String browserIdentifier;

        private String sessionId;

        private String name;

        private String status;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(BrowserSessionSummary model) {
            browserIdentifier(model.browserIdentifier);
            sessionId(model.sessionId);
            name(model.name);
            status(model.status);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getBrowserIdentifier() {
            return browserIdentifier;
        }

        public final void setBrowserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
        }

        @Override
        public final Builder browserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BrowserSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public BrowserSessionSummary build() {
            return new BrowserSessionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
