/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of streams associated with a browser session in Amazon Bedrock. These streams provide different ways
 * to interact with and observe the browser session, including programmatic control and visual representation of the
 * browser content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrowserSessionStream implements SdkPojo, Serializable,
        ToCopyableBuilder<BrowserSessionStream.Builder, BrowserSessionStream> {
    private static final SdkField<AutomationStream> AUTOMATION_STREAM_FIELD = SdkField
            .<AutomationStream> builder(MarshallingType.SDK_POJO).memberName("automationStream")
            .getter(getter(BrowserSessionStream::automationStream)).setter(setter(Builder::automationStream))
            .constructor(AutomationStream::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automationStream").build()).build();

    private static final SdkField<LiveViewStream> LIVE_VIEW_STREAM_FIELD = SdkField
            .<LiveViewStream> builder(MarshallingType.SDK_POJO).memberName("liveViewStream")
            .getter(getter(BrowserSessionStream::liveViewStream)).setter(setter(Builder::liveViewStream))
            .constructor(LiveViewStream::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("liveViewStream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_STREAM_FIELD,
            LIVE_VIEW_STREAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomationStream automationStream;

    private final LiveViewStream liveViewStream;

    private BrowserSessionStream(BuilderImpl builder) {
        this.automationStream = builder.automationStream;
        this.liveViewStream = builder.liveViewStream;
    }

    /**
     * <p>
     * The stream that enables programmatic control of the browser. This stream allows agents to perform actions such as
     * navigating to URLs, clicking elements, and filling forms.
     * </p>
     * 
     * @return The stream that enables programmatic control of the browser. This stream allows agents to perform actions
     *         such as navigating to URLs, clicking elements, and filling forms.
     */
    public final AutomationStream automationStream() {
        return automationStream;
    }

    /**
     * <p>
     * The stream that provides a visual representation of the browser content. This stream allows agents to observe the
     * current state of the browser, including rendered web pages and visual elements.
     * </p>
     * 
     * @return The stream that provides a visual representation of the browser content. This stream allows agents to
     *         observe the current state of the browser, including rendered web pages and visual elements.
     */
    public final LiveViewStream liveViewStream() {
        return liveViewStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationStream());
        hashCode = 31 * hashCode + Objects.hashCode(liveViewStream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrowserSessionStream)) {
            return false;
        }
        BrowserSessionStream other = (BrowserSessionStream) obj;
        return Objects.equals(automationStream(), other.automationStream())
                && Objects.equals(liveViewStream(), other.liveViewStream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrowserSessionStream").add("AutomationStream", automationStream())
                .add("LiveViewStream", liveViewStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "automationStream":
            return Optional.ofNullable(clazz.cast(automationStream()));
        case "liveViewStream":
            return Optional.ofNullable(clazz.cast(liveViewStream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("automationStream", AUTOMATION_STREAM_FIELD);
        map.put("liveViewStream", LIVE_VIEW_STREAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrowserSessionStream, T> g) {
        return obj -> g.apply((BrowserSessionStream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrowserSessionStream> {
        /**
         * <p>
         * The stream that enables programmatic control of the browser. This stream allows agents to perform actions
         * such as navigating to URLs, clicking elements, and filling forms.
         * </p>
         * 
         * @param automationStream
         *        The stream that enables programmatic control of the browser. This stream allows agents to perform
         *        actions such as navigating to URLs, clicking elements, and filling forms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationStream(AutomationStream automationStream);

        /**
         * <p>
         * The stream that enables programmatic control of the browser. This stream allows agents to perform actions
         * such as navigating to URLs, clicking elements, and filling forms.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomationStream.Builder} avoiding the
         * need to create one manually via {@link AutomationStream#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomationStream.Builder#build()} is called immediately and its
         * result is passed to {@link #automationStream(AutomationStream)}.
         * 
         * @param automationStream
         *        a consumer that will call methods on {@link AutomationStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automationStream(AutomationStream)
         */
        default Builder automationStream(Consumer<AutomationStream.Builder> automationStream) {
            return automationStream(AutomationStream.builder().applyMutation(automationStream).build());
        }

        /**
         * <p>
         * The stream that provides a visual representation of the browser content. This stream allows agents to observe
         * the current state of the browser, including rendered web pages and visual elements.
         * </p>
         * 
         * @param liveViewStream
         *        The stream that provides a visual representation of the browser content. This stream allows agents to
         *        observe the current state of the browser, including rendered web pages and visual elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder liveViewStream(LiveViewStream liveViewStream);

        /**
         * <p>
         * The stream that provides a visual representation of the browser content. This stream allows agents to observe
         * the current state of the browser, including rendered web pages and visual elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link LiveViewStream.Builder} avoiding the need
         * to create one manually via {@link LiveViewStream#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LiveViewStream.Builder#build()} is called immediately and its
         * result is passed to {@link #liveViewStream(LiveViewStream)}.
         * 
         * @param liveViewStream
         *        a consumer that will call methods on {@link LiveViewStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #liveViewStream(LiveViewStream)
         */
        default Builder liveViewStream(Consumer<LiveViewStream.Builder> liveViewStream) {
            return liveViewStream(LiveViewStream.builder().applyMutation(liveViewStream).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomationStream automationStream;

        private LiveViewStream liveViewStream;

        private BuilderImpl() {
        }

        private BuilderImpl(BrowserSessionStream model) {
            automationStream(model.automationStream);
            liveViewStream(model.liveViewStream);
        }

        public final AutomationStream.Builder getAutomationStream() {
            return automationStream != null ? automationStream.toBuilder() : null;
        }

        public final void setAutomationStream(AutomationStream.BuilderImpl automationStream) {
            this.automationStream = automationStream != null ? automationStream.build() : null;
        }

        @Override
        public final Builder automationStream(AutomationStream automationStream) {
            this.automationStream = automationStream;
            return this;
        }

        public final LiveViewStream.Builder getLiveViewStream() {
            return liveViewStream != null ? liveViewStream.toBuilder() : null;
        }

        public final void setLiveViewStream(LiveViewStream.BuilderImpl liveViewStream) {
            this.liveViewStream = liveViewStream != null ? liveViewStream.build() : null;
        }

        @Override
        public final Builder liveViewStream(LiveViewStream liveViewStream) {
            this.liveViewStream = liveViewStream;
            return this;
        }

        @Override
        public BrowserSessionStream build() {
            return new BrowserSessionStream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
