/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains filter criteria for branches when listing events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BranchFilter implements SdkPojo, Serializable, ToCopyableBuilder<BranchFilter.Builder, BranchFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(BranchFilter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> INCLUDE_PARENT_BRANCHES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeParentBranches").getter(getter(BranchFilter::includeParentBranches))
            .setter(setter(Builder::includeParentBranches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeParentBranches").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            INCLUDE_PARENT_BRANCHES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Boolean includeParentBranches;

    private BranchFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.includeParentBranches = builder.includeParentBranches;
    }

    /**
     * <p>
     * The name of the branch to filter by.
     * </p>
     * 
     * @return The name of the branch to filter by.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether to include parent branches in the results. Set to true to include parent branches, or false to
     * exclude them.
     * </p>
     * 
     * @return Specifies whether to include parent branches in the results. Set to true to include parent branches, or
     *         false to exclude them.
     */
    public final Boolean includeParentBranches() {
        return includeParentBranches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(includeParentBranches());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BranchFilter)) {
            return false;
        }
        BranchFilter other = (BranchFilter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(includeParentBranches(), other.includeParentBranches());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BranchFilter").add("Name", name()).add("IncludeParentBranches", includeParentBranches()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "includeParentBranches":
            return Optional.ofNullable(clazz.cast(includeParentBranches()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("includeParentBranches", INCLUDE_PARENT_BRANCHES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BranchFilter, T> g) {
        return obj -> g.apply((BranchFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BranchFilter> {
        /**
         * <p>
         * The name of the branch to filter by.
         * </p>
         * 
         * @param name
         *        The name of the branch to filter by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether to include parent branches in the results. Set to true to include parent branches, or false
         * to exclude them.
         * </p>
         * 
         * @param includeParentBranches
         *        Specifies whether to include parent branches in the results. Set to true to include parent branches,
         *        or false to exclude them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeParentBranches(Boolean includeParentBranches);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Boolean includeParentBranches;

        private BuilderImpl() {
        }

        private BuilderImpl(BranchFilter model) {
            name(model.name);
            includeParentBranches(model.includeParentBranches);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getIncludeParentBranches() {
            return includeParentBranches;
        }

        public final void setIncludeParentBranches(Boolean includeParentBranches) {
            this.includeParentBranches = includeParentBranches;
        }

        @Override
        public final Builder includeParentBranches(Boolean includeParentBranches) {
            this.includeParentBranches = includeParentBranches;
            return this;
        }

        @Override
        public BranchFilter build() {
            return new BranchFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
