/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a stream that enables programmatic control of a browser session in Amazon Bedrock. This stream
 * provides a bidirectional communication channel for sending commands to the browser and receiving responses, allowing
 * agents to automate web interactions such as navigation, form filling, and element clicking.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationStream implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationStream.Builder, AutomationStream> {
    private static final SdkField<String> STREAM_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamEndpoint").getter(getter(AutomationStream::streamEndpoint))
            .setter(setter(Builder::streamEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamEndpoint").build()).build();

    private static final SdkField<String> STREAM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamStatus").getter(getter(AutomationStream::streamStatusAsString))
            .setter(setter(Builder::streamStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ENDPOINT_FIELD,
            STREAM_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streamEndpoint;

    private final String streamStatus;

    private AutomationStream(BuilderImpl builder) {
        this.streamEndpoint = builder.streamEndpoint;
        this.streamStatus = builder.streamStatus;
    }

    /**
     * <p>
     * The endpoint URL for the automation stream. This URL is used to establish a WebSocket connection to the stream
     * for sending commands and receiving responses.
     * </p>
     * 
     * @return The endpoint URL for the automation stream. This URL is used to establish a WebSocket connection to the
     *         stream for sending commands and receiving responses.
     */
    public final String streamEndpoint() {
        return streamEndpoint;
    }

    /**
     * <p>
     * The current status of the automation stream. This indicates whether the stream is available for use. Possible
     * values include ACTIVE, CONNECTING, and DISCONNECTED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamStatus} will
     * return {@link AutomationStreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamStatusAsString}.
     * </p>
     * 
     * @return The current status of the automation stream. This indicates whether the stream is available for use.
     *         Possible values include ACTIVE, CONNECTING, and DISCONNECTED.
     * @see AutomationStreamStatus
     */
    public final AutomationStreamStatus streamStatus() {
        return AutomationStreamStatus.fromValue(streamStatus);
    }

    /**
     * <p>
     * The current status of the automation stream. This indicates whether the stream is available for use. Possible
     * values include ACTIVE, CONNECTING, and DISCONNECTED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamStatus} will
     * return {@link AutomationStreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamStatusAsString}.
     * </p>
     * 
     * @return The current status of the automation stream. This indicates whether the stream is available for use.
     *         Possible values include ACTIVE, CONNECTING, and DISCONNECTED.
     * @see AutomationStreamStatus
     */
    public final String streamStatusAsString() {
        return streamStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(streamStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationStream)) {
            return false;
        }
        AutomationStream other = (AutomationStream) obj;
        return Objects.equals(streamEndpoint(), other.streamEndpoint())
                && Objects.equals(streamStatusAsString(), other.streamStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomationStream").add("StreamEndpoint", streamEndpoint())
                .add("StreamStatus", streamStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamEndpoint":
            return Optional.ofNullable(clazz.cast(streamEndpoint()));
        case "streamStatus":
            return Optional.ofNullable(clazz.cast(streamStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streamEndpoint", STREAM_ENDPOINT_FIELD);
        map.put("streamStatus", STREAM_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationStream, T> g) {
        return obj -> g.apply((AutomationStream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationStream> {
        /**
         * <p>
         * The endpoint URL for the automation stream. This URL is used to establish a WebSocket connection to the
         * stream for sending commands and receiving responses.
         * </p>
         * 
         * @param streamEndpoint
         *        The endpoint URL for the automation stream. This URL is used to establish a WebSocket connection to
         *        the stream for sending commands and receiving responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamEndpoint(String streamEndpoint);

        /**
         * <p>
         * The current status of the automation stream. This indicates whether the stream is available for use. Possible
         * values include ACTIVE, CONNECTING, and DISCONNECTED.
         * </p>
         * 
         * @param streamStatus
         *        The current status of the automation stream. This indicates whether the stream is available for use.
         *        Possible values include ACTIVE, CONNECTING, and DISCONNECTED.
         * @see AutomationStreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationStreamStatus
         */
        Builder streamStatus(String streamStatus);

        /**
         * <p>
         * The current status of the automation stream. This indicates whether the stream is available for use. Possible
         * values include ACTIVE, CONNECTING, and DISCONNECTED.
         * </p>
         * 
         * @param streamStatus
         *        The current status of the automation stream. This indicates whether the stream is available for use.
         *        Possible values include ACTIVE, CONNECTING, and DISCONNECTED.
         * @see AutomationStreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationStreamStatus
         */
        Builder streamStatus(AutomationStreamStatus streamStatus);
    }

    static final class BuilderImpl implements Builder {
        private String streamEndpoint;

        private String streamStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationStream model) {
            streamEndpoint(model.streamEndpoint);
            streamStatus(model.streamStatus);
        }

        public final String getStreamEndpoint() {
            return streamEndpoint;
        }

        public final void setStreamEndpoint(String streamEndpoint) {
            this.streamEndpoint = streamEndpoint;
        }

        @Override
        public final Builder streamEndpoint(String streamEndpoint) {
            this.streamEndpoint = streamEndpoint;
            return this;
        }

        public final String getStreamStatus() {
            return streamStatus;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(AutomationStreamStatus streamStatus) {
            this.streamStatus(streamStatus == null ? null : streamStatus.toString());
            return this;
        }

        @Override
        public AutomationStream build() {
            return new AutomationStream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
