/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.bedrockagentcore.model.AccessDeniedException;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreException;
import software.amazon.awssdk.services.bedrockagentcore.model.ConflictException;
import software.amazon.awssdk.services.bedrockagentcore.model.CreateEventRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.CreateEventResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteEventRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteEventResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteMemoryRecordRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteMemoryRecordResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetBrowserSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetBrowserSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetCodeInterpreterSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetCodeInterpreterSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetEventRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetEventResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetMemoryRecordRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetMemoryRecordResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceApiKeyRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceApiKeyResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceOauth2TokenRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceOauth2TokenResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForJwtRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForJwtResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForUserIdRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForUserIdResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.InternalServerException;
import software.amazon.awssdk.services.bedrockagentcore.model.InvalidInputException;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListActorsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListBrowserSessionsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListBrowserSessionsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListCodeInterpreterSessionsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListCodeInterpreterSessionsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListEventsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.RuntimeClientErrorException;
import software.amazon.awssdk.services.bedrockagentcore.model.ServiceException;
import software.amazon.awssdk.services.bedrockagentcore.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bedrockagentcore.model.StartBrowserSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StartBrowserSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.StartCodeInterpreterSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StartCodeInterpreterSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.StopBrowserSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StopBrowserSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.StopCodeInterpreterSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StopCodeInterpreterSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ThrottledException;
import software.amazon.awssdk.services.bedrockagentcore.model.ThrottlingException;
import software.amazon.awssdk.services.bedrockagentcore.model.UnauthorizedException;
import software.amazon.awssdk.services.bedrockagentcore.model.UpdateBrowserStreamRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.UpdateBrowserStreamResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ValidationException;
import software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsIterable;
import software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsIterable;
import software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsIterable;
import software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsIterable;
import software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsIterable;

/**
 * Service client for accessing Amazon Bedrock AgentCore Data Plane Fronting Layer. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * <note>
 * <p>
 * Amazon Bedrock AgentCore is in preview release and is subject to change.
 * </p>
 * </note>
 * <p>
 * Welcome to the Amazon Bedrock AgentCore Data Plane API reference. Data Plane actions process and handle data or
 * workloads within Amazon Web Services services.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockAgentCoreClient extends AwsClient {
    String SERVICE_NAME = "bedrock-agentcore";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-agentcore";

    /**
     * <p>
     * Creates an event in an AgentCore Memory resource. Events represent interactions or activities that occur within a
     * session and are associated with specific actors.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:CreateEvent</code> permission.
     * </p>
     * <p>
     * This operation is subject to request rate limiting.
     * </p>
     *
     * @param createEventRequest
     * @return Result of the CreateEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.CreateEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/CreateEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEventResponse createEvent(CreateEventRequest createEventRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an event in an AgentCore Memory resource. Events represent interactions or activities that occur within a
     * session and are associated with specific actors.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:CreateEvent</code> permission.
     * </p>
     * <p>
     * This operation is subject to request rate limiting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEventRequest#builder()}
     * </p>
     *
     * @param createEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.CreateEventRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.CreateEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/CreateEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEventResponse createEvent(Consumer<CreateEventRequest.Builder> createEventRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return createEvent(CreateEventRequest.builder().applyMutation(createEventRequest).build());
    }

    /**
     * <p>
     * Deletes an event from an AgentCore Memory resource. When you delete an event, it is permanently removed.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:DeleteEvent</code> permission.
     * </p>
     *
     * @param deleteEventRequest
     * @return Result of the DeleteEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.DeleteEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/DeleteEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventResponse deleteEvent(DeleteEventRequest deleteEventRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an event from an AgentCore Memory resource. When you delete an event, it is permanently removed.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:DeleteEvent</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEventRequest#builder()}
     * </p>
     *
     * @param deleteEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.DeleteEventRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.DeleteEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/DeleteEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventResponse deleteEvent(Consumer<DeleteEventRequest.Builder> deleteEventRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return deleteEvent(DeleteEventRequest.builder().applyMutation(deleteEventRequest).build());
    }

    /**
     * <p>
     * Deletes a memory record from an AgentCore Memory resource. When you delete a memory record, it is permanently
     * removed.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:DeleteMemoryRecord</code> permission.
     * </p>
     *
     * @param deleteMemoryRecordRequest
     * @return Result of the DeleteMemoryRecord operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.DeleteMemoryRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/DeleteMemoryRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMemoryRecordResponse deleteMemoryRecord(DeleteMemoryRecordRequest deleteMemoryRecordRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a memory record from an AgentCore Memory resource. When you delete a memory record, it is permanently
     * removed.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:DeleteMemoryRecord</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMemoryRecordRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMemoryRecordRequest#builder()}
     * </p>
     *
     * @param deleteMemoryRecordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.DeleteMemoryRecordRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteMemoryRecord operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.DeleteMemoryRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/DeleteMemoryRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMemoryRecordResponse deleteMemoryRecord(Consumer<DeleteMemoryRecordRequest.Builder> deleteMemoryRecordRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return deleteMemoryRecord(DeleteMemoryRecordRequest.builder().applyMutation(deleteMemoryRecordRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific browser session in Amazon Bedrock. This operation returns the
     * session's configuration, current status, associated streams, and metadata.
     * </p>
     * <p>
     * To get a browser session, you must specify both the browser identifier and the session ID. The response includes
     * information about the session's viewport configuration, timeout settings, and stream endpoints.
     * </p>
     * <p>
     * The following operations are related to <code>GetBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_ListBrowserSessions.html">ListBrowserSessions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopBrowserSession.html">StopBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBrowserSessionRequest
     * @return Result of the GetBrowserSession operation returned by the service.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBrowserSessionResponse getBrowserSession(GetBrowserSessionRequest getBrowserSessionRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific browser session in Amazon Bedrock. This operation returns the
     * session's configuration, current status, associated streams, and metadata.
     * </p>
     * <p>
     * To get a browser session, you must specify both the browser identifier and the session ID. The response includes
     * information about the session's viewport configuration, timeout settings, and stream endpoints.
     * </p>
     * <p>
     * The following operations are related to <code>GetBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_ListBrowserSessions.html">ListBrowserSessions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopBrowserSession.html">StopBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBrowserSessionRequest.Builder} avoiding the need
     * to create one manually via {@link GetBrowserSessionRequest#builder()}
     * </p>
     *
     * @param getBrowserSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetBrowserSessionRequest.Builder} to create
     *        a request.
     * @return Result of the GetBrowserSession operation returned by the service.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBrowserSessionResponse getBrowserSession(Consumer<GetBrowserSessionRequest.Builder> getBrowserSessionRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return getBrowserSession(GetBrowserSessionRequest.builder().applyMutation(getBrowserSessionRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific code interpreter session in Amazon Bedrock. This operation
     * returns the session's configuration, current status, and metadata.
     * </p>
     * <p>
     * To get a code interpreter session, you must specify both the code interpreter identifier and the session ID. The
     * response includes information about the session's timeout settings and current status.
     * </p>
     * <p>
     * The following operations are related to <code>GetCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_ListCodeInterpreterSessions.html">ListCodeInterpreterSessions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopCodeInterpreterSession.html">StopCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getCodeInterpreterSessionRequest
     * @return Result of the GetCodeInterpreterSession operation returned by the service.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCodeInterpreterSessionResponse getCodeInterpreterSession(
            GetCodeInterpreterSessionRequest getCodeInterpreterSessionRequest) throws AccessDeniedException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific code interpreter session in Amazon Bedrock. This operation
     * returns the session's configuration, current status, and metadata.
     * </p>
     * <p>
     * To get a code interpreter session, you must specify both the code interpreter identifier and the session ID. The
     * response includes information about the session's timeout settings and current status.
     * </p>
     * <p>
     * The following operations are related to <code>GetCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_ListCodeInterpreterSessions.html">ListCodeInterpreterSessions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopCodeInterpreterSession.html">StopCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodeInterpreterSessionRequest.Builder} avoiding
     * the need to create one manually via {@link GetCodeInterpreterSessionRequest#builder()}
     * </p>
     *
     * @param getCodeInterpreterSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetCodeInterpreterSessionRequest.Builder} to
     *        create a request.
     * @return Result of the GetCodeInterpreterSession operation returned by the service.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCodeInterpreterSessionResponse getCodeInterpreterSession(
            Consumer<GetCodeInterpreterSessionRequest.Builder> getCodeInterpreterSessionRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreException {
        return getCodeInterpreterSession(GetCodeInterpreterSessionRequest.builder()
                .applyMutation(getCodeInterpreterSessionRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific event in an AgentCore Memory resource.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:GetEvent</code> permission.
     * </p>
     *
     * @param getEventRequest
     * @return Result of the GetEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventResponse getEvent(GetEventRequest getEventRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific event in an AgentCore Memory resource.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:GetEvent</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventRequest#builder()}
     * </p>
     *
     * @param getEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetEventRequest.Builder} to create a
     *        request.
     * @return Result of the GetEvent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventResponse getEvent(Consumer<GetEventRequest.Builder> getEventRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return getEvent(GetEventRequest.builder().applyMutation(getEventRequest).build());
    }

    /**
     * <p>
     * Retrieves a specific memory record from an AgentCore Memory resource.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:GetMemoryRecord</code> permission.
     * </p>
     *
     * @param getMemoryRecordRequest
     * @return Result of the GetMemoryRecord operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetMemoryRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetMemoryRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMemoryRecordResponse getMemoryRecord(GetMemoryRecordRequest getMemoryRecordRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specific memory record from an AgentCore Memory resource.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:GetMemoryRecord</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemoryRecordRequest.Builder} avoiding the need
     * to create one manually via {@link GetMemoryRecordRequest#builder()}
     * </p>
     *
     * @param getMemoryRecordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetMemoryRecordRequest.Builder} to create a
     *        request.
     * @return Result of the GetMemoryRecord operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetMemoryRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetMemoryRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMemoryRecordResponse getMemoryRecord(Consumer<GetMemoryRecordRequest.Builder> getMemoryRecordRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return getMemoryRecord(GetMemoryRecordRequest.builder().applyMutation(getMemoryRecordRequest).build());
    }

    /**
     * <p>
     * Retrieves an API Key associated with an API Key Credential Provider
     * </p>
     *
     * @param getResourceApiKeyRequest
     * @return Result of the GetResourceApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetResourceApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetResourceApiKey"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceApiKeyResponse getResourceApiKey(GetResourceApiKeyRequest getResourceApiKeyRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an API Key associated with an API Key Credential Provider
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceApiKeyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourceApiKeyRequest#builder()}
     * </p>
     *
     * @param getResourceApiKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetResourceApiKeyRequest.Builder} to create
     *        a request.
     * @return Result of the GetResourceApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetResourceApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetResourceApiKey"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceApiKeyResponse getResourceApiKey(Consumer<GetResourceApiKeyRequest.Builder> getResourceApiKeyRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return getResourceApiKey(GetResourceApiKeyRequest.builder().applyMutation(getResourceApiKeyRequest).build());
    }

    /**
     * <p>
     * Returns the OAuth 2.0 token of the provided resource
     * </p>
     *
     * @param getResourceOauth2TokenRequest
     * @return Result of the GetResourceOauth2Token operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetResourceOauth2Token
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetResourceOauth2Token"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceOauth2TokenResponse getResourceOauth2Token(GetResourceOauth2TokenRequest getResourceOauth2TokenRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the OAuth 2.0 token of the provided resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceOauth2TokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceOauth2TokenRequest#builder()}
     * </p>
     *
     * @param getResourceOauth2TokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetResourceOauth2TokenRequest.Builder} to
     *        create a request.
     * @return Result of the GetResourceOauth2Token operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetResourceOauth2Token
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetResourceOauth2Token"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceOauth2TokenResponse getResourceOauth2Token(
            Consumer<GetResourceOauth2TokenRequest.Builder> getResourceOauth2TokenRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return getResourceOauth2Token(GetResourceOauth2TokenRequest.builder().applyMutation(getResourceOauth2TokenRequest)
                .build());
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads not acting on behalf of user.
     * </p>
     *
     * @param getWorkloadAccessTokenRequest
     * @return Result of the GetWorkloadAccessToken operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetWorkloadAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkloadAccessTokenResponse getWorkloadAccessToken(GetWorkloadAccessTokenRequest getWorkloadAccessTokenRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads not acting on behalf of user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadAccessTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkloadAccessTokenRequest#builder()}
     * </p>
     *
     * @param getWorkloadAccessTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenRequest.Builder} to
     *        create a request.
     * @return Result of the GetWorkloadAccessToken operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetWorkloadAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkloadAccessTokenResponse getWorkloadAccessToken(
            Consumer<GetWorkloadAccessTokenRequest.Builder> getWorkloadAccessTokenRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return getWorkloadAccessToken(GetWorkloadAccessTokenRequest.builder().applyMutation(getWorkloadAccessTokenRequest)
                .build());
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads acting on behalf of user with JWT token
     * </p>
     *
     * @param getWorkloadAccessTokenForJwtRequest
     * @return Result of the GetWorkloadAccessTokenForJWT operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetWorkloadAccessTokenForJWT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessTokenForJWT"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkloadAccessTokenForJwtResponse getWorkloadAccessTokenForJWT(
            GetWorkloadAccessTokenForJwtRequest getWorkloadAccessTokenForJwtRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads acting on behalf of user with JWT token
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadAccessTokenForJwtRequest.Builder}
     * avoiding the need to create one manually via {@link GetWorkloadAccessTokenForJwtRequest#builder()}
     * </p>
     *
     * @param getWorkloadAccessTokenForJwtRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForJwtRequest.Builder}
     *        to create a request.
     * @return Result of the GetWorkloadAccessTokenForJWT operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetWorkloadAccessTokenForJWT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessTokenForJWT"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkloadAccessTokenForJwtResponse getWorkloadAccessTokenForJWT(
            Consumer<GetWorkloadAccessTokenForJwtRequest.Builder> getWorkloadAccessTokenForJwtRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return getWorkloadAccessTokenForJWT(GetWorkloadAccessTokenForJwtRequest.builder()
                .applyMutation(getWorkloadAccessTokenForJwtRequest).build());
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads acting on behalf of user with User Id.
     * </p>
     *
     * @param getWorkloadAccessTokenForUserIdRequest
     * @return Result of the GetWorkloadAccessTokenForUserId operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetWorkloadAccessTokenForUserId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessTokenForUserId"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkloadAccessTokenForUserIdResponse getWorkloadAccessTokenForUserId(
            GetWorkloadAccessTokenForUserIdRequest getWorkloadAccessTokenForUserIdRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads acting on behalf of user with User Id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadAccessTokenForUserIdRequest.Builder}
     * avoiding the need to create one manually via {@link GetWorkloadAccessTokenForUserIdRequest#builder()}
     * </p>
     *
     * @param getWorkloadAccessTokenForUserIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForUserIdRequest.Builder}
     *        to create a request.
     * @return Result of the GetWorkloadAccessTokenForUserId operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.GetWorkloadAccessTokenForUserId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessTokenForUserId"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkloadAccessTokenForUserIdResponse getWorkloadAccessTokenForUserId(
            Consumer<GetWorkloadAccessTokenForUserIdRequest.Builder> getWorkloadAccessTokenForUserIdRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return getWorkloadAccessTokenForUserId(GetWorkloadAccessTokenForUserIdRequest.builder()
                .applyMutation(getWorkloadAccessTokenForUserIdRequest).build());
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        InvokeAgentRuntimeResponse and an InputStream to the response content are provided as parameters to the
     *        callback. The callback may return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        The response data from the agent runtime. The format of this data depends on the specific agent
     *        configuration and the requested accept type. For most agents, this is a JSON object containing the agent's
     *        response to the user's request.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws RuntimeClientErrorException
     *         The exception that occurs when there is an error in the runtime client. This can happen due to network
     *         issues, invalid configuration, or other client-side problems. Check the error message for specific
     *         details about the error.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.InvokeAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> ReturnT invokeAgentRuntime(InvokeAgentRuntimeRequest invokeAgentRuntimeRequest,
            ResponseTransformer<InvokeAgentRuntimeResponse, ReturnT> responseTransformer) throws ServiceQuotaExceededException,
            ValidationException, AccessDeniedException, RuntimeClientErrorException, ThrottlingException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeRequest.Builder} to create
     *        a request.
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        InvokeAgentRuntimeResponse and an InputStream to the response content are provided as parameters to the
     *        callback. The callback may return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        The response data from the agent runtime. The format of this data depends on the specific agent
     *        configuration and the requested accept type. For most agents, this is a JSON object containing the agent's
     *        response to the user's request.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws RuntimeClientErrorException
     *         The exception that occurs when there is an error in the runtime client. This can happen due to network
     *         issues, invalid configuration, or other client-side problems. Check the error message for specific
     *         details about the error.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.InvokeAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> ReturnT invokeAgentRuntime(Consumer<InvokeAgentRuntimeRequest.Builder> invokeAgentRuntimeRequest,
            ResponseTransformer<InvokeAgentRuntimeResponse, ReturnT> responseTransformer) throws ServiceQuotaExceededException,
            ValidationException, AccessDeniedException, RuntimeClientErrorException, ThrottlingException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return invokeAgentRuntime(InvokeAgentRuntimeRequest.builder().applyMutation(invokeAgentRuntimeRequest).build(),
                responseTransformer);
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The response data from the agent runtime. The format of this data depends on the specific agent
     *        configuration and the requested accept type. For most agents, this is a JSON object containing the agent's
     *        response to the user's request.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws RuntimeClientErrorException
     *         The exception that occurs when there is an error in the runtime client. This can happen due to network
     *         issues, invalid configuration, or other client-side problems. Check the error message for specific
     *         details about the error.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.InvokeAgentRuntime
     * @see #invokeAgentRuntime(InvokeAgentRuntimeRequest, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default InvokeAgentRuntimeResponse invokeAgentRuntime(InvokeAgentRuntimeRequest invokeAgentRuntimeRequest,
            Path destinationPath) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException,
            RuntimeClientErrorException, ThrottlingException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return invokeAgentRuntime(invokeAgentRuntimeRequest, ResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeRequest.Builder} to create
     *        a request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The response data from the agent runtime. The format of this data depends on the specific agent
     *        configuration and the requested accept type. For most agents, this is a JSON object containing the agent's
     *        response to the user's request.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws RuntimeClientErrorException
     *         The exception that occurs when there is an error in the runtime client. This can happen due to network
     *         issues, invalid configuration, or other client-side problems. Check the error message for specific
     *         details about the error.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.InvokeAgentRuntime
     * @see #invokeAgentRuntime(InvokeAgentRuntimeRequest, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default InvokeAgentRuntimeResponse invokeAgentRuntime(Consumer<InvokeAgentRuntimeRequest.Builder> invokeAgentRuntimeRequest,
            Path destinationPath) throws ServiceQuotaExceededException, ValidationException, AccessDeniedException,
            RuntimeClientErrorException, ThrottlingException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return invokeAgentRuntime(InvokeAgentRuntimeRequest.builder().applyMutation(invokeAgentRuntimeRequest).build(),
                destinationPath);
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         The response data from the agent runtime. The format of this data depends on the specific agent
     *         configuration and the requested accept type. For most agents, this is a JSON object containing the
     *         agent's response to the user's request.
     *         </p>
     *         '.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws RuntimeClientErrorException
     *         The exception that occurs when there is an error in the runtime client. This can happen due to network
     *         issues, invalid configuration, or other client-side problems. Check the error message for specific
     *         details about the error.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.InvokeAgentRuntime
     * @see #getObject(invokeAgentRuntime, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseInputStream<InvokeAgentRuntimeResponse> invokeAgentRuntime(InvokeAgentRuntimeRequest invokeAgentRuntimeRequest)
            throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, RuntimeClientErrorException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return invokeAgentRuntime(invokeAgentRuntimeRequest, ResponseTransformer.toInputStream());
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeRequest.Builder} to create
     *        a request.
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         The response data from the agent runtime. The format of this data depends on the specific agent
     *         configuration and the requested accept type. For most agents, this is a JSON object containing the
     *         agent's response to the user's request.
     *         </p>
     *         '.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws RuntimeClientErrorException
     *         The exception that occurs when there is an error in the runtime client. This can happen due to network
     *         issues, invalid configuration, or other client-side problems. Check the error message for specific
     *         details about the error.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.InvokeAgentRuntime
     * @see #getObject(invokeAgentRuntime, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseInputStream<InvokeAgentRuntimeResponse> invokeAgentRuntime(
            Consumer<InvokeAgentRuntimeRequest.Builder> invokeAgentRuntimeRequest) throws ServiceQuotaExceededException,
            ValidationException, AccessDeniedException, RuntimeClientErrorException, ThrottlingException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return invokeAgentRuntime(InvokeAgentRuntimeRequest.builder().applyMutation(invokeAgentRuntimeRequest).build());
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         The response data from the agent runtime. The format of this data depends on the specific agent
     *         configuration and the requested accept type. For most agents, this is a JSON object containing the
     *         agent's response to the user's request.
     *         </p>
     *         '.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws RuntimeClientErrorException
     *         The exception that occurs when there is an error in the runtime client. This can happen due to network
     *         issues, invalid configuration, or other client-side problems. Check the error message for specific
     *         details about the error.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.InvokeAgentRuntime
     * @see #getObject(invokeAgentRuntime, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseBytes<InvokeAgentRuntimeResponse> invokeAgentRuntimeAsBytes(
            InvokeAgentRuntimeRequest invokeAgentRuntimeRequest) throws ServiceQuotaExceededException, ValidationException,
            AccessDeniedException, RuntimeClientErrorException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return invokeAgentRuntime(invokeAgentRuntimeRequest, ResponseTransformer.toBytes());
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeRequest.Builder} to create
     *        a request.
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         The response data from the agent runtime. The format of this data depends on the specific agent
     *         configuration and the requested accept type. For most agents, this is a JSON object containing the
     *         agent's response to the user's request.
     *         </p>
     *         '.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws RuntimeClientErrorException
     *         The exception that occurs when there is an error in the runtime client. This can happen due to network
     *         issues, invalid configuration, or other client-side problems. Check the error message for specific
     *         details about the error.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.InvokeAgentRuntime
     * @see #getObject(invokeAgentRuntime, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseBytes<InvokeAgentRuntimeResponse> invokeAgentRuntimeAsBytes(
            Consumer<InvokeAgentRuntimeRequest.Builder> invokeAgentRuntimeRequest) throws ServiceQuotaExceededException,
            ValidationException, AccessDeniedException, RuntimeClientErrorException, ThrottlingException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return invokeAgentRuntimeAsBytes(InvokeAgentRuntimeRequest.builder().applyMutation(invokeAgentRuntimeRequest).build());
    }

    /**
     * <p>
     * Lists all actors in an AgentCore Memory resource. We recommend using pagination to ensure that the operation
     * returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListActors</code> permission.
     * </p>
     *
     * @param listActorsRequest
     * @return Result of the ListActors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListActors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListActors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListActorsResponse listActors(ListActorsRequest listActorsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all actors in an AgentCore Memory resource. We recommend using pagination to ensure that the operation
     * returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListActors</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActorsRequest#builder()}
     * </p>
     *
     * @param listActorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest.Builder} to create a
     *        request.
     * @return Result of the ListActors operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListActors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListActors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListActorsResponse listActors(Consumer<ListActorsRequest.Builder> listActorsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return listActors(ListActorsRequest.builder().applyMutation(listActorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listActors(software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsIterable responses = client.listActorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsIterable responses = client
     *             .listActorsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcore.model.ListActorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsIterable responses = client.listActorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActors(software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest)} operation.</b>
     * </p>
     *
     * @param listActorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListActors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListActors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListActorsIterable listActorsPaginator(ListActorsRequest listActorsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return new ListActorsIterable(this, listActorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listActors(software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsIterable responses = client.listActorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsIterable responses = client
     *             .listActorsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcore.model.ListActorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsIterable responses = client.listActorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActors(software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActorsRequest#builder()}
     * </p>
     *
     * @param listActorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListActors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListActors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListActorsIterable listActorsPaginator(Consumer<ListActorsRequest.Builder> listActorsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return listActorsPaginator(ListActorsRequest.builder().applyMutation(listActorsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of browser sessions in Amazon Bedrock that match the specified criteria. This operation returns
     * summary information about each session, including identifiers, status, and timestamps.
     * </p>
     * <p>
     * You can filter the results by browser identifier and session status. The operation supports pagination to handle
     * large result sets efficiently.
     * </p>
     * <p>
     * We recommend using pagination to ensure that the operation returns quickly and successfully when retrieving large
     * numbers of sessions.
     * </p>
     * <p>
     * The following operations are related to <code>ListBrowserSessions</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listBrowserSessionsRequest
     * @return Result of the ListBrowserSessions operation returned by the service.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListBrowserSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListBrowserSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowserSessionsResponse listBrowserSessions(ListBrowserSessionsRequest listBrowserSessionsRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of browser sessions in Amazon Bedrock that match the specified criteria. This operation returns
     * summary information about each session, including identifiers, status, and timestamps.
     * </p>
     * <p>
     * You can filter the results by browser identifier and session status. The operation supports pagination to handle
     * large result sets efficiently.
     * </p>
     * <p>
     * We recommend using pagination to ensure that the operation returns quickly and successfully when retrieving large
     * numbers of sessions.
     * </p>
     * <p>
     * The following operations are related to <code>ListBrowserSessions</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrowserSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBrowserSessionsRequest#builder()}
     * </p>
     *
     * @param listBrowserSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListBrowserSessionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListBrowserSessions operation returned by the service.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListBrowserSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListBrowserSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowserSessionsResponse listBrowserSessions(
            Consumer<ListBrowserSessionsRequest.Builder> listBrowserSessionsRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreException {
        return listBrowserSessions(ListBrowserSessionsRequest.builder().applyMutation(listBrowserSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of code interpreter sessions in Amazon Bedrock that match the specified criteria. This operation
     * returns summary information about each session, including identifiers, status, and timestamps.
     * </p>
     * <p>
     * You can filter the results by code interpreter identifier and session status. The operation supports pagination
     * to handle large result sets efficiently.
     * </p>
     * <p>
     * We recommend using pagination to ensure that the operation returns quickly and successfully when retrieving large
     * numbers of sessions.
     * </p>
     * <p>
     * The following operations are related to <code>ListCodeInterpreterSessions</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listCodeInterpreterSessionsRequest
     * @return Result of the ListCodeInterpreterSessions operation returned by the service.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListCodeInterpreterSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListCodeInterpreterSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeInterpreterSessionsResponse listCodeInterpreterSessions(
            ListCodeInterpreterSessionsRequest listCodeInterpreterSessionsRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of code interpreter sessions in Amazon Bedrock that match the specified criteria. This operation
     * returns summary information about each session, including identifiers, status, and timestamps.
     * </p>
     * <p>
     * You can filter the results by code interpreter identifier and session status. The operation supports pagination
     * to handle large result sets efficiently.
     * </p>
     * <p>
     * We recommend using pagination to ensure that the operation returns quickly and successfully when retrieving large
     * numbers of sessions.
     * </p>
     * <p>
     * The following operations are related to <code>ListCodeInterpreterSessions</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeInterpreterSessionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCodeInterpreterSessionsRequest#builder()}
     * </p>
     *
     * @param listCodeInterpreterSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListCodeInterpreterSessionsRequest.Builder}
     *        to create a request.
     * @return Result of the ListCodeInterpreterSessions operation returned by the service.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListCodeInterpreterSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListCodeInterpreterSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeInterpreterSessionsResponse listCodeInterpreterSessions(
            Consumer<ListCodeInterpreterSessionsRequest.Builder> listCodeInterpreterSessionsRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return listCodeInterpreterSessions(ListCodeInterpreterSessionsRequest.builder()
                .applyMutation(listCodeInterpreterSessionsRequest).build());
    }

    /**
     * <p>
     * Lists events in an AgentCore Memory resource based on specified criteria. We recommend using pagination to ensure
     * that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListEvents</code> permission.
     * </p>
     *
     * @param listEventsRequest
     * @return Result of the ListEvents operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventsResponse listEvents(ListEventsRequest listEventsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists events in an AgentCore Memory resource based on specified criteria. We recommend using pagination to ensure
     * that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListEvents</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventsRequest#builder()}
     * </p>
     *
     * @param listEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEvents operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventsResponse listEvents(Consumer<ListEventsRequest.Builder> listEventsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return listEvents(ListEventsRequest.builder().applyMutation(listEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEvents(software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsIterable responses = client.listEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsIterable responses = client
     *             .listEventsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcore.model.ListEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsIterable responses = client.listEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvents(software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest)} operation.</b>
     * </p>
     *
     * @param listEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventsIterable listEventsPaginator(ListEventsRequest listEventsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return new ListEventsIterable(this, listEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEvents(software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsIterable responses = client.listEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsIterable responses = client
     *             .listEventsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcore.model.ListEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsIterable responses = client.listEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvents(software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventsRequest#builder()}
     * </p>
     *
     * @param listEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventsIterable listEventsPaginator(Consumer<ListEventsRequest.Builder> listEventsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return listEventsPaginator(ListEventsRequest.builder().applyMutation(listEventsRequest).build());
    }

    /**
     * <p>
     * Lists memory records in an AgentCore Memory resource based on specified criteria. We recommend using pagination
     * to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListMemoryRecords</code> permission.
     * </p>
     *
     * @param listMemoryRecordsRequest
     * @return Result of the ListMemoryRecords operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoryRecordsResponse listMemoryRecords(ListMemoryRecordsRequest listMemoryRecordsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists memory records in an AgentCore Memory resource based on specified criteria. We recommend using pagination
     * to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListMemoryRecords</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemoryRecordsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMemoryRecordsRequest#builder()}
     * </p>
     *
     * @param listMemoryRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest.Builder} to create
     *        a request.
     * @return Result of the ListMemoryRecords operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoryRecordsResponse listMemoryRecords(Consumer<ListMemoryRecordsRequest.Builder> listMemoryRecordsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return listMemoryRecords(ListMemoryRecordsRequest.builder().applyMutation(listMemoryRecordsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsIterable responses = client.listMemoryRecordsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsIterable responses = client
     *             .listMemoryRecordsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsIterable responses = client.listMemoryRecordsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMemoryRecordsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoryRecordsIterable listMemoryRecordsPaginator(ListMemoryRecordsRequest listMemoryRecordsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return new ListMemoryRecordsIterable(this, listMemoryRecordsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsIterable responses = client.listMemoryRecordsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsIterable responses = client
     *             .listMemoryRecordsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsIterable responses = client.listMemoryRecordsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemoryRecordsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMemoryRecordsRequest#builder()}
     * </p>
     *
     * @param listMemoryRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoryRecordsIterable listMemoryRecordsPaginator(
            Consumer<ListMemoryRecordsRequest.Builder> listMemoryRecordsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return listMemoryRecordsPaginator(ListMemoryRecordsRequest.builder().applyMutation(listMemoryRecordsRequest).build());
    }

    /**
     * <p>
     * Lists sessions in an AgentCore Memory resource based on specified criteria. We recommend using pagination to
     * ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListSessions</code> permission.
     * </p>
     *
     * @param listSessionsRequest
     * @return Result of the ListSessions operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsResponse listSessions(ListSessionsRequest listSessionsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists sessions in an AgentCore Memory resource based on specified criteria. We recommend using pagination to
     * ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListSessions</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSessions operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsResponse listSessions(Consumer<ListSessionsRequest.Builder> listSessionsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return listSessions(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsIterable responses = client
     *             .listSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest)} operation.</b>
     * </p>
     *
     * @param listSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsIterable listSessionsPaginator(ListSessionsRequest listSessionsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return new ListSessionsIterable(this, listSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsIterable responses = client
     *             .listSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsIterable listSessionsPaginator(Consumer<ListSessionsRequest.Builder> listSessionsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return listSessionsPaginator(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * Searches for and retrieves memory records from an AgentCore Memory resource based on specified search criteria.
     * We recommend using pagination to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:RetrieveMemoryRecords</code> permission.
     * </p>
     *
     * @param retrieveMemoryRecordsRequest
     * @return Result of the RetrieveMemoryRecords operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.RetrieveMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/RetrieveMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveMemoryRecordsResponse retrieveMemoryRecords(RetrieveMemoryRecordsRequest retrieveMemoryRecordsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for and retrieves memory records from an AgentCore Memory resource based on specified search criteria.
     * We recommend using pagination to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:RetrieveMemoryRecords</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveMemoryRecordsRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveMemoryRecordsRequest#builder()}
     * </p>
     *
     * @param retrieveMemoryRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest.Builder} to
     *        create a request.
     * @return Result of the RetrieveMemoryRecords operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.RetrieveMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/RetrieveMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveMemoryRecordsResponse retrieveMemoryRecords(
            Consumer<RetrieveMemoryRecordsRequest.Builder> retrieveMemoryRecordsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return retrieveMemoryRecords(RetrieveMemoryRecordsRequest.builder().applyMutation(retrieveMemoryRecordsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #retrieveMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsIterable responses = client.retrieveMemoryRecordsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsIterable responses = client
     *             .retrieveMemoryRecordsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsIterable responses = client.retrieveMemoryRecordsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieveMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest)}
     * operation.</b>
     * </p>
     *
     * @param retrieveMemoryRecordsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.RetrieveMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/RetrieveMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveMemoryRecordsIterable retrieveMemoryRecordsPaginator(RetrieveMemoryRecordsRequest retrieveMemoryRecordsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InvalidInputException,
            ResourceNotFoundException, ThrottledException, ServiceException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return new RetrieveMemoryRecordsIterable(this, retrieveMemoryRecordsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #retrieveMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsIterable responses = client.retrieveMemoryRecordsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsIterable responses = client
     *             .retrieveMemoryRecordsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsIterable responses = client.retrieveMemoryRecordsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieveMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveMemoryRecordsRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveMemoryRecordsRequest#builder()}
     * </p>
     *
     * @param retrieveMemoryRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws InvalidInputException
     *         The input fails to satisfy the constraints specified by AgentCore. Check your input values and try again.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottledException
     *         The request was denied due to request throttling. Reduce the frequency of requests and try again.
     * @throws ServiceException
     *         The service encountered an internal error. Try your request again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.RetrieveMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/RetrieveMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveMemoryRecordsIterable retrieveMemoryRecordsPaginator(
            Consumer<RetrieveMemoryRecordsRequest.Builder> retrieveMemoryRecordsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InvalidInputException, ResourceNotFoundException, ThrottledException,
            ServiceException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return retrieveMemoryRecordsPaginator(RetrieveMemoryRecordsRequest.builder().applyMutation(retrieveMemoryRecordsRequest)
                .build());
    }

    /**
     * <p>
     * Creates and initializes a browser session in Amazon Bedrock. The session enables agents to navigate and interact
     * with web content, extract information from websites, and perform web-based tasks as part of their response
     * generation.
     * </p>
     * <p>
     * To create a session, you must specify a browser identifier and a name. You can also configure the viewport
     * dimensions to control the visible area of web content. The session remains active until it times out or you
     * explicitly stop it using the <code>StopBrowserSession</code> operation.
     * </p>
     * <p>
     * The following operations are related to <code>StartBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_UpdateBrowserStream.html">UpdateBrowserStream</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopBrowserSession.html">StopBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param startBrowserSessionRequest
     * @return Result of the StartBrowserSession operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ConflictException
     *         The exception that occurs when the request conflicts with the current state of the resource. This can
     *         happen when trying to modify a resource that is currently being modified by another request, or when
     *         trying to create a resource that already exists.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.StartBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StartBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBrowserSessionResponse startBrowserSession(StartBrowserSessionRequest startBrowserSessionRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and initializes a browser session in Amazon Bedrock. The session enables agents to navigate and interact
     * with web content, extract information from websites, and perform web-based tasks as part of their response
     * generation.
     * </p>
     * <p>
     * To create a session, you must specify a browser identifier and a name. You can also configure the viewport
     * dimensions to control the visible area of web content. The session remains active until it times out or you
     * explicitly stop it using the <code>StopBrowserSession</code> operation.
     * </p>
     * <p>
     * The following operations are related to <code>StartBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_UpdateBrowserStream.html">UpdateBrowserStream</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopBrowserSession.html">StopBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBrowserSessionRequest.Builder} avoiding the
     * need to create one manually via {@link StartBrowserSessionRequest#builder()}
     * </p>
     *
     * @param startBrowserSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.StartBrowserSessionRequest.Builder} to
     *        create a request.
     * @return Result of the StartBrowserSession operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ConflictException
     *         The exception that occurs when the request conflicts with the current state of the resource. This can
     *         happen when trying to modify a resource that is currently being modified by another request, or when
     *         trying to create a resource that already exists.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.StartBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StartBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBrowserSessionResponse startBrowserSession(
            Consumer<StartBrowserSessionRequest.Builder> startBrowserSessionRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return startBrowserSession(StartBrowserSessionRequest.builder().applyMutation(startBrowserSessionRequest).build());
    }

    /**
     * <p>
     * Creates and initializes a code interpreter session in Amazon Bedrock. The session enables agents to execute code
     * as part of their response generation, supporting programming languages such as Python for data analysis,
     * visualization, and computation tasks.
     * </p>
     * <p>
     * To create a session, you must specify a code interpreter identifier and a name. The session remains active until
     * it times out or you explicitly stop it using the <code>StopCodeInterpreterSession</code> operation.
     * </p>
     * <p>
     * The following operations are related to <code>StartCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_InvokeCodeInterpreter.html">InvokeCodeInterpreter</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopCodeInterpreterSession.html">StopCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param startCodeInterpreterSessionRequest
     * @return Result of the StartCodeInterpreterSession operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ConflictException
     *         The exception that occurs when the request conflicts with the current state of the resource. This can
     *         happen when trying to modify a resource that is currently being modified by another request, or when
     *         trying to create a resource that already exists.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.StartCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StartCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCodeInterpreterSessionResponse startCodeInterpreterSession(
            StartCodeInterpreterSessionRequest startCodeInterpreterSessionRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and initializes a code interpreter session in Amazon Bedrock. The session enables agents to execute code
     * as part of their response generation, supporting programming languages such as Python for data analysis,
     * visualization, and computation tasks.
     * </p>
     * <p>
     * To create a session, you must specify a code interpreter identifier and a name. The session remains active until
     * it times out or you explicitly stop it using the <code>StopCodeInterpreterSession</code> operation.
     * </p>
     * <p>
     * The following operations are related to <code>StartCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_InvokeCodeInterpreter.html">InvokeCodeInterpreter</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopCodeInterpreterSession.html">StopCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCodeInterpreterSessionRequest.Builder}
     * avoiding the need to create one manually via {@link StartCodeInterpreterSessionRequest#builder()}
     * </p>
     *
     * @param startCodeInterpreterSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.StartCodeInterpreterSessionRequest.Builder}
     *        to create a request.
     * @return Result of the StartCodeInterpreterSession operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ConflictException
     *         The exception that occurs when the request conflicts with the current state of the resource. This can
     *         happen when trying to modify a resource that is currently being modified by another request, or when
     *         trying to create a resource that already exists.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.StartCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StartCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCodeInterpreterSessionResponse startCodeInterpreterSession(
            Consumer<StartCodeInterpreterSessionRequest.Builder> startCodeInterpreterSessionRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return startCodeInterpreterSession(StartCodeInterpreterSessionRequest.builder()
                .applyMutation(startCodeInterpreterSessionRequest).build());
    }

    /**
     * <p>
     * Terminates an active browser session in Amazon Bedrock. This operation stops the session, releases associated
     * resources, and makes the session unavailable for further use.
     * </p>
     * <p>
     * To stop a browser session, you must specify both the browser identifier and the session ID. Once stopped, a
     * session cannot be restarted; you must create a new session using <code>StartBrowserSession</code>.
     * </p>
     * <p>
     * The following operations are related to <code>StopBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param stopBrowserSessionRequest
     * @return Result of the StopBrowserSession operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ConflictException
     *         The exception that occurs when the request conflicts with the current state of the resource. This can
     *         happen when trying to modify a resource that is currently being modified by another request, or when
     *         trying to create a resource that already exists.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.StopBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StopBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StopBrowserSessionResponse stopBrowserSession(StopBrowserSessionRequest stopBrowserSessionRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates an active browser session in Amazon Bedrock. This operation stops the session, releases associated
     * resources, and makes the session unavailable for further use.
     * </p>
     * <p>
     * To stop a browser session, you must specify both the browser identifier and the session ID. Once stopped, a
     * session cannot be restarted; you must create a new session using <code>StartBrowserSession</code>.
     * </p>
     * <p>
     * The following operations are related to <code>StopBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBrowserSessionRequest.Builder} avoiding the
     * need to create one manually via {@link StopBrowserSessionRequest#builder()}
     * </p>
     *
     * @param stopBrowserSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.StopBrowserSessionRequest.Builder} to create
     *        a request.
     * @return Result of the StopBrowserSession operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ConflictException
     *         The exception that occurs when the request conflicts with the current state of the resource. This can
     *         happen when trying to modify a resource that is currently being modified by another request, or when
     *         trying to create a resource that already exists.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.StopBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StopBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StopBrowserSessionResponse stopBrowserSession(Consumer<StopBrowserSessionRequest.Builder> stopBrowserSessionRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return stopBrowserSession(StopBrowserSessionRequest.builder().applyMutation(stopBrowserSessionRequest).build());
    }

    /**
     * <p>
     * Terminates an active code interpreter session in Amazon Bedrock. This operation stops the session, releases
     * associated resources, and makes the session unavailable for further use.
     * </p>
     * <p>
     * To stop a code interpreter session, you must specify both the code interpreter identifier and the session ID.
     * Once stopped, a session cannot be restarted; you must create a new session using
     * <code>StartCodeInterpreterSession</code>.
     * </p>
     * <p>
     * The following operations are related to <code>StopCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param stopCodeInterpreterSessionRequest
     * @return Result of the StopCodeInterpreterSession operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ConflictException
     *         The exception that occurs when the request conflicts with the current state of the resource. This can
     *         happen when trying to modify a resource that is currently being modified by another request, or when
     *         trying to create a resource that already exists.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.StopCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StopCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StopCodeInterpreterSessionResponse stopCodeInterpreterSession(
            StopCodeInterpreterSessionRequest stopCodeInterpreterSessionRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates an active code interpreter session in Amazon Bedrock. This operation stops the session, releases
     * associated resources, and makes the session unavailable for further use.
     * </p>
     * <p>
     * To stop a code interpreter session, you must specify both the code interpreter identifier and the session ID.
     * Once stopped, a session cannot be restarted; you must create a new session using
     * <code>StartCodeInterpreterSession</code>.
     * </p>
     * <p>
     * The following operations are related to <code>StopCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCodeInterpreterSessionRequest.Builder} avoiding
     * the need to create one manually via {@link StopCodeInterpreterSessionRequest#builder()}
     * </p>
     *
     * @param stopCodeInterpreterSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.StopCodeInterpreterSessionRequest.Builder}
     *        to create a request.
     * @return Result of the StopCodeInterpreterSession operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ConflictException
     *         The exception that occurs when the request conflicts with the current state of the resource. This can
     *         happen when trying to modify a resource that is currently being modified by another request, or when
     *         trying to create a resource that already exists.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.StopCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StopCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StopCodeInterpreterSessionResponse stopCodeInterpreterSession(
            Consumer<StopCodeInterpreterSessionRequest.Builder> stopCodeInterpreterSessionRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        return stopCodeInterpreterSession(StopCodeInterpreterSessionRequest.builder()
                .applyMutation(stopCodeInterpreterSessionRequest).build());
    }

    /**
     * <p>
     * Updates a browser stream. To use this operation, you must have permissions to perform the
     * bedrock:UpdateBrowserStream action.
     * </p>
     *
     * @param updateBrowserStreamRequest
     * @return Result of the UpdateBrowserStream operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ConflictException
     *         The exception that occurs when the request conflicts with the current state of the resource. This can
     *         happen when trying to modify a resource that is currently being modified by another request, or when
     *         trying to create a resource that already exists.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.UpdateBrowserStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/UpdateBrowserStream"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBrowserStreamResponse updateBrowserStream(UpdateBrowserStreamRequest updateBrowserStreamRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a browser stream. To use this operation, you must have permissions to perform the
     * bedrock:UpdateBrowserStream action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrowserStreamRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBrowserStreamRequest#builder()}
     * </p>
     *
     * @param updateBrowserStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.UpdateBrowserStreamRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateBrowserStream operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The exception that occurs when the request would cause a service quota to be exceeded. Review your
     *         service quotas and either reduce your request rate or request a quota increase.
     * @throws AccessDeniedException
     *         The exception that occurs when you do not have sufficient permissions to perform an action. Verify that
     *         your IAM policy includes the necessary permissions for the operation you are trying to perform.
     * @throws ConflictException
     *         The exception that occurs when the request conflicts with the current state of the resource. This can
     *         happen when trying to modify a resource that is currently being modified by another request, or when
     *         trying to create a resource that already exists.
     * @throws ValidationException
     *         The exception that occurs when the input fails to satisfy the constraints specified by the service. Check
     *         the error message for details about which input parameter is invalid and correct your request.
     * @throws ResourceNotFoundException
     *         The exception that occurs when the specified resource does not exist. This can happen when using an
     *         invalid identifier or when trying to access a resource that has been deleted.
     * @throws ThrottlingException
     *         The exception that occurs when the request was denied due to request throttling. This happens when you
     *         exceed the allowed request rate for an operation. Reduce the frequency of requests or implement
     *         exponential backoff retry logic in your application.
     * @throws InternalServerException
     *         The exception that occurs when the service encounters an unexpected internal error. This is a temporary
     *         condition that will resolve itself with retries. We recommend implementing exponential backoff retry
     *         logic in your application.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreClient.UpdateBrowserStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/UpdateBrowserStream"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBrowserStreamResponse updateBrowserStream(
            Consumer<UpdateBrowserStreamRequest.Builder> updateBrowserStreamRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreException {
        return updateBrowserStream(UpdateBrowserStreamRequest.builder().applyMutation(updateBrowserStreamRequest).build());
    }

    /**
     * Create a {@link BedrockAgentCoreClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockAgentCoreClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockAgentCoreClient}.
     */
    static BedrockAgentCoreClientBuilder builder() {
        return new DefaultBedrockAgentCoreClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default BedrockAgentCoreServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
