/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.bedrockagentcore.model.CreateEventRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.CreateEventResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteEventRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteEventResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteMemoryRecordRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteMemoryRecordResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetBrowserSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetBrowserSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetCodeInterpreterSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetCodeInterpreterSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetEventRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetEventResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetMemoryRecordRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetMemoryRecordResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceApiKeyRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceApiKeyResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceOauth2TokenRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceOauth2TokenResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForJwtRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForJwtResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForUserIdRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForUserIdResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeCodeInterpreterResponseHandler;
import software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListActorsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListBrowserSessionsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListBrowserSessionsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListCodeInterpreterSessionsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListCodeInterpreterSessionsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListEventsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.StartBrowserSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StartBrowserSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.StartCodeInterpreterSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StartCodeInterpreterSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.StopBrowserSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StopBrowserSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.StopCodeInterpreterSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StopCodeInterpreterSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.UpdateBrowserStreamRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.UpdateBrowserStreamResponse;
import software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsPublisher;
import software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsPublisher;
import software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsPublisher;
import software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsPublisher;
import software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsPublisher;

/**
 * Service client for accessing Amazon Bedrock AgentCore Data Plane Fronting Layer asynchronously. This can be created
 * using the static {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * <note>
 * <p>
 * Amazon Bedrock AgentCore is in preview release and is subject to change.
 * </p>
 * </note>
 * <p>
 * Welcome to the Amazon Bedrock AgentCore Data Plane API reference. Data Plane actions process and handle data or
 * workloads within Amazon Web Services services.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockAgentCoreAsyncClient extends AwsClient {
    String SERVICE_NAME = "bedrock-agentcore";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-agentcore";

    /**
     * <p>
     * Creates an event in an AgentCore Memory resource. Events represent interactions or activities that occur within a
     * session and are associated with specific actors.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:CreateEvent</code> permission.
     * </p>
     * <p>
     * This operation is subject to request rate limiting.
     * </p>
     *
     * @param createEventRequest
     * @return A Java Future containing the result of the CreateEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.CreateEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/CreateEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEventResponse> createEvent(CreateEventRequest createEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an event in an AgentCore Memory resource. Events represent interactions or activities that occur within a
     * session and are associated with specific actors.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:CreateEvent</code> permission.
     * </p>
     * <p>
     * This operation is subject to request rate limiting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEventRequest#builder()}
     * </p>
     *
     * @param createEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.CreateEventRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.CreateEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/CreateEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEventResponse> createEvent(Consumer<CreateEventRequest.Builder> createEventRequest) {
        return createEvent(CreateEventRequest.builder().applyMutation(createEventRequest).build());
    }

    /**
     * <p>
     * Deletes an event from an AgentCore Memory resource. When you delete an event, it is permanently removed.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:DeleteEvent</code> permission.
     * </p>
     *
     * @param deleteEventRequest
     * @return A Java Future containing the result of the DeleteEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.DeleteEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/DeleteEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventResponse> deleteEvent(DeleteEventRequest deleteEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an event from an AgentCore Memory resource. When you delete an event, it is permanently removed.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:DeleteEvent</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEventRequest#builder()}
     * </p>
     *
     * @param deleteEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.DeleteEventRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.DeleteEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/DeleteEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventResponse> deleteEvent(Consumer<DeleteEventRequest.Builder> deleteEventRequest) {
        return deleteEvent(DeleteEventRequest.builder().applyMutation(deleteEventRequest).build());
    }

    /**
     * <p>
     * Deletes a memory record from an AgentCore Memory resource. When you delete a memory record, it is permanently
     * removed.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:DeleteMemoryRecord</code> permission.
     * </p>
     *
     * @param deleteMemoryRecordRequest
     * @return A Java Future containing the result of the DeleteMemoryRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.DeleteMemoryRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/DeleteMemoryRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMemoryRecordResponse> deleteMemoryRecord(DeleteMemoryRecordRequest deleteMemoryRecordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a memory record from an AgentCore Memory resource. When you delete a memory record, it is permanently
     * removed.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:DeleteMemoryRecord</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMemoryRecordRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMemoryRecordRequest#builder()}
     * </p>
     *
     * @param deleteMemoryRecordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.DeleteMemoryRecordRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteMemoryRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.DeleteMemoryRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/DeleteMemoryRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMemoryRecordResponse> deleteMemoryRecord(
            Consumer<DeleteMemoryRecordRequest.Builder> deleteMemoryRecordRequest) {
        return deleteMemoryRecord(DeleteMemoryRecordRequest.builder().applyMutation(deleteMemoryRecordRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific browser session in Amazon Bedrock. This operation returns the
     * session's configuration, current status, associated streams, and metadata.
     * </p>
     * <p>
     * To get a browser session, you must specify both the browser identifier and the session ID. The response includes
     * information about the session's viewport configuration, timeout settings, and stream endpoints.
     * </p>
     * <p>
     * The following operations are related to <code>GetBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_ListBrowserSessions.html">ListBrowserSessions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopBrowserSession.html">StopBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBrowserSessionRequest
     * @return A Java Future containing the result of the GetBrowserSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBrowserSessionResponse> getBrowserSession(GetBrowserSessionRequest getBrowserSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific browser session in Amazon Bedrock. This operation returns the
     * session's configuration, current status, associated streams, and metadata.
     * </p>
     * <p>
     * To get a browser session, you must specify both the browser identifier and the session ID. The response includes
     * information about the session's viewport configuration, timeout settings, and stream endpoints.
     * </p>
     * <p>
     * The following operations are related to <code>GetBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_ListBrowserSessions.html">ListBrowserSessions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopBrowserSession.html">StopBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBrowserSessionRequest.Builder} avoiding the need
     * to create one manually via {@link GetBrowserSessionRequest#builder()}
     * </p>
     *
     * @param getBrowserSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetBrowserSessionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetBrowserSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBrowserSessionResponse> getBrowserSession(
            Consumer<GetBrowserSessionRequest.Builder> getBrowserSessionRequest) {
        return getBrowserSession(GetBrowserSessionRequest.builder().applyMutation(getBrowserSessionRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific code interpreter session in Amazon Bedrock. This operation
     * returns the session's configuration, current status, and metadata.
     * </p>
     * <p>
     * To get a code interpreter session, you must specify both the code interpreter identifier and the session ID. The
     * response includes information about the session's timeout settings and current status.
     * </p>
     * <p>
     * The following operations are related to <code>GetCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_ListCodeInterpreterSessions.html">ListCodeInterpreterSessions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopCodeInterpreterSession.html">StopCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getCodeInterpreterSessionRequest
     * @return A Java Future containing the result of the GetCodeInterpreterSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCodeInterpreterSessionResponse> getCodeInterpreterSession(
            GetCodeInterpreterSessionRequest getCodeInterpreterSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific code interpreter session in Amazon Bedrock. This operation
     * returns the session's configuration, current status, and metadata.
     * </p>
     * <p>
     * To get a code interpreter session, you must specify both the code interpreter identifier and the session ID. The
     * response includes information about the session's timeout settings and current status.
     * </p>
     * <p>
     * The following operations are related to <code>GetCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_ListCodeInterpreterSessions.html">ListCodeInterpreterSessions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopCodeInterpreterSession.html">StopCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodeInterpreterSessionRequest.Builder} avoiding
     * the need to create one manually via {@link GetCodeInterpreterSessionRequest#builder()}
     * </p>
     *
     * @param getCodeInterpreterSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetCodeInterpreterSessionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetCodeInterpreterSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCodeInterpreterSessionResponse> getCodeInterpreterSession(
            Consumer<GetCodeInterpreterSessionRequest.Builder> getCodeInterpreterSessionRequest) {
        return getCodeInterpreterSession(GetCodeInterpreterSessionRequest.builder()
                .applyMutation(getCodeInterpreterSessionRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific event in an AgentCore Memory resource.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:GetEvent</code> permission.
     * </p>
     *
     * @param getEventRequest
     * @return A Java Future containing the result of the GetEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventResponse> getEvent(GetEventRequest getEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific event in an AgentCore Memory resource.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:GetEvent</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventRequest#builder()}
     * </p>
     *
     * @param getEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetEventRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventResponse> getEvent(Consumer<GetEventRequest.Builder> getEventRequest) {
        return getEvent(GetEventRequest.builder().applyMutation(getEventRequest).build());
    }

    /**
     * <p>
     * Retrieves a specific memory record from an AgentCore Memory resource.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:GetMemoryRecord</code> permission.
     * </p>
     *
     * @param getMemoryRecordRequest
     * @return A Java Future containing the result of the GetMemoryRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetMemoryRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetMemoryRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMemoryRecordResponse> getMemoryRecord(GetMemoryRecordRequest getMemoryRecordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specific memory record from an AgentCore Memory resource.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:GetMemoryRecord</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemoryRecordRequest.Builder} avoiding the need
     * to create one manually via {@link GetMemoryRecordRequest#builder()}
     * </p>
     *
     * @param getMemoryRecordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetMemoryRecordRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMemoryRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetMemoryRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetMemoryRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMemoryRecordResponse> getMemoryRecord(
            Consumer<GetMemoryRecordRequest.Builder> getMemoryRecordRequest) {
        return getMemoryRecord(GetMemoryRecordRequest.builder().applyMutation(getMemoryRecordRequest).build());
    }

    /**
     * <p>
     * Retrieves an API Key associated with an API Key Credential Provider
     * </p>
     *
     * @param getResourceApiKeyRequest
     * @return A Java Future containing the result of the GetResourceApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetResourceApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetResourceApiKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceApiKeyResponse> getResourceApiKey(GetResourceApiKeyRequest getResourceApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an API Key associated with an API Key Credential Provider
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceApiKeyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourceApiKeyRequest#builder()}
     * </p>
     *
     * @param getResourceApiKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetResourceApiKeyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetResourceApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetResourceApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetResourceApiKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceApiKeyResponse> getResourceApiKey(
            Consumer<GetResourceApiKeyRequest.Builder> getResourceApiKeyRequest) {
        return getResourceApiKey(GetResourceApiKeyRequest.builder().applyMutation(getResourceApiKeyRequest).build());
    }

    /**
     * <p>
     * Returns the OAuth 2.0 token of the provided resource
     * </p>
     *
     * @param getResourceOauth2TokenRequest
     * @return A Java Future containing the result of the GetResourceOauth2Token operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetResourceOauth2Token
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetResourceOauth2Token"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceOauth2TokenResponse> getResourceOauth2Token(
            GetResourceOauth2TokenRequest getResourceOauth2TokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the OAuth 2.0 token of the provided resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceOauth2TokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceOauth2TokenRequest#builder()}
     * </p>
     *
     * @param getResourceOauth2TokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetResourceOauth2TokenRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetResourceOauth2Token operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetResourceOauth2Token
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetResourceOauth2Token"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceOauth2TokenResponse> getResourceOauth2Token(
            Consumer<GetResourceOauth2TokenRequest.Builder> getResourceOauth2TokenRequest) {
        return getResourceOauth2Token(GetResourceOauth2TokenRequest.builder().applyMutation(getResourceOauth2TokenRequest)
                .build());
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads not acting on behalf of user.
     * </p>
     *
     * @param getWorkloadAccessTokenRequest
     * @return A Java Future containing the result of the GetWorkloadAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetWorkloadAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkloadAccessTokenResponse> getWorkloadAccessToken(
            GetWorkloadAccessTokenRequest getWorkloadAccessTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads not acting on behalf of user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadAccessTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkloadAccessTokenRequest#builder()}
     * </p>
     *
     * @param getWorkloadAccessTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetWorkloadAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetWorkloadAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkloadAccessTokenResponse> getWorkloadAccessToken(
            Consumer<GetWorkloadAccessTokenRequest.Builder> getWorkloadAccessTokenRequest) {
        return getWorkloadAccessToken(GetWorkloadAccessTokenRequest.builder().applyMutation(getWorkloadAccessTokenRequest)
                .build());
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads acting on behalf of user with JWT token
     * </p>
     *
     * @param getWorkloadAccessTokenForJwtRequest
     * @return A Java Future containing the result of the GetWorkloadAccessTokenForJWT operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetWorkloadAccessTokenForJWT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessTokenForJWT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkloadAccessTokenForJwtResponse> getWorkloadAccessTokenForJWT(
            GetWorkloadAccessTokenForJwtRequest getWorkloadAccessTokenForJwtRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads acting on behalf of user with JWT token
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadAccessTokenForJwtRequest.Builder}
     * avoiding the need to create one manually via {@link GetWorkloadAccessTokenForJwtRequest#builder()}
     * </p>
     *
     * @param getWorkloadAccessTokenForJwtRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForJwtRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetWorkloadAccessTokenForJWT operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetWorkloadAccessTokenForJWT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessTokenForJWT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkloadAccessTokenForJwtResponse> getWorkloadAccessTokenForJWT(
            Consumer<GetWorkloadAccessTokenForJwtRequest.Builder> getWorkloadAccessTokenForJwtRequest) {
        return getWorkloadAccessTokenForJWT(GetWorkloadAccessTokenForJwtRequest.builder()
                .applyMutation(getWorkloadAccessTokenForJwtRequest).build());
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads acting on behalf of user with User Id.
     * </p>
     *
     * @param getWorkloadAccessTokenForUserIdRequest
     * @return A Java Future containing the result of the GetWorkloadAccessTokenForUserId operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetWorkloadAccessTokenForUserId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessTokenForUserId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkloadAccessTokenForUserIdResponse> getWorkloadAccessTokenForUserId(
            GetWorkloadAccessTokenForUserIdRequest getWorkloadAccessTokenForUserIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains an Workload access token for agentic workloads acting on behalf of user with User Id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadAccessTokenForUserIdRequest.Builder}
     * avoiding the need to create one manually via {@link GetWorkloadAccessTokenForUserIdRequest#builder()}
     * </p>
     *
     * @param getWorkloadAccessTokenForUserIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForUserIdRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetWorkloadAccessTokenForUserId operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.GetWorkloadAccessTokenForUserId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/GetWorkloadAccessTokenForUserId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkloadAccessTokenForUserIdResponse> getWorkloadAccessTokenForUserId(
            Consumer<GetWorkloadAccessTokenForUserIdRequest.Builder> getWorkloadAccessTokenForUserIdRequest) {
        return getWorkloadAccessTokenForUserId(GetWorkloadAccessTokenForUserIdRequest.builder()
                .applyMutation(getWorkloadAccessTokenForUserIdRequest).build());
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The response data from the agent runtime. The format of this data depends on the specific agent
     *        configuration and the requested accept type. For most agents, this is a JSON object containing the agent's
     *        response to the user's request.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>RuntimeClientErrorException The exception that occurs when there is an error in the runtime client.
     *         This can happen due to network issues, invalid configuration, or other client-side problems. Check the
     *         error message for specific details about the error.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.InvokeAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> invokeAgentRuntime(InvokeAgentRuntimeRequest invokeAgentRuntimeRequest,
            AsyncResponseTransformer<InvokeAgentRuntimeResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeRequest.Builder} to create
     *        a request.
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The response data from the agent runtime. The format of this data depends on the specific agent
     *        configuration and the requested accept type. For most agents, this is a JSON object containing the agent's
     *        response to the user's request.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>RuntimeClientErrorException The exception that occurs when there is an error in the runtime client.
     *         This can happen due to network issues, invalid configuration, or other client-side problems. Check the
     *         error message for specific details about the error.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.InvokeAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> invokeAgentRuntime(
            Consumer<InvokeAgentRuntimeRequest.Builder> invokeAgentRuntimeRequest,
            AsyncResponseTransformer<InvokeAgentRuntimeResponse, ReturnT> asyncResponseTransformer) {
        return invokeAgentRuntime(InvokeAgentRuntimeRequest.builder().applyMutation(invokeAgentRuntimeRequest).build(),
                asyncResponseTransformer);
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The response data from the agent runtime. The format of this data depends on the specific agent
     *        configuration and the requested accept type. For most agents, this is a JSON object containing the agent's
     *        response to the user's request.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>RuntimeClientErrorException The exception that occurs when there is an error in the runtime client.
     *         This can happen due to network issues, invalid configuration, or other client-side problems. Check the
     *         error message for specific details about the error.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.InvokeAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InvokeAgentRuntimeResponse> invokeAgentRuntime(InvokeAgentRuntimeRequest invokeAgentRuntimeRequest,
            Path destinationPath) {
        return invokeAgentRuntime(invokeAgentRuntimeRequest, AsyncResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore Runtime and receives responses in
     * real-time.
     * </p>
     * <p>
     * To invoke an agent you must specify the AgentCore Runtime ARN and provide a payload containing your request. You
     * can optionally specify a qualifier to target a specific version or endpoint of the agent.
     * </p>
     * <p>
     * This operation supports streaming responses, allowing you to receive partial responses as they become available.
     * We recommend using pagination to ensure that the operation returns quickly and successfully when processing large
     * responses.
     * </p>
     * <p>
     * For example code, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html">Invoke an
     * AgentCore Runtime agent</a>.
     * </p>
     * <p>
     * If you're integrating your agent with OAuth, you can't use the Amazon Web Services SDK to call
     * <code>InvokeAgentRuntime</code>. Instead, make a HTTPS request to <code>InvokeAgentRuntime</code>. For an
     * example, see <a
     * href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html">Authenticate and
     * authorize with Inbound Auth and Outbound Auth</a>.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:InvokeAgentRuntime</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param invokeAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeRequest.Builder} to create
     *        a request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The response data from the agent runtime. The format of this data depends on the specific agent
     *        configuration and the requested accept type. For most agents, this is a JSON object containing the agent's
     *        response to the user's request.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>RuntimeClientErrorException The exception that occurs when there is an error in the runtime client.
     *         This can happen due to network issues, invalid configuration, or other client-side problems. Check the
     *         error message for specific details about the error.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.InvokeAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InvokeAgentRuntimeResponse> invokeAgentRuntime(
            Consumer<InvokeAgentRuntimeRequest.Builder> invokeAgentRuntimeRequest, Path destinationPath) {
        return invokeAgentRuntime(InvokeAgentRuntimeRequest.builder().applyMutation(invokeAgentRuntimeRequest).build(),
                destinationPath);
    }

    /**
     * <p>
     * Executes code within an active code interpreter session in Amazon Bedrock. This operation processes the provided
     * code, runs it in a secure environment, and returns the execution results including output, errors, and generated
     * visualizations.
     * </p>
     * <p>
     * To execute code, you must specify the code interpreter identifier, session ID, and the code to run in the
     * arguments parameter. The operation returns a stream containing the execution results, which can include text
     * output, error messages, and data visualizations.
     * </p>
     * <p>
     * This operation is subject to request rate limiting based on your account's service quotas.
     * </p>
     * <p>
     * The following operations are related to <code>InvokeCodeInterpreter</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param invokeCodeInterpreterRequest
     * @return A Java Future containing the result of the InvokeCodeInterpreter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.InvokeCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeCodeInterpreter(InvokeCodeInterpreterRequest invokeCodeInterpreterRequest,
            InvokeCodeInterpreterResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes code within an active code interpreter session in Amazon Bedrock. This operation processes the provided
     * code, runs it in a secure environment, and returns the execution results including output, errors, and generated
     * visualizations.
     * </p>
     * <p>
     * To execute code, you must specify the code interpreter identifier, session ID, and the code to run in the
     * arguments parameter. The operation returns a stream containing the execution results, which can include text
     * output, error messages, and data visualizations.
     * </p>
     * <p>
     * This operation is subject to request rate limiting based on your account's service quotas.
     * </p>
     * <p>
     * The following operations are related to <code>InvokeCodeInterpreter</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeCodeInterpreterRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeCodeInterpreterRequest#builder()}
     * </p>
     *
     * @param invokeCodeInterpreterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.InvokeCodeInterpreterRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the InvokeCodeInterpreter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.InvokeCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/InvokeCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeCodeInterpreter(
            Consumer<InvokeCodeInterpreterRequest.Builder> invokeCodeInterpreterRequest,
            InvokeCodeInterpreterResponseHandler asyncResponseHandler) {
        return invokeCodeInterpreter(InvokeCodeInterpreterRequest.builder().applyMutation(invokeCodeInterpreterRequest).build(),
                asyncResponseHandler);
    }

    /**
     * <p>
     * Lists all actors in an AgentCore Memory resource. We recommend using pagination to ensure that the operation
     * returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListActors</code> permission.
     * </p>
     *
     * @param listActorsRequest
     * @return A Java Future containing the result of the ListActors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListActors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListActors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListActorsResponse> listActors(ListActorsRequest listActorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all actors in an AgentCore Memory resource. We recommend using pagination to ensure that the operation
     * returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListActors</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActorsRequest#builder()}
     * </p>
     *
     * @param listActorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListActors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListActors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListActors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListActorsResponse> listActors(Consumer<ListActorsRequest.Builder> listActorsRequest) {
        return listActors(ListActorsRequest.builder().applyMutation(listActorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listActors(software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsPublisher publisher = client.listActorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsPublisher publisher = client.listActorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcore.model.ListActorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcore.model.ListActorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActors(software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest)} operation.</b>
     * </p>
     *
     * @param listActorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListActors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListActors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListActorsPublisher listActorsPaginator(ListActorsRequest listActorsRequest) {
        return new ListActorsPublisher(this, listActorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listActors(software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsPublisher publisher = client.listActorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListActorsPublisher publisher = client.listActorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcore.model.ListActorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcore.model.ListActorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActors(software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActorsRequest#builder()}
     * </p>
     *
     * @param listActorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListActors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListActors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListActorsPublisher listActorsPaginator(Consumer<ListActorsRequest.Builder> listActorsRequest) {
        return listActorsPaginator(ListActorsRequest.builder().applyMutation(listActorsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of browser sessions in Amazon Bedrock that match the specified criteria. This operation returns
     * summary information about each session, including identifiers, status, and timestamps.
     * </p>
     * <p>
     * You can filter the results by browser identifier and session status. The operation supports pagination to handle
     * large result sets efficiently.
     * </p>
     * <p>
     * We recommend using pagination to ensure that the operation returns quickly and successfully when retrieving large
     * numbers of sessions.
     * </p>
     * <p>
     * The following operations are related to <code>ListBrowserSessions</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listBrowserSessionsRequest
     * @return A Java Future containing the result of the ListBrowserSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListBrowserSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListBrowserSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBrowserSessionsResponse> listBrowserSessions(
            ListBrowserSessionsRequest listBrowserSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of browser sessions in Amazon Bedrock that match the specified criteria. This operation returns
     * summary information about each session, including identifiers, status, and timestamps.
     * </p>
     * <p>
     * You can filter the results by browser identifier and session status. The operation supports pagination to handle
     * large result sets efficiently.
     * </p>
     * <p>
     * We recommend using pagination to ensure that the operation returns quickly and successfully when retrieving large
     * numbers of sessions.
     * </p>
     * <p>
     * The following operations are related to <code>ListBrowserSessions</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrowserSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBrowserSessionsRequest#builder()}
     * </p>
     *
     * @param listBrowserSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListBrowserSessionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListBrowserSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListBrowserSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListBrowserSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBrowserSessionsResponse> listBrowserSessions(
            Consumer<ListBrowserSessionsRequest.Builder> listBrowserSessionsRequest) {
        return listBrowserSessions(ListBrowserSessionsRequest.builder().applyMutation(listBrowserSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of code interpreter sessions in Amazon Bedrock that match the specified criteria. This operation
     * returns summary information about each session, including identifiers, status, and timestamps.
     * </p>
     * <p>
     * You can filter the results by code interpreter identifier and session status. The operation supports pagination
     * to handle large result sets efficiently.
     * </p>
     * <p>
     * We recommend using pagination to ensure that the operation returns quickly and successfully when retrieving large
     * numbers of sessions.
     * </p>
     * <p>
     * The following operations are related to <code>ListCodeInterpreterSessions</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listCodeInterpreterSessionsRequest
     * @return A Java Future containing the result of the ListCodeInterpreterSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListCodeInterpreterSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListCodeInterpreterSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCodeInterpreterSessionsResponse> listCodeInterpreterSessions(
            ListCodeInterpreterSessionsRequest listCodeInterpreterSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of code interpreter sessions in Amazon Bedrock that match the specified criteria. This operation
     * returns summary information about each session, including identifiers, status, and timestamps.
     * </p>
     * <p>
     * You can filter the results by code interpreter identifier and session status. The operation supports pagination
     * to handle large result sets efficiently.
     * </p>
     * <p>
     * We recommend using pagination to ensure that the operation returns quickly and successfully when retrieving large
     * numbers of sessions.
     * </p>
     * <p>
     * The following operations are related to <code>ListCodeInterpreterSessions</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeInterpreterSessionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCodeInterpreterSessionsRequest#builder()}
     * </p>
     *
     * @param listCodeInterpreterSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListCodeInterpreterSessionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCodeInterpreterSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListCodeInterpreterSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListCodeInterpreterSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCodeInterpreterSessionsResponse> listCodeInterpreterSessions(
            Consumer<ListCodeInterpreterSessionsRequest.Builder> listCodeInterpreterSessionsRequest) {
        return listCodeInterpreterSessions(ListCodeInterpreterSessionsRequest.builder()
                .applyMutation(listCodeInterpreterSessionsRequest).build());
    }

    /**
     * <p>
     * Lists events in an AgentCore Memory resource based on specified criteria. We recommend using pagination to ensure
     * that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListEvents</code> permission.
     * </p>
     *
     * @param listEventsRequest
     * @return A Java Future containing the result of the ListEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEventsResponse> listEvents(ListEventsRequest listEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists events in an AgentCore Memory resource based on specified criteria. We recommend using pagination to ensure
     * that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListEvents</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventsRequest#builder()}
     * </p>
     *
     * @param listEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEventsResponse> listEvents(Consumer<ListEventsRequest.Builder> listEventsRequest) {
        return listEvents(ListEventsRequest.builder().applyMutation(listEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEvents(software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsPublisher publisher = client.listEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsPublisher publisher = client.listEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcore.model.ListEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcore.model.ListEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvents(software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest)} operation.</b>
     * </p>
     *
     * @param listEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventsPublisher listEventsPaginator(ListEventsRequest listEventsRequest) {
        return new ListEventsPublisher(this, listEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEvents(software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsPublisher publisher = client.listEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListEventsPublisher publisher = client.listEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcore.model.ListEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcore.model.ListEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvents(software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventsRequest#builder()}
     * </p>
     *
     * @param listEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventsPublisher listEventsPaginator(Consumer<ListEventsRequest.Builder> listEventsRequest) {
        return listEventsPaginator(ListEventsRequest.builder().applyMutation(listEventsRequest).build());
    }

    /**
     * <p>
     * Lists memory records in an AgentCore Memory resource based on specified criteria. We recommend using pagination
     * to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListMemoryRecords</code> permission.
     * </p>
     *
     * @param listMemoryRecordsRequest
     * @return A Java Future containing the result of the ListMemoryRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMemoryRecordsResponse> listMemoryRecords(ListMemoryRecordsRequest listMemoryRecordsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists memory records in an AgentCore Memory resource based on specified criteria. We recommend using pagination
     * to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListMemoryRecords</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemoryRecordsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMemoryRecordsRequest#builder()}
     * </p>
     *
     * @param listMemoryRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListMemoryRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMemoryRecordsResponse> listMemoryRecords(
            Consumer<ListMemoryRecordsRequest.Builder> listMemoryRecordsRequest) {
        return listMemoryRecords(ListMemoryRecordsRequest.builder().applyMutation(listMemoryRecordsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsPublisher publisher = client.listMemoryRecordsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsPublisher publisher = client.listMemoryRecordsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMemoryRecordsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoryRecordsPublisher listMemoryRecordsPaginator(ListMemoryRecordsRequest listMemoryRecordsRequest) {
        return new ListMemoryRecordsPublisher(this, listMemoryRecordsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsPublisher publisher = client.listMemoryRecordsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListMemoryRecordsPublisher publisher = client.listMemoryRecordsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemoryRecordsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMemoryRecordsRequest#builder()}
     * </p>
     *
     * @param listMemoryRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoryRecordsPublisher listMemoryRecordsPaginator(
            Consumer<ListMemoryRecordsRequest.Builder> listMemoryRecordsRequest) {
        return listMemoryRecordsPaginator(ListMemoryRecordsRequest.builder().applyMutation(listMemoryRecordsRequest).build());
    }

    /**
     * <p>
     * Lists sessions in an AgentCore Memory resource based on specified criteria. We recommend using pagination to
     * ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListSessions</code> permission.
     * </p>
     *
     * @param listSessionsRequest
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSessionsResponse> listSessions(ListSessionsRequest listSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists sessions in an AgentCore Memory resource based on specified criteria. We recommend using pagination to
     * ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:ListSessions</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSessionsResponse> listSessions(Consumer<ListSessionsRequest.Builder> listSessionsRequest) {
        return listSessions(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest)} operation.</b>
     * </p>
     *
     * @param listSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsPublisher listSessionsPaginator(ListSessionsRequest listSessionsRequest) {
        return new ListSessionsPublisher(this, listSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsPublisher listSessionsPaginator(Consumer<ListSessionsRequest.Builder> listSessionsRequest) {
        return listSessionsPaginator(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * Searches for and retrieves memory records from an AgentCore Memory resource based on specified search criteria.
     * We recommend using pagination to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:RetrieveMemoryRecords</code> permission.
     * </p>
     *
     * @param retrieveMemoryRecordsRequest
     * @return A Java Future containing the result of the RetrieveMemoryRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.RetrieveMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/RetrieveMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveMemoryRecordsResponse> retrieveMemoryRecords(
            RetrieveMemoryRecordsRequest retrieveMemoryRecordsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for and retrieves memory records from an AgentCore Memory resource based on specified search criteria.
     * We recommend using pagination to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * To use this operation, you must have the <code>bedrock-agentcore:RetrieveMemoryRecords</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveMemoryRecordsRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveMemoryRecordsRequest#builder()}
     * </p>
     *
     * @param retrieveMemoryRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RetrieveMemoryRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.RetrieveMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/RetrieveMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveMemoryRecordsResponse> retrieveMemoryRecords(
            Consumer<RetrieveMemoryRecordsRequest.Builder> retrieveMemoryRecordsRequest) {
        return retrieveMemoryRecords(RetrieveMemoryRecordsRequest.builder().applyMutation(retrieveMemoryRecordsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #retrieveMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsPublisher publisher = client.retrieveMemoryRecordsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsPublisher publisher = client.retrieveMemoryRecordsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieveMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest)}
     * operation.</b>
     * </p>
     *
     * @param retrieveMemoryRecordsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.RetrieveMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/RetrieveMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveMemoryRecordsPublisher retrieveMemoryRecordsPaginator(
            RetrieveMemoryRecordsRequest retrieveMemoryRecordsRequest) {
        return new RetrieveMemoryRecordsPublisher(this, retrieveMemoryRecordsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #retrieveMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsPublisher publisher = client.retrieveMemoryRecordsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcore.paginators.RetrieveMemoryRecordsPublisher publisher = client.retrieveMemoryRecordsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieveMemoryRecords(software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveMemoryRecordsRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveMemoryRecordsRequest#builder()}
     * </p>
     *
     * @param retrieveMemoryRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>InvalidInputException The input fails to satisfy the constraints specified by AgentCore. Check your
     *         input values and try again.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottledException The request was denied due to request throttling. Reduce the frequency of requests
     *         and try again.</li>
     *         <li>ServiceException The service encountered an internal error. Try your request again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.RetrieveMemoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/RetrieveMemoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveMemoryRecordsPublisher retrieveMemoryRecordsPaginator(
            Consumer<RetrieveMemoryRecordsRequest.Builder> retrieveMemoryRecordsRequest) {
        return retrieveMemoryRecordsPaginator(RetrieveMemoryRecordsRequest.builder().applyMutation(retrieveMemoryRecordsRequest)
                .build());
    }

    /**
     * <p>
     * Creates and initializes a browser session in Amazon Bedrock. The session enables agents to navigate and interact
     * with web content, extract information from websites, and perform web-based tasks as part of their response
     * generation.
     * </p>
     * <p>
     * To create a session, you must specify a browser identifier and a name. You can also configure the viewport
     * dimensions to control the visible area of web content. The session remains active until it times out or you
     * explicitly stop it using the <code>StopBrowserSession</code> operation.
     * </p>
     * <p>
     * The following operations are related to <code>StartBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_UpdateBrowserStream.html">UpdateBrowserStream</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopBrowserSession.html">StopBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param startBrowserSessionRequest
     * @return A Java Future containing the result of the StartBrowserSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.StartBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StartBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartBrowserSessionResponse> startBrowserSession(
            StartBrowserSessionRequest startBrowserSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and initializes a browser session in Amazon Bedrock. The session enables agents to navigate and interact
     * with web content, extract information from websites, and perform web-based tasks as part of their response
     * generation.
     * </p>
     * <p>
     * To create a session, you must specify a browser identifier and a name. You can also configure the viewport
     * dimensions to control the visible area of web content. The session remains active until it times out or you
     * explicitly stop it using the <code>StopBrowserSession</code> operation.
     * </p>
     * <p>
     * The following operations are related to <code>StartBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_UpdateBrowserStream.html">UpdateBrowserStream</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopBrowserSession.html">StopBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBrowserSessionRequest.Builder} avoiding the
     * need to create one manually via {@link StartBrowserSessionRequest#builder()}
     * </p>
     *
     * @param startBrowserSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.StartBrowserSessionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartBrowserSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.StartBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StartBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartBrowserSessionResponse> startBrowserSession(
            Consumer<StartBrowserSessionRequest.Builder> startBrowserSessionRequest) {
        return startBrowserSession(StartBrowserSessionRequest.builder().applyMutation(startBrowserSessionRequest).build());
    }

    /**
     * <p>
     * Creates and initializes a code interpreter session in Amazon Bedrock. The session enables agents to execute code
     * as part of their response generation, supporting programming languages such as Python for data analysis,
     * visualization, and computation tasks.
     * </p>
     * <p>
     * To create a session, you must specify a code interpreter identifier and a name. The session remains active until
     * it times out or you explicitly stop it using the <code>StopCodeInterpreterSession</code> operation.
     * </p>
     * <p>
     * The following operations are related to <code>StartCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_InvokeCodeInterpreter.html">InvokeCodeInterpreter</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopCodeInterpreterSession.html">StopCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param startCodeInterpreterSessionRequest
     * @return A Java Future containing the result of the StartCodeInterpreterSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.StartCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StartCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCodeInterpreterSessionResponse> startCodeInterpreterSession(
            StartCodeInterpreterSessionRequest startCodeInterpreterSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and initializes a code interpreter session in Amazon Bedrock. The session enables agents to execute code
     * as part of their response generation, supporting programming languages such as Python for data analysis,
     * visualization, and computation tasks.
     * </p>
     * <p>
     * To create a session, you must specify a code interpreter identifier and a name. The session remains active until
     * it times out or you explicitly stop it using the <code>StopCodeInterpreterSession</code> operation.
     * </p>
     * <p>
     * The following operations are related to <code>StartCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_InvokeCodeInterpreter.html">InvokeCodeInterpreter</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StopCodeInterpreterSession.html">StopCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCodeInterpreterSessionRequest.Builder}
     * avoiding the need to create one manually via {@link StartCodeInterpreterSessionRequest#builder()}
     * </p>
     *
     * @param startCodeInterpreterSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.StartCodeInterpreterSessionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartCodeInterpreterSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.StartCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StartCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCodeInterpreterSessionResponse> startCodeInterpreterSession(
            Consumer<StartCodeInterpreterSessionRequest.Builder> startCodeInterpreterSessionRequest) {
        return startCodeInterpreterSession(StartCodeInterpreterSessionRequest.builder()
                .applyMutation(startCodeInterpreterSessionRequest).build());
    }

    /**
     * <p>
     * Terminates an active browser session in Amazon Bedrock. This operation stops the session, releases associated
     * resources, and makes the session unavailable for further use.
     * </p>
     * <p>
     * To stop a browser session, you must specify both the browser identifier and the session ID. Once stopped, a
     * session cannot be restarted; you must create a new session using <code>StartBrowserSession</code>.
     * </p>
     * <p>
     * The following operations are related to <code>StopBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param stopBrowserSessionRequest
     * @return A Java Future containing the result of the StopBrowserSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.StopBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StopBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopBrowserSessionResponse> stopBrowserSession(StopBrowserSessionRequest stopBrowserSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates an active browser session in Amazon Bedrock. This operation stops the session, releases associated
     * resources, and makes the session unavailable for further use.
     * </p>
     * <p>
     * To stop a browser session, you must specify both the browser identifier and the session ID. Once stopped, a
     * session cannot be restarted; you must create a new session using <code>StartBrowserSession</code>.
     * </p>
     * <p>
     * The following operations are related to <code>StopBrowserSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartBrowserSession.html">StartBrowserSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetBrowserSession.html">GetBrowserSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBrowserSessionRequest.Builder} avoiding the
     * need to create one manually via {@link StopBrowserSessionRequest#builder()}
     * </p>
     *
     * @param stopBrowserSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.StopBrowserSessionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StopBrowserSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.StopBrowserSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StopBrowserSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopBrowserSessionResponse> stopBrowserSession(
            Consumer<StopBrowserSessionRequest.Builder> stopBrowserSessionRequest) {
        return stopBrowserSession(StopBrowserSessionRequest.builder().applyMutation(stopBrowserSessionRequest).build());
    }

    /**
     * <p>
     * Terminates an active code interpreter session in Amazon Bedrock. This operation stops the session, releases
     * associated resources, and makes the session unavailable for further use.
     * </p>
     * <p>
     * To stop a code interpreter session, you must specify both the code interpreter identifier and the session ID.
     * Once stopped, a session cannot be restarted; you must create a new session using
     * <code>StartCodeInterpreterSession</code>.
     * </p>
     * <p>
     * The following operations are related to <code>StopCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param stopCodeInterpreterSessionRequest
     * @return A Java Future containing the result of the StopCodeInterpreterSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.StopCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StopCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopCodeInterpreterSessionResponse> stopCodeInterpreterSession(
            StopCodeInterpreterSessionRequest stopCodeInterpreterSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates an active code interpreter session in Amazon Bedrock. This operation stops the session, releases
     * associated resources, and makes the session unavailable for further use.
     * </p>
     * <p>
     * To stop a code interpreter session, you must specify both the code interpreter identifier and the session ID.
     * Once stopped, a session cannot be restarted; you must create a new session using
     * <code>StartCodeInterpreterSession</code>.
     * </p>
     * <p>
     * The following operations are related to <code>StopCodeInterpreterSession</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html">StartCodeInterpreterSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/API_GetCodeInterpreterSession.html">GetCodeInterpreterSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCodeInterpreterSessionRequest.Builder} avoiding
     * the need to create one manually via {@link StopCodeInterpreterSessionRequest#builder()}
     * </p>
     *
     * @param stopCodeInterpreterSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.StopCodeInterpreterSessionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StopCodeInterpreterSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.StopCodeInterpreterSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/StopCodeInterpreterSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopCodeInterpreterSessionResponse> stopCodeInterpreterSession(
            Consumer<StopCodeInterpreterSessionRequest.Builder> stopCodeInterpreterSessionRequest) {
        return stopCodeInterpreterSession(StopCodeInterpreterSessionRequest.builder()
                .applyMutation(stopCodeInterpreterSessionRequest).build());
    }

    /**
     * <p>
     * Updates a browser stream. To use this operation, you must have permissions to perform the
     * bedrock:UpdateBrowserStream action.
     * </p>
     *
     * @param updateBrowserStreamRequest
     * @return A Java Future containing the result of the UpdateBrowserStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.UpdateBrowserStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/UpdateBrowserStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBrowserStreamResponse> updateBrowserStream(
            UpdateBrowserStreamRequest updateBrowserStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a browser stream. To use this operation, you must have permissions to perform the
     * bedrock:UpdateBrowserStream action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrowserStreamRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBrowserStreamRequest#builder()}
     * </p>
     *
     * @param updateBrowserStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcore.model.UpdateBrowserStreamRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateBrowserStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The exception that occurs when the request would cause a service quota
     *         to be exceeded. Review your service quotas and either reduce your request rate or request a quota
     *         increase.</li>
     *         <li>AccessDeniedException The exception that occurs when you do not have sufficient permissions to
     *         perform an action. Verify that your IAM policy includes the necessary permissions for the operation you
     *         are trying to perform.</li>
     *         <li>ConflictException The exception that occurs when the request conflicts with the current state of the
     *         resource. This can happen when trying to modify a resource that is currently being modified by another
     *         request, or when trying to create a resource that already exists.</li>
     *         <li>ValidationException The exception that occurs when the input fails to satisfy the constraints
     *         specified by the service. Check the error message for details about which input parameter is invalid and
     *         correct your request.</li>
     *         <li>ResourceNotFoundException The exception that occurs when the specified resource does not exist. This
     *         can happen when using an invalid identifier or when trying to access a resource that has been deleted.</li>
     *         <li>ThrottlingException The exception that occurs when the request was denied due to request throttling.
     *         This happens when you exceed the allowed request rate for an operation. Reduce the frequency of requests
     *         or implement exponential backoff retry logic in your application.</li>
     *         <li>InternalServerException The exception that occurs when the service encounters an unexpected internal
     *         error. This is a temporary condition that will resolve itself with retries. We recommend implementing
     *         exponential backoff retry logic in your application.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreAsyncClient.UpdateBrowserStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/UpdateBrowserStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBrowserStreamResponse> updateBrowserStream(
            Consumer<UpdateBrowserStreamRequest.Builder> updateBrowserStreamRequest) {
        return updateBrowserStream(UpdateBrowserStreamRequest.builder().applyMutation(updateBrowserStreamRequest).build());
    }

    @Override
    default BedrockAgentCoreServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockAgentCoreAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockAgentCoreAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockAgentCoreAsyncClient}.
     */
    static BedrockAgentCoreAsyncClientBuilder builder() {
        return new DefaultBedrockAgentCoreAsyncClientBuilder();
    }
}
