/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMemoryRecordsRequest extends BedrockAgentCoreRequest implements
        ToCopyableBuilder<ListMemoryRecordsRequest.Builder, ListMemoryRecordsRequest> {
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryId").getter(getter(ListMemoryRecordsRequest::memoryId)).setter(setter(Builder::memoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("memoryId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ListMemoryRecordsRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> MEMORY_STRATEGY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryStrategyId").getter(getter(ListMemoryRecordsRequest::memoryStrategyId))
            .setter(setter(Builder::memoryStrategyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategyId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListMemoryRecordsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMemoryRecordsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_ID_FIELD,
            NAMESPACE_FIELD, MEMORY_STRATEGY_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String memoryId;

    private final String namespace;

    private final String memoryStrategyId;

    private final Integer maxResults;

    private final String nextToken;

    private ListMemoryRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.memoryId = builder.memoryId;
        this.namespace = builder.namespace;
        this.memoryStrategyId = builder.memoryStrategyId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the AgentCore Memory resource for which to list memory records.
     * </p>
     * 
     * @return The identifier of the AgentCore Memory resource for which to list memory records.
     */
    public final String memoryId() {
        return memoryId;
    }

    /**
     * <p>
     * The namespace to filter memory records by. If specified, only memory records in this namespace are returned.
     * </p>
     * 
     * @return The namespace to filter memory records by. If specified, only memory records in this namespace are
     *         returned.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The memory strategy identifier to filter memory records by. If specified, only memory records with this strategy
     * ID are returned.
     * </p>
     * 
     * @return The memory strategy identifier to filter memory records by. If specified, only memory records with this
     *         strategy ID are returned.
     */
    public final String memoryStrategyId() {
        return memoryStrategyId;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. Minimum value of 1, maximum value of 100. Default is
     * 20.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. Minimum value of 1, maximum value of 100.
     *         Default is 20.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(memoryStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMemoryRecordsRequest)) {
            return false;
        }
        ListMemoryRecordsRequest other = (ListMemoryRecordsRequest) obj;
        return Objects.equals(memoryId(), other.memoryId()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(memoryStrategyId(), other.memoryStrategyId())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMemoryRecordsRequest").add("MemoryId", memoryId()).add("Namespace", namespace())
                .add("MemoryStrategyId", memoryStrategyId()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memoryId":
            return Optional.ofNullable(clazz.cast(memoryId()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "memoryStrategyId":
            return Optional.ofNullable(clazz.cast(memoryStrategyId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("memoryStrategyId", MEMORY_STRATEGY_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMemoryRecordsRequest, T> g) {
        return obj -> g.apply((ListMemoryRecordsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMemoryRecordsRequest> {
        /**
         * <p>
         * The identifier of the AgentCore Memory resource for which to list memory records.
         * </p>
         * 
         * @param memoryId
         *        The identifier of the AgentCore Memory resource for which to list memory records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryId(String memoryId);

        /**
         * <p>
         * The namespace to filter memory records by. If specified, only memory records in this namespace are returned.
         * </p>
         * 
         * @param namespace
         *        The namespace to filter memory records by. If specified, only memory records in this namespace are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The memory strategy identifier to filter memory records by. If specified, only memory records with this
         * strategy ID are returned.
         * </p>
         * 
         * @param memoryStrategyId
         *        The memory strategy identifier to filter memory records by. If specified, only memory records with
         *        this strategy ID are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryStrategyId(String memoryStrategyId);

        /**
         * <p>
         * The maximum number of results to return in a single call. Minimum value of 1, maximum value of 100. Default
         * is 20.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. Minimum value of 1, maximum value of 100.
         *        Default is 20.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreRequest.BuilderImpl implements Builder {
        private String memoryId;

        private String namespace;

        private String memoryStrategyId;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMemoryRecordsRequest model) {
            super(model);
            memoryId(model.memoryId);
            namespace(model.namespace);
            memoryStrategyId(model.memoryStrategyId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getMemoryId() {
            return memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getMemoryStrategyId() {
            return memoryStrategyId;
        }

        public final void setMemoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
        }

        @Override
        public final Builder memoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMemoryRecordsRequest build() {
            return new ListMemoryRecordsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
