/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an update to an automation stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationStreamUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationStreamUpdate.Builder, AutomationStreamUpdate> {
    private static final SdkField<String> STREAM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamStatus").getter(getter(AutomationStreamUpdate::streamStatusAsString))
            .setter(setter(Builder::streamStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streamStatus;

    private AutomationStreamUpdate(BuilderImpl builder) {
        this.streamStatus = builder.streamStatus;
    }

    /**
     * <p>
     * The status of the automation stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamStatus} will
     * return {@link AutomationStreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamStatusAsString}.
     * </p>
     * 
     * @return The status of the automation stream.
     * @see AutomationStreamStatus
     */
    public final AutomationStreamStatus streamStatus() {
        return AutomationStreamStatus.fromValue(streamStatus);
    }

    /**
     * <p>
     * The status of the automation stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamStatus} will
     * return {@link AutomationStreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamStatusAsString}.
     * </p>
     * 
     * @return The status of the automation stream.
     * @see AutomationStreamStatus
     */
    public final String streamStatusAsString() {
        return streamStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationStreamUpdate)) {
            return false;
        }
        AutomationStreamUpdate other = (AutomationStreamUpdate) obj;
        return Objects.equals(streamStatusAsString(), other.streamStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomationStreamUpdate").add("StreamStatus", streamStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamStatus":
            return Optional.ofNullable(clazz.cast(streamStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streamStatus", STREAM_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationStreamUpdate, T> g) {
        return obj -> g.apply((AutomationStreamUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationStreamUpdate> {
        /**
         * <p>
         * The status of the automation stream.
         * </p>
         * 
         * @param streamStatus
         *        The status of the automation stream.
         * @see AutomationStreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationStreamStatus
         */
        Builder streamStatus(String streamStatus);

        /**
         * <p>
         * The status of the automation stream.
         * </p>
         * 
         * @param streamStatus
         *        The status of the automation stream.
         * @see AutomationStreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationStreamStatus
         */
        Builder streamStatus(AutomationStreamStatus streamStatus);
    }

    static final class BuilderImpl implements Builder {
        private String streamStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationStreamUpdate model) {
            streamStatus(model.streamStatus);
        }

        public final String getStreamStatus() {
            return streamStatus;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(AutomationStreamStatus streamStatus) {
            this.streamStatus(streamStatus == null ? null : streamStatus.toString());
            return this;
        }

        @Override
        public AutomationStreamUpdate build() {
            return new AutomationStreamUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
