/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolResultStructuredContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolResultStructuredContent> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(ToolResultStructuredContent.getter(ToolResultStructuredContent::taskId)).setter(ToolResultStructuredContent.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskStatus").getter(ToolResultStructuredContent.getter(ToolResultStructuredContent::taskStatusAsString)).setter(ToolResultStructuredContent.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()}).build();
    private static final SdkField<String> STDOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stdout").getter(ToolResultStructuredContent.getter(ToolResultStructuredContent::stdout)).setter(ToolResultStructuredContent.setter(Builder::stdout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stdout").build()}).build();
    private static final SdkField<String> STDERR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stderr").getter(ToolResultStructuredContent.getter(ToolResultStructuredContent::stderr)).setter(ToolResultStructuredContent.setter(Builder::stderr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stderr").build()}).build();
    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("exitCode").getter(ToolResultStructuredContent.getter(ToolResultStructuredContent::exitCode)).setter(ToolResultStructuredContent.setter(Builder::exitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()}).build();
    private static final SdkField<Double> EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("executionTime").getter(ToolResultStructuredContent.getter(ToolResultStructuredContent::executionTime)).setter(ToolResultStructuredContent.setter(Builder::executionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TASK_STATUS_FIELD, STDOUT_FIELD, STDERR_FIELD, EXIT_CODE_FIELD, EXECUTION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ToolResultStructuredContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String taskStatus;
    private final String stdout;
    private final String stderr;
    private final Integer exitCode;
    private final Double executionTime;

    private ToolResultStructuredContent(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.stdout = builder.stdout;
        this.stderr = builder.stderr;
        this.exitCode = builder.exitCode;
        this.executionTime = builder.executionTime;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(this.taskStatus);
    }

    public final String taskStatusAsString() {
        return this.taskStatus;
    }

    public final String stdout() {
        return this.stdout;
    }

    public final String stderr() {
        return this.stderr;
    }

    public final Integer exitCode() {
        return this.exitCode;
    }

    public final Double executionTime() {
        return this.executionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stdout());
        hashCode = 31 * hashCode + Objects.hashCode(this.stderr());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolResultStructuredContent)) {
            return false;
        }
        ToolResultStructuredContent other = (ToolResultStructuredContent)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.stdout(), other.stdout()) && Objects.equals(this.stderr(), other.stderr()) && Objects.equals(this.exitCode(), other.exitCode()) && Objects.equals(this.executionTime(), other.executionTime());
    }

    public final String toString() {
        return ToString.builder((String)"ToolResultStructuredContent").add("TaskId", (Object)this.taskId()).add("TaskStatus", (Object)this.taskStatusAsString()).add("Stdout", (Object)this.stdout()).add("Stderr", (Object)this.stderr()).add("ExitCode", (Object)this.exitCode()).add("ExecutionTime", (Object)this.executionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "taskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "stdout": {
                return Optional.ofNullable(clazz.cast(this.stdout()));
            }
            case "stderr": {
                return Optional.ofNullable(clazz.cast(this.stderr()));
            }
            case "exitCode": {
                return Optional.ofNullable(clazz.cast(this.exitCode()));
            }
            case "executionTime": {
                return Optional.ofNullable(clazz.cast(this.executionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", TASK_ID_FIELD);
        map.put("taskStatus", TASK_STATUS_FIELD);
        map.put("stdout", STDOUT_FIELD);
        map.put("stderr", STDERR_FIELD);
        map.put("exitCode", EXIT_CODE_FIELD);
        map.put("executionTime", EXECUTION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolResultStructuredContent, T> g) {
        return obj -> g.apply((ToolResultStructuredContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String taskStatus;
        private String stdout;
        private String stderr;
        private Integer exitCode;
        private Double executionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolResultStructuredContent model) {
            this.taskId(model.taskId);
            this.taskStatus(model.taskStatus);
            this.stdout(model.stdout);
            this.stderr(model.stderr);
            this.exitCode(model.exitCode);
            this.executionTime(model.executionTime);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final String getStdout() {
            return this.stdout;
        }

        public final void setStdout(String stdout) {
            this.stdout = stdout;
        }

        @Override
        public final Builder stdout(String stdout) {
            this.stdout = stdout;
            return this;
        }

        public final String getStderr() {
            return this.stderr;
        }

        public final void setStderr(String stderr) {
            this.stderr = stderr;
        }

        @Override
        public final Builder stderr(String stderr) {
            this.stderr = stderr;
            return this;
        }

        public final Integer getExitCode() {
            return this.exitCode;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final Double getExecutionTime() {
            return this.executionTime;
        }

        public final void setExecutionTime(Double executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Double executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public ToolResultStructuredContent build() {
            return new ToolResultStructuredContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolResultStructuredContent> {
        public Builder taskId(String var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(TaskStatus var1);

        public Builder stdout(String var1);

        public Builder stderr(String var1);

        public Builder exitCode(Integer var1);

        public Builder executionTime(Double var1);
    }
}

