/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.BrowserSessionStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartBrowserSessionResponse
extends BedrockAgentCoreResponse
implements ToCopyableBuilder<Builder, StartBrowserSessionResponse> {
    private static final SdkField<String> BROWSER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserIdentifier").getter(StartBrowserSessionResponse.getter(StartBrowserSessionResponse::browserIdentifier)).setter(StartBrowserSessionResponse.setter(Builder::browserIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserIdentifier").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(StartBrowserSessionResponse.getter(StartBrowserSessionResponse::sessionId)).setter(StartBrowserSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(StartBrowserSessionResponse.getter(StartBrowserSessionResponse::createdAt)).setter(StartBrowserSessionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<BrowserSessionStream> STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streams").getter(StartBrowserSessionResponse.getter(StartBrowserSessionResponse::streams)).setter(StartBrowserSessionResponse.setter(Builder::streams)).constructor(BrowserSessionStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streams").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_IDENTIFIER_FIELD, SESSION_ID_FIELD, CREATED_AT_FIELD, STREAMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartBrowserSessionResponse.memberNameToFieldInitializer();
    private final String browserIdentifier;
    private final String sessionId;
    private final Instant createdAt;
    private final BrowserSessionStream streams;

    private StartBrowserSessionResponse(BuilderImpl builder) {
        super(builder);
        this.browserIdentifier = builder.browserIdentifier;
        this.sessionId = builder.sessionId;
        this.createdAt = builder.createdAt;
        this.streams = builder.streams;
    }

    public final String browserIdentifier() {
        return this.browserIdentifier;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final BrowserSessionStream streams() {
        return this.streams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.browserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.streams());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBrowserSessionResponse)) {
            return false;
        }
        StartBrowserSessionResponse other = (StartBrowserSessionResponse)((Object)obj);
        return Objects.equals(this.browserIdentifier(), other.browserIdentifier()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.streams(), other.streams());
    }

    public final String toString() {
        return ToString.builder((String)"StartBrowserSessionResponse").add("BrowserIdentifier", (Object)this.browserIdentifier()).add("SessionId", (Object)this.sessionId()).add("CreatedAt", (Object)this.createdAt()).add("Streams", (Object)this.streams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "browserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.browserIdentifier()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "streams": {
                return Optional.ofNullable(clazz.cast(this.streams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("browserIdentifier", BROWSER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("streams", STREAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartBrowserSessionResponse, T> g) {
        return obj -> g.apply((StartBrowserSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreResponse.BuilderImpl
    implements Builder {
        private String browserIdentifier;
        private String sessionId;
        private Instant createdAt;
        private BrowserSessionStream streams;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBrowserSessionResponse model) {
            super(model);
            this.browserIdentifier(model.browserIdentifier);
            this.sessionId(model.sessionId);
            this.createdAt(model.createdAt);
            this.streams(model.streams);
        }

        public final String getBrowserIdentifier() {
            return this.browserIdentifier;
        }

        public final void setBrowserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
        }

        @Override
        public final Builder browserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final BrowserSessionStream.Builder getStreams() {
            return this.streams != null ? this.streams.toBuilder() : null;
        }

        public final void setStreams(BrowserSessionStream.BuilderImpl streams) {
            this.streams = streams != null ? streams.build() : null;
        }

        @Override
        public final Builder streams(BrowserSessionStream streams) {
            this.streams = streams;
            return this;
        }

        @Override
        public StartBrowserSessionResponse build() {
            return new StartBrowserSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartBrowserSessionResponse> {
        public Builder browserIdentifier(String var1);

        public Builder sessionId(String var1);

        public Builder createdAt(Instant var1);

        public Builder streams(BrowserSessionStream var1);

        default public Builder streams(Consumer<BrowserSessionStream.Builder> streams) {
            return this.streams((BrowserSessionStream)((BrowserSessionStream.Builder)BrowserSessionStream.builder().applyMutation(streams)).build());
        }
    }
}

