/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcore.model.CodeInterpreterStreamOutput;
import software.amazon.awssdk.services.bedrockagentcore.model.ContentBlock;
import software.amazon.awssdk.services.bedrockagentcore.model.ContentBlockListCopier;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeCodeInterpreterResponseHandler;
import software.amazon.awssdk.services.bedrockagentcore.model.ToolResultStructuredContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CodeInterpreterResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeInterpreterResult>,
CodeInterpreterStreamOutput {
    private static final SdkField<List<ContentBlock>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("content").getter(CodeInterpreterResult.getter(CodeInterpreterResult::content)).setter(CodeInterpreterResult.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ToolResultStructuredContent> STRUCTURED_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("structuredContent").getter(CodeInterpreterResult.getter(CodeInterpreterResult::structuredContent)).setter(CodeInterpreterResult.setter(Builder::structuredContent)).constructor(ToolResultStructuredContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structuredContent").build()}).build();
    private static final SdkField<Boolean> IS_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isError").getter(CodeInterpreterResult.getter(CodeInterpreterResult::isError)).setter(CodeInterpreterResult.setter(Builder::isError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isError").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, STRUCTURED_CONTENT_FIELD, IS_ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeInterpreterResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ContentBlock> content;
    private final ToolResultStructuredContent structuredContent;
    private final Boolean isError;

    protected CodeInterpreterResult(BuilderImpl builder) {
        this.content = builder.content;
        this.structuredContent = builder.structuredContent;
        this.isError = builder.isError;
    }

    public final boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructList);
    }

    public final List<ContentBlock> content() {
        return this.content;
    }

    public final ToolResultStructuredContent structuredContent() {
        return this.structuredContent;
    }

    public final Boolean isError() {
        return this.isError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContent() ? this.content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.structuredContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.isError());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeInterpreterResult)) {
            return false;
        }
        CodeInterpreterResult other = (CodeInterpreterResult)obj;
        return this.hasContent() == other.hasContent() && Objects.equals(this.content(), other.content()) && Objects.equals(this.structuredContent(), other.structuredContent()) && Objects.equals(this.isError(), other.isError());
    }

    public final String toString() {
        return ToString.builder((String)"CodeInterpreterResult").add("Content", this.hasContent() ? this.content() : null).add("StructuredContent", (Object)this.structuredContent()).add("IsError", (Object)this.isError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "structuredContent": {
                return Optional.ofNullable(clazz.cast(this.structuredContent()));
            }
            case "isError": {
                return Optional.ofNullable(clazz.cast(this.isError()));
            }
        }
        return Optional.empty();
    }

    public final CodeInterpreterResult copy(Consumer<? super Builder> modifier) {
        return (CodeInterpreterResult)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("content", CONTENT_FIELD);
        map.put("structuredContent", STRUCTURED_CONTENT_FIELD);
        map.put("isError", IS_ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeInterpreterResult, T> g) {
        return obj -> g.apply((CodeInterpreterResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(InvokeCodeInterpreterResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private List<ContentBlock> content = DefaultSdkAutoConstructList.getInstance();
        private ToolResultStructuredContent structuredContent;
        private Boolean isError;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CodeInterpreterResult model) {
            this.content(model.content);
            this.structuredContent(model.structuredContent);
            this.isError(model.isError);
        }

        public final List<ContentBlock.Builder> getContent() {
            List<ContentBlock.Builder> result = ContentBlockListCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<ContentBlock.BuilderImpl> content) {
            this.content = ContentBlockListCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<ContentBlock> content) {
            this.content = ContentBlockListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(ContentBlock ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<ContentBlock.Builder> ... content) {
            this.content(Stream.of(content).map(c -> (ContentBlock)((ContentBlock.Builder)ContentBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ToolResultStructuredContent.Builder getStructuredContent() {
            return this.structuredContent != null ? this.structuredContent.toBuilder() : null;
        }

        public final void setStructuredContent(ToolResultStructuredContent.BuilderImpl structuredContent) {
            this.structuredContent = structuredContent != null ? structuredContent.build() : null;
        }

        @Override
        public final Builder structuredContent(ToolResultStructuredContent structuredContent) {
            this.structuredContent = structuredContent;
            return this;
        }

        public final Boolean getIsError() {
            return this.isError;
        }

        public final void setIsError(Boolean isError) {
            this.isError = isError;
        }

        @Override
        public final Builder isError(Boolean isError) {
            this.isError = isError;
            return this;
        }

        public CodeInterpreterResult build() {
            return new CodeInterpreterResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeInterpreterResult> {
        public Builder content(Collection<ContentBlock> var1);

        public Builder content(ContentBlock ... var1);

        public Builder content(Consumer<ContentBlock.Builder> ... var1);

        public Builder structuredContent(ToolResultStructuredContent var1);

        default public Builder structuredContent(Consumer<ToolResultStructuredContent.Builder> structuredContent) {
            return this.structuredContent((ToolResultStructuredContent)((ToolResultStructuredContent.Builder)ToolResultStructuredContent.builder().applyMutation(structuredContent)).build());
        }

        public Builder isError(Boolean var1);
    }
}

