/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.CustomRequestParametersTypeCopier;
import software.amazon.awssdk.services.bedrockagentcore.model.Oauth2FlowType;
import software.amazon.awssdk.services.bedrockagentcore.model.ScopesListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceOauth2TokenRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, GetResourceOauth2TokenRequest> {
    private static final SdkField<String> WORKLOAD_IDENTITY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadIdentityToken").getter(GetResourceOauth2TokenRequest.getter(GetResourceOauth2TokenRequest::workloadIdentityToken)).setter(GetResourceOauth2TokenRequest.setter(Builder::workloadIdentityToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityToken").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(GetResourceOauth2TokenRequest.getter(GetResourceOauth2TokenRequest::userId)).setter(GetResourceOauth2TokenRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceCredentialProviderName").getter(GetResourceOauth2TokenRequest.getter(GetResourceOauth2TokenRequest::resourceCredentialProviderName)).setter(GetResourceOauth2TokenRequest.setter(Builder::resourceCredentialProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCredentialProviderName").build()}).build();
    private static final SdkField<List<String>> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scopes").getter(GetResourceOauth2TokenRequest.getter(GetResourceOauth2TokenRequest::scopes)).setter(GetResourceOauth2TokenRequest.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OAUTH2_FLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("oauth2Flow").getter(GetResourceOauth2TokenRequest.getter(GetResourceOauth2TokenRequest::oauth2FlowAsString)).setter(GetResourceOauth2TokenRequest.setter(Builder::oauth2Flow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2Flow").build()}).build();
    private static final SdkField<String> RESOURCE_OAUTH2_RETURN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceOauth2ReturnUrl").getter(GetResourceOauth2TokenRequest.getter(GetResourceOauth2TokenRequest::resourceOauth2ReturnUrl)).setter(GetResourceOauth2TokenRequest.setter(Builder::resourceOauth2ReturnUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOauth2ReturnUrl").build()}).build();
    private static final SdkField<Boolean> FORCE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceAuthentication").getter(GetResourceOauth2TokenRequest.getter(GetResourceOauth2TokenRequest::forceAuthentication)).setter(GetResourceOauth2TokenRequest.setter(Builder::forceAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceAuthentication").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("customParameters").getter(GetResourceOauth2TokenRequest.getter(GetResourceOauth2TokenRequest::customParameters)).setter(GetResourceOauth2TokenRequest.setter(Builder::customParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_IDENTITY_TOKEN_FIELD, USER_ID_FIELD, RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD, SCOPES_FIELD, OAUTH2_FLOW_FIELD, RESOURCE_OAUTH2_RETURN_URL_FIELD, FORCE_AUTHENTICATION_FIELD, CUSTOM_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourceOauth2TokenRequest.memberNameToFieldInitializer();
    private final String workloadIdentityToken;
    private final String userId;
    private final String resourceCredentialProviderName;
    private final List<String> scopes;
    private final String oauth2Flow;
    private final String resourceOauth2ReturnUrl;
    private final Boolean forceAuthentication;
    private final Map<String, String> customParameters;

    private GetResourceOauth2TokenRequest(BuilderImpl builder) {
        super(builder);
        this.workloadIdentityToken = builder.workloadIdentityToken;
        this.userId = builder.userId;
        this.resourceCredentialProviderName = builder.resourceCredentialProviderName;
        this.scopes = builder.scopes;
        this.oauth2Flow = builder.oauth2Flow;
        this.resourceOauth2ReturnUrl = builder.resourceOauth2ReturnUrl;
        this.forceAuthentication = builder.forceAuthentication;
        this.customParameters = builder.customParameters;
    }

    public final String workloadIdentityToken() {
        return this.workloadIdentityToken;
    }

    public final String userId() {
        return this.userId;
    }

    public final String resourceCredentialProviderName() {
        return this.resourceCredentialProviderName;
    }

    public final boolean hasScopes() {
        return this.scopes != null && !(this.scopes instanceof SdkAutoConstructList);
    }

    public final List<String> scopes() {
        return this.scopes;
    }

    public final Oauth2FlowType oauth2Flow() {
        return Oauth2FlowType.fromValue(this.oauth2Flow);
    }

    public final String oauth2FlowAsString() {
        return this.oauth2Flow;
    }

    public final String resourceOauth2ReturnUrl() {
        return this.resourceOauth2ReturnUrl;
    }

    public final Boolean forceAuthentication() {
        return this.forceAuthentication;
    }

    public final boolean hasCustomParameters() {
        return this.customParameters != null && !(this.customParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customParameters() {
        return this.customParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadIdentityToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCredentialProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScopes() ? this.scopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.oauth2FlowAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOauth2ReturnUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomParameters() ? this.customParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceOauth2TokenRequest)) {
            return false;
        }
        GetResourceOauth2TokenRequest other = (GetResourceOauth2TokenRequest)((Object)obj);
        return Objects.equals(this.workloadIdentityToken(), other.workloadIdentityToken()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.resourceCredentialProviderName(), other.resourceCredentialProviderName()) && this.hasScopes() == other.hasScopes() && Objects.equals(this.scopes(), other.scopes()) && Objects.equals(this.oauth2FlowAsString(), other.oauth2FlowAsString()) && Objects.equals(this.resourceOauth2ReturnUrl(), other.resourceOauth2ReturnUrl()) && Objects.equals(this.forceAuthentication(), other.forceAuthentication()) && this.hasCustomParameters() == other.hasCustomParameters() && Objects.equals(this.customParameters(), other.customParameters());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceOauth2TokenRequest").add("WorkloadIdentityToken", (Object)(this.workloadIdentityToken() == null ? null : "*** Sensitive Data Redacted ***")).add("UserId", (Object)this.userId()).add("ResourceCredentialProviderName", (Object)this.resourceCredentialProviderName()).add("Scopes", this.hasScopes() ? this.scopes() : null).add("Oauth2Flow", (Object)this.oauth2FlowAsString()).add("ResourceOauth2ReturnUrl", (Object)this.resourceOauth2ReturnUrl()).add("ForceAuthentication", (Object)this.forceAuthentication()).add("CustomParameters", (Object)(this.customParameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workloadIdentityToken": {
                return Optional.ofNullable(clazz.cast(this.workloadIdentityToken()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "resourceCredentialProviderName": {
                return Optional.ofNullable(clazz.cast(this.resourceCredentialProviderName()));
            }
            case "scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
            case "oauth2Flow": {
                return Optional.ofNullable(clazz.cast(this.oauth2FlowAsString()));
            }
            case "resourceOauth2ReturnUrl": {
                return Optional.ofNullable(clazz.cast(this.resourceOauth2ReturnUrl()));
            }
            case "forceAuthentication": {
                return Optional.ofNullable(clazz.cast(this.forceAuthentication()));
            }
            case "customParameters": {
                return Optional.ofNullable(clazz.cast(this.customParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workloadIdentityToken", WORKLOAD_IDENTITY_TOKEN_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("resourceCredentialProviderName", RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD);
        map.put("scopes", SCOPES_FIELD);
        map.put("oauth2Flow", OAUTH2_FLOW_FIELD);
        map.put("resourceOauth2ReturnUrl", RESOURCE_OAUTH2_RETURN_URL_FIELD);
        map.put("forceAuthentication", FORCE_AUTHENTICATION_FIELD);
        map.put("customParameters", CUSTOM_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceOauth2TokenRequest, T> g) {
        return obj -> g.apply((GetResourceOauth2TokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String workloadIdentityToken;
        private String userId;
        private String resourceCredentialProviderName;
        private List<String> scopes = DefaultSdkAutoConstructList.getInstance();
        private String oauth2Flow;
        private String resourceOauth2ReturnUrl;
        private Boolean forceAuthentication;
        private Map<String, String> customParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceOauth2TokenRequest model) {
            super(model);
            this.workloadIdentityToken(model.workloadIdentityToken);
            this.userId(model.userId);
            this.resourceCredentialProviderName(model.resourceCredentialProviderName);
            this.scopes(model.scopes);
            this.oauth2Flow(model.oauth2Flow);
            this.resourceOauth2ReturnUrl(model.resourceOauth2ReturnUrl);
            this.forceAuthentication(model.forceAuthentication);
            this.customParameters(model.customParameters);
        }

        public final String getWorkloadIdentityToken() {
            return this.workloadIdentityToken;
        }

        public final void setWorkloadIdentityToken(String workloadIdentityToken) {
            this.workloadIdentityToken = workloadIdentityToken;
        }

        @Override
        public final Builder workloadIdentityToken(String workloadIdentityToken) {
            this.workloadIdentityToken = workloadIdentityToken;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getResourceCredentialProviderName() {
            return this.resourceCredentialProviderName;
        }

        public final void setResourceCredentialProviderName(String resourceCredentialProviderName) {
            this.resourceCredentialProviderName = resourceCredentialProviderName;
        }

        @Override
        public final Builder resourceCredentialProviderName(String resourceCredentialProviderName) {
            this.resourceCredentialProviderName = resourceCredentialProviderName;
            return this;
        }

        public final Collection<String> getScopes() {
            if (this.scopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scopes;
        }

        public final void setScopes(Collection<String> scopes) {
            this.scopes = ScopesListTypeCopier.copy(scopes);
        }

        @Override
        public final Builder scopes(Collection<String> scopes) {
            this.scopes = ScopesListTypeCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(String ... scopes) {
            this.scopes(Arrays.asList(scopes));
            return this;
        }

        public final String getOauth2Flow() {
            return this.oauth2Flow;
        }

        public final void setOauth2Flow(String oauth2Flow) {
            this.oauth2Flow = oauth2Flow;
        }

        @Override
        public final Builder oauth2Flow(String oauth2Flow) {
            this.oauth2Flow = oauth2Flow;
            return this;
        }

        @Override
        public final Builder oauth2Flow(Oauth2FlowType oauth2Flow) {
            this.oauth2Flow(oauth2Flow == null ? null : oauth2Flow.toString());
            return this;
        }

        public final String getResourceOauth2ReturnUrl() {
            return this.resourceOauth2ReturnUrl;
        }

        public final void setResourceOauth2ReturnUrl(String resourceOauth2ReturnUrl) {
            this.resourceOauth2ReturnUrl = resourceOauth2ReturnUrl;
        }

        @Override
        public final Builder resourceOauth2ReturnUrl(String resourceOauth2ReturnUrl) {
            this.resourceOauth2ReturnUrl = resourceOauth2ReturnUrl;
            return this;
        }

        public final Boolean getForceAuthentication() {
            return this.forceAuthentication;
        }

        public final void setForceAuthentication(Boolean forceAuthentication) {
            this.forceAuthentication = forceAuthentication;
        }

        @Override
        public final Builder forceAuthentication(Boolean forceAuthentication) {
            this.forceAuthentication = forceAuthentication;
            return this;
        }

        public final Map<String, String> getCustomParameters() {
            if (this.customParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customParameters;
        }

        public final void setCustomParameters(Map<String, String> customParameters) {
            this.customParameters = CustomRequestParametersTypeCopier.copy(customParameters);
        }

        @Override
        public final Builder customParameters(Map<String, String> customParameters) {
            this.customParameters = CustomRequestParametersTypeCopier.copy(customParameters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceOauth2TokenRequest build() {
            return new GetResourceOauth2TokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceOauth2TokenRequest> {
        public Builder workloadIdentityToken(String var1);

        public Builder userId(String var1);

        public Builder resourceCredentialProviderName(String var1);

        public Builder scopes(Collection<String> var1);

        public Builder scopes(String ... var1);

        public Builder oauth2Flow(String var1);

        public Builder oauth2Flow(Oauth2FlowType var1);

        public Builder resourceOauth2ReturnUrl(String var1);

        public Builder forceAuthentication(Boolean var1);

        public Builder customParameters(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

