/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the model used to create vector embeddings for the knowledge base.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VectorKnowledgeBaseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VectorKnowledgeBaseConfiguration.Builder, VectorKnowledgeBaseConfiguration> {
    private static final SdkField<String> EMBEDDING_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("embeddingModelArn").getter(getter(VectorKnowledgeBaseConfiguration::embeddingModelArn))
            .setter(setter(Builder::embeddingModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddingModelArn").build()).build();

    private static final SdkField<EmbeddingModelConfiguration> EMBEDDING_MODEL_CONFIGURATION_FIELD = SdkField
            .<EmbeddingModelConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("embeddingModelConfiguration")
            .getter(getter(VectorKnowledgeBaseConfiguration::embeddingModelConfiguration))
            .setter(setter(Builder::embeddingModelConfiguration))
            .constructor(EmbeddingModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddingModelConfiguration")
                    .build()).build();

    private static final SdkField<SupplementalDataStorageConfiguration> SUPPLEMENTAL_DATA_STORAGE_CONFIGURATION_FIELD = SdkField
            .<SupplementalDataStorageConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("supplementalDataStorageConfiguration")
            .getter(getter(VectorKnowledgeBaseConfiguration::supplementalDataStorageConfiguration))
            .setter(setter(Builder::supplementalDataStorageConfiguration))
            .constructor(SupplementalDataStorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("supplementalDataStorageConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMBEDDING_MODEL_ARN_FIELD,
            EMBEDDING_MODEL_CONFIGURATION_FIELD, SUPPLEMENTAL_DATA_STORAGE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String embeddingModelArn;

    private final EmbeddingModelConfiguration embeddingModelConfiguration;

    private final SupplementalDataStorageConfiguration supplementalDataStorageConfiguration;

    private VectorKnowledgeBaseConfiguration(BuilderImpl builder) {
        this.embeddingModelArn = builder.embeddingModelArn;
        this.embeddingModelConfiguration = builder.embeddingModelConfiguration;
        this.supplementalDataStorageConfiguration = builder.supplementalDataStorageConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model used to create vector embeddings for the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model used to create vector embeddings for the knowledge base.
     */
    public final String embeddingModelArn() {
        return embeddingModelArn;
    }

    /**
     * <p>
     * The embeddings model configuration details for the vector model used in Knowledge Base.
     * </p>
     * 
     * @return The embeddings model configuration details for the vector model used in Knowledge Base.
     */
    public final EmbeddingModelConfiguration embeddingModelConfiguration() {
        return embeddingModelConfiguration;
    }

    /**
     * <p>
     * If you include multimodal data from your data source, use this object to specify configurations for the storage
     * location of the images extracted from your documents. These images can be retrieved and returned to the end user.
     * They can also be used in generation when using <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html"
     * >RetrieveAndGenerate</a>.
     * </p>
     * 
     * @return If you include multimodal data from your data source, use this object to specify configurations for the
     *         storage location of the images extracted from your documents. These images can be retrieved and returned
     *         to the end user. They can also be used in generation when using <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html"
     *         >RetrieveAndGenerate</a>.
     */
    public final SupplementalDataStorageConfiguration supplementalDataStorageConfiguration() {
        return supplementalDataStorageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(embeddingModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(embeddingModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(supplementalDataStorageConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorKnowledgeBaseConfiguration)) {
            return false;
        }
        VectorKnowledgeBaseConfiguration other = (VectorKnowledgeBaseConfiguration) obj;
        return Objects.equals(embeddingModelArn(), other.embeddingModelArn())
                && Objects.equals(embeddingModelConfiguration(), other.embeddingModelConfiguration())
                && Objects.equals(supplementalDataStorageConfiguration(), other.supplementalDataStorageConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VectorKnowledgeBaseConfiguration").add("EmbeddingModelArn", embeddingModelArn())
                .add("EmbeddingModelConfiguration", embeddingModelConfiguration())
                .add("SupplementalDataStorageConfiguration", supplementalDataStorageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "embeddingModelArn":
            return Optional.ofNullable(clazz.cast(embeddingModelArn()));
        case "embeddingModelConfiguration":
            return Optional.ofNullable(clazz.cast(embeddingModelConfiguration()));
        case "supplementalDataStorageConfiguration":
            return Optional.ofNullable(clazz.cast(supplementalDataStorageConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("embeddingModelArn", EMBEDDING_MODEL_ARN_FIELD);
        map.put("embeddingModelConfiguration", EMBEDDING_MODEL_CONFIGURATION_FIELD);
        map.put("supplementalDataStorageConfiguration", SUPPLEMENTAL_DATA_STORAGE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VectorKnowledgeBaseConfiguration, T> g) {
        return obj -> g.apply((VectorKnowledgeBaseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VectorKnowledgeBaseConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model used to create vector embeddings for the knowledge base.
         * </p>
         * 
         * @param embeddingModelArn
         *        The Amazon Resource Name (ARN) of the model used to create vector embeddings for the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embeddingModelArn(String embeddingModelArn);

        /**
         * <p>
         * The embeddings model configuration details for the vector model used in Knowledge Base.
         * </p>
         * 
         * @param embeddingModelConfiguration
         *        The embeddings model configuration details for the vector model used in Knowledge Base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embeddingModelConfiguration(EmbeddingModelConfiguration embeddingModelConfiguration);

        /**
         * <p>
         * The embeddings model configuration details for the vector model used in Knowledge Base.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmbeddingModelConfiguration.Builder}
         * avoiding the need to create one manually via {@link EmbeddingModelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmbeddingModelConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #embeddingModelConfiguration(EmbeddingModelConfiguration)}.
         * 
         * @param embeddingModelConfiguration
         *        a consumer that will call methods on {@link EmbeddingModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #embeddingModelConfiguration(EmbeddingModelConfiguration)
         */
        default Builder embeddingModelConfiguration(Consumer<EmbeddingModelConfiguration.Builder> embeddingModelConfiguration) {
            return embeddingModelConfiguration(EmbeddingModelConfiguration.builder().applyMutation(embeddingModelConfiguration)
                    .build());
        }

        /**
         * <p>
         * If you include multimodal data from your data source, use this object to specify configurations for the
         * storage location of the images extracted from your documents. These images can be retrieved and returned to
         * the end user. They can also be used in generation when using <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html"
         * >RetrieveAndGenerate</a>.
         * </p>
         * 
         * @param supplementalDataStorageConfiguration
         *        If you include multimodal data from your data source, use this object to specify configurations for
         *        the storage location of the images extracted from your documents. These images can be retrieved and
         *        returned to the end user. They can also be used in generation when using <a href=
         *        "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html"
         *        >RetrieveAndGenerate</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementalDataStorageConfiguration(SupplementalDataStorageConfiguration supplementalDataStorageConfiguration);

        /**
         * <p>
         * If you include multimodal data from your data source, use this object to specify configurations for the
         * storage location of the images extracted from your documents. These images can be retrieved and returned to
         * the end user. They can also be used in generation when using <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html"
         * >RetrieveAndGenerate</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SupplementalDataStorageConfiguration.Builder} avoiding the need to create one manually via
         * {@link SupplementalDataStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SupplementalDataStorageConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #supplementalDataStorageConfiguration(SupplementalDataStorageConfiguration)}.
         * 
         * @param supplementalDataStorageConfiguration
         *        a consumer that will call methods on {@link SupplementalDataStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supplementalDataStorageConfiguration(SupplementalDataStorageConfiguration)
         */
        default Builder supplementalDataStorageConfiguration(
                Consumer<SupplementalDataStorageConfiguration.Builder> supplementalDataStorageConfiguration) {
            return supplementalDataStorageConfiguration(SupplementalDataStorageConfiguration.builder()
                    .applyMutation(supplementalDataStorageConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String embeddingModelArn;

        private EmbeddingModelConfiguration embeddingModelConfiguration;

        private SupplementalDataStorageConfiguration supplementalDataStorageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorKnowledgeBaseConfiguration model) {
            embeddingModelArn(model.embeddingModelArn);
            embeddingModelConfiguration(model.embeddingModelConfiguration);
            supplementalDataStorageConfiguration(model.supplementalDataStorageConfiguration);
        }

        public final String getEmbeddingModelArn() {
            return embeddingModelArn;
        }

        public final void setEmbeddingModelArn(String embeddingModelArn) {
            this.embeddingModelArn = embeddingModelArn;
        }

        @Override
        public final Builder embeddingModelArn(String embeddingModelArn) {
            this.embeddingModelArn = embeddingModelArn;
            return this;
        }

        public final EmbeddingModelConfiguration.Builder getEmbeddingModelConfiguration() {
            return embeddingModelConfiguration != null ? embeddingModelConfiguration.toBuilder() : null;
        }

        public final void setEmbeddingModelConfiguration(EmbeddingModelConfiguration.BuilderImpl embeddingModelConfiguration) {
            this.embeddingModelConfiguration = embeddingModelConfiguration != null ? embeddingModelConfiguration.build() : null;
        }

        @Override
        public final Builder embeddingModelConfiguration(EmbeddingModelConfiguration embeddingModelConfiguration) {
            this.embeddingModelConfiguration = embeddingModelConfiguration;
            return this;
        }

        public final SupplementalDataStorageConfiguration.Builder getSupplementalDataStorageConfiguration() {
            return supplementalDataStorageConfiguration != null ? supplementalDataStorageConfiguration.toBuilder() : null;
        }

        public final void setSupplementalDataStorageConfiguration(
                SupplementalDataStorageConfiguration.BuilderImpl supplementalDataStorageConfiguration) {
            this.supplementalDataStorageConfiguration = supplementalDataStorageConfiguration != null ? supplementalDataStorageConfiguration
                    .build() : null;
        }

        @Override
        public final Builder supplementalDataStorageConfiguration(
                SupplementalDataStorageConfiguration supplementalDataStorageConfiguration) {
            this.supplementalDataStorageConfiguration = supplementalDataStorageConfiguration;
            return this;
        }

        @Override
        public VectorKnowledgeBaseConfiguration build() {
            return new VectorKnowledgeBaseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
