/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the storage configuration of the knowledge base in Amazon OpenSearch Service. For more
 * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html">Create
 * a vector index in Amazon OpenSearch Service</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenSearchServerlessConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenSearchServerlessConfiguration.Builder, OpenSearchServerlessConfiguration> {
    private static final SdkField<String> COLLECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collectionArn").getter(getter(OpenSearchServerlessConfiguration::collectionArn))
            .setter(setter(Builder::collectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionArn").build()).build();

    private static final SdkField<String> VECTOR_INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorIndexName").getter(getter(OpenSearchServerlessConfiguration::vectorIndexName))
            .setter(setter(Builder::vectorIndexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIndexName").build()).build();

    private static final SdkField<OpenSearchServerlessFieldMapping> FIELD_MAPPING_FIELD = SdkField
            .<OpenSearchServerlessFieldMapping> builder(MarshallingType.SDK_POJO).memberName("fieldMapping")
            .getter(getter(OpenSearchServerlessConfiguration::fieldMapping)).setter(setter(Builder::fieldMapping))
            .constructor(OpenSearchServerlessFieldMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ARN_FIELD,
            VECTOR_INDEX_NAME_FIELD, FIELD_MAPPING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String collectionArn;

    private final String vectorIndexName;

    private final OpenSearchServerlessFieldMapping fieldMapping;

    private OpenSearchServerlessConfiguration(BuilderImpl builder) {
        this.collectionArn = builder.collectionArn;
        this.vectorIndexName = builder.vectorIndexName;
        this.fieldMapping = builder.fieldMapping;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the OpenSearch Service vector store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the OpenSearch Service vector store.
     */
    public final String collectionArn() {
        return collectionArn;
    }

    /**
     * <p>
     * The name of the vector store.
     * </p>
     * 
     * @return The name of the vector store.
     */
    public final String vectorIndexName() {
        return vectorIndexName;
    }

    /**
     * <p>
     * Contains the names of the fields to which to map information about the vector store.
     * </p>
     * 
     * @return Contains the names of the fields to which to map information about the vector store.
     */
    public final OpenSearchServerlessFieldMapping fieldMapping() {
        return fieldMapping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(vectorIndexName());
        hashCode = 31 * hashCode + Objects.hashCode(fieldMapping());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchServerlessConfiguration)) {
            return false;
        }
        OpenSearchServerlessConfiguration other = (OpenSearchServerlessConfiguration) obj;
        return Objects.equals(collectionArn(), other.collectionArn())
                && Objects.equals(vectorIndexName(), other.vectorIndexName())
                && Objects.equals(fieldMapping(), other.fieldMapping());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenSearchServerlessConfiguration").add("CollectionArn", collectionArn())
                .add("VectorIndexName", vectorIndexName()).add("FieldMapping", fieldMapping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collectionArn":
            return Optional.ofNullable(clazz.cast(collectionArn()));
        case "vectorIndexName":
            return Optional.ofNullable(clazz.cast(vectorIndexName()));
        case "fieldMapping":
            return Optional.ofNullable(clazz.cast(fieldMapping()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collectionArn", COLLECTION_ARN_FIELD);
        map.put("vectorIndexName", VECTOR_INDEX_NAME_FIELD);
        map.put("fieldMapping", FIELD_MAPPING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchServerlessConfiguration, T> g) {
        return obj -> g.apply((OpenSearchServerlessConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenSearchServerlessConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the OpenSearch Service vector store.
         * </p>
         * 
         * @param collectionArn
         *        The Amazon Resource Name (ARN) of the OpenSearch Service vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionArn(String collectionArn);

        /**
         * <p>
         * The name of the vector store.
         * </p>
         * 
         * @param vectorIndexName
         *        The name of the vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorIndexName(String vectorIndexName);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * 
         * @param fieldMapping
         *        Contains the names of the fields to which to map information about the vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMapping(OpenSearchServerlessFieldMapping fieldMapping);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchServerlessFieldMapping.Builder}
         * avoiding the need to create one manually via {@link OpenSearchServerlessFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchServerlessFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMapping(OpenSearchServerlessFieldMapping)}.
         * 
         * @param fieldMapping
         *        a consumer that will call methods on {@link OpenSearchServerlessFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMapping(OpenSearchServerlessFieldMapping)
         */
        default Builder fieldMapping(Consumer<OpenSearchServerlessFieldMapping.Builder> fieldMapping) {
            return fieldMapping(OpenSearchServerlessFieldMapping.builder().applyMutation(fieldMapping).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String collectionArn;

        private String vectorIndexName;

        private OpenSearchServerlessFieldMapping fieldMapping;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchServerlessConfiguration model) {
            collectionArn(model.collectionArn);
            vectorIndexName(model.vectorIndexName);
            fieldMapping(model.fieldMapping);
        }

        public final String getCollectionArn() {
            return collectionArn;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final String getVectorIndexName() {
            return vectorIndexName;
        }

        public final void setVectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
        }

        @Override
        public final Builder vectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
            return this;
        }

        public final OpenSearchServerlessFieldMapping.Builder getFieldMapping() {
            return fieldMapping != null ? fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(OpenSearchServerlessFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(OpenSearchServerlessFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        @Override
        public OpenSearchServerlessConfiguration build() {
            return new OpenSearchServerlessConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
