/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a metadata attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataAttribute.Builder, MetadataAttribute> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(MetadataAttribute::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<MetadataAttributeValue> VALUE_FIELD = SdkField
            .<MetadataAttributeValue> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(MetadataAttribute::value)).setter(setter(Builder::value)).constructor(MetadataAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final MetadataAttributeValue value;

    private MetadataAttribute(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The key of the metadata attribute.
     * </p>
     * 
     * @return The key of the metadata attribute.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * Contains the value of the metadata attribute.
     * </p>
     * 
     * @return Contains the value of the metadata attribute.
     */
    public final MetadataAttributeValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataAttribute)) {
            return false;
        }
        MetadataAttribute other = (MetadataAttribute) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataAttribute").add("Key", key() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("key", KEY_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataAttribute, T> g) {
        return obj -> g.apply((MetadataAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataAttribute> {
        /**
         * <p>
         * The key of the metadata attribute.
         * </p>
         * 
         * @param key
         *        The key of the metadata attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Contains the value of the metadata attribute.
         * </p>
         * 
         * @param value
         *        Contains the value of the metadata attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(MetadataAttributeValue value);

        /**
         * <p>
         * Contains the value of the metadata attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataAttributeValue.Builder} avoiding
         * the need to create one manually via {@link MetadataAttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #value(MetadataAttributeValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link MetadataAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(MetadataAttributeValue)
         */
        default Builder value(Consumer<MetadataAttributeValue.Builder> value) {
            return value(MetadataAttributeValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private MetadataAttributeValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataAttribute model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final MetadataAttributeValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(MetadataAttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MetadataAttributeValue value) {
            this.value = value;
            return this;
        }

        @Override
        public MetadataAttribute build() {
            return new MetadataAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
