/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a knowledge base node in a flow. This node takes a query as the input and returns, as the
 * output, the retrieved responses directly (as an array) or a response generated based on the retrieved responses. For
 * more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in a
 * flow</a> in the Amazon Bedrock User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseFlowNodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseFlowNodeConfiguration.Builder, KnowledgeBaseFlowNodeConfiguration> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(KnowledgeBaseFlowNodeConfiguration::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(KnowledgeBaseFlowNodeConfiguration::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField
            .<GuardrailConfiguration> builder(MarshallingType.SDK_POJO).memberName("guardrailConfiguration")
            .getter(getter(KnowledgeBaseFlowNodeConfiguration::guardrailConfiguration))
            .setter(setter(Builder::guardrailConfiguration)).constructor(GuardrailConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfResults").getter(getter(KnowledgeBaseFlowNodeConfiguration::numberOfResults))
            .setter(setter(Builder::numberOfResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfResults").build()).build();

    private static final SdkField<KnowledgeBasePromptTemplate> PROMPT_TEMPLATE_FIELD = SdkField
            .<KnowledgeBasePromptTemplate> builder(MarshallingType.SDK_POJO).memberName("promptTemplate")
            .getter(getter(KnowledgeBaseFlowNodeConfiguration::promptTemplate)).setter(setter(Builder::promptTemplate))
            .constructor(KnowledgeBasePromptTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptTemplate").build()).build();

    private static final SdkField<PromptInferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField
            .<PromptInferenceConfiguration> builder(MarshallingType.SDK_POJO).memberName("inferenceConfiguration")
            .getter(getter(KnowledgeBaseFlowNodeConfiguration::inferenceConfiguration))
            .setter(setter(Builder::inferenceConfiguration)).constructor(PromptInferenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build())
            .build();

    private static final SdkField<VectorSearchRerankingConfiguration> RERANKING_CONFIGURATION_FIELD = SdkField
            .<VectorSearchRerankingConfiguration> builder(MarshallingType.SDK_POJO).memberName("rerankingConfiguration")
            .getter(getter(KnowledgeBaseFlowNodeConfiguration::rerankingConfiguration))
            .setter(setter(Builder::rerankingConfiguration)).constructor(VectorSearchRerankingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rerankingConfiguration").build())
            .build();

    private static final SdkField<KnowledgeBaseOrchestrationConfiguration> ORCHESTRATION_CONFIGURATION_FIELD = SdkField
            .<KnowledgeBaseOrchestrationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("orchestrationConfiguration")
            .getter(getter(KnowledgeBaseFlowNodeConfiguration::orchestrationConfiguration))
            .setter(setter(Builder::orchestrationConfiguration))
            .constructor(KnowledgeBaseOrchestrationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            MODEL_ID_FIELD, GUARDRAIL_CONFIGURATION_FIELD, NUMBER_OF_RESULTS_FIELD, PROMPT_TEMPLATE_FIELD,
            INFERENCE_CONFIGURATION_FIELD, RERANKING_CONFIGURATION_FIELD, ORCHESTRATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final String modelId;

    private final GuardrailConfiguration guardrailConfiguration;

    private final Integer numberOfResults;

    private final KnowledgeBasePromptTemplate promptTemplate;

    private final PromptInferenceConfiguration inferenceConfiguration;

    private final VectorSearchRerankingConfiguration rerankingConfiguration;

    private final KnowledgeBaseOrchestrationConfiguration orchestrationConfiguration;

    private KnowledgeBaseFlowNodeConfiguration(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.modelId = builder.modelId;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.numberOfResults = builder.numberOfResults;
        this.promptTemplate = builder.promptTemplate;
        this.inferenceConfiguration = builder.inferenceConfiguration;
        this.rerankingConfiguration = builder.rerankingConfiguration;
        this.orchestrationConfiguration = builder.orchestrationConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base to query.
     * </p>
     * 
     * @return The unique identifier of the knowledge base to query.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The unique identifier of the model or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> to
     * use to generate a response from the query results. Omit this field if you want to return the retrieved results as
     * an array.
     * </p>
     * 
     * @return The unique identifier of the model or <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference
     *         profile</a> to use to generate a response from the query results. Omit this field if you want to return
     *         the retrieved results as an array.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * Contains configurations for a guardrail to apply during query and response generation for the knowledge base in
     * this configuration.
     * </p>
     * 
     * @return Contains configurations for a guardrail to apply during query and response generation for the knowledge
     *         base in this configuration.
     */
    public final GuardrailConfiguration guardrailConfiguration() {
        return guardrailConfiguration;
    }

    /**
     * <p>
     * The number of results to retrieve from the knowledge base.
     * </p>
     * 
     * @return The number of results to retrieve from the knowledge base.
     */
    public final Integer numberOfResults() {
        return numberOfResults;
    }

    /**
     * <p>
     * A custom prompt template to use with the knowledge base for generating responses.
     * </p>
     * 
     * @return A custom prompt template to use with the knowledge base for generating responses.
     */
    public final KnowledgeBasePromptTemplate promptTemplate() {
        return promptTemplate;
    }

    /**
     * <p>
     * Contains inference configurations for the prompt.
     * </p>
     * 
     * @return Contains inference configurations for the prompt.
     */
    public final PromptInferenceConfiguration inferenceConfiguration() {
        return inferenceConfiguration;
    }

    /**
     * <p>
     * The configuration for reranking the retrieved results from the knowledge base to improve relevance.
     * </p>
     * 
     * @return The configuration for reranking the retrieved results from the knowledge base to improve relevance.
     */
    public final VectorSearchRerankingConfiguration rerankingConfiguration() {
        return rerankingConfiguration;
    }

    /**
     * <p>
     * The configuration for orchestrating the retrieval and generation process in the knowledge base node.
     * </p>
     * 
     * @return The configuration for orchestrating the retrieval and generation process in the knowledge base node.
     */
    public final KnowledgeBaseOrchestrationConfiguration orchestrationConfiguration() {
        return orchestrationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfResults());
        hashCode = 31 * hashCode + Objects.hashCode(promptTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(rerankingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(orchestrationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseFlowNodeConfiguration)) {
            return false;
        }
        KnowledgeBaseFlowNodeConfiguration other = (KnowledgeBaseFlowNodeConfiguration) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(modelId(), other.modelId())
                && Objects.equals(guardrailConfiguration(), other.guardrailConfiguration())
                && Objects.equals(numberOfResults(), other.numberOfResults())
                && Objects.equals(promptTemplate(), other.promptTemplate())
                && Objects.equals(inferenceConfiguration(), other.inferenceConfiguration())
                && Objects.equals(rerankingConfiguration(), other.rerankingConfiguration())
                && Objects.equals(orchestrationConfiguration(), other.orchestrationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseFlowNodeConfiguration").add("KnowledgeBaseId", knowledgeBaseId())
                .add("ModelId", modelId()).add("GuardrailConfiguration", guardrailConfiguration())
                .add("NumberOfResults", numberOfResults()).add("PromptTemplate", promptTemplate())
                .add("InferenceConfiguration", inferenceConfiguration()).add("RerankingConfiguration", rerankingConfiguration())
                .add("OrchestrationConfiguration", orchestrationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "guardrailConfiguration":
            return Optional.ofNullable(clazz.cast(guardrailConfiguration()));
        case "numberOfResults":
            return Optional.ofNullable(clazz.cast(numberOfResults()));
        case "promptTemplate":
            return Optional.ofNullable(clazz.cast(promptTemplate()));
        case "inferenceConfiguration":
            return Optional.ofNullable(clazz.cast(inferenceConfiguration()));
        case "rerankingConfiguration":
            return Optional.ofNullable(clazz.cast(rerankingConfiguration()));
        case "orchestrationConfiguration":
            return Optional.ofNullable(clazz.cast(orchestrationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("numberOfResults", NUMBER_OF_RESULTS_FIELD);
        map.put("promptTemplate", PROMPT_TEMPLATE_FIELD);
        map.put("inferenceConfiguration", INFERENCE_CONFIGURATION_FIELD);
        map.put("rerankingConfiguration", RERANKING_CONFIGURATION_FIELD);
        map.put("orchestrationConfiguration", ORCHESTRATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseFlowNodeConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseFlowNodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseFlowNodeConfiguration> {
        /**
         * <p>
         * The unique identifier of the knowledge base to query.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The unique identifier of the model or <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a>
         * to use to generate a response from the query results. Omit this field if you want to return the retrieved
         * results as an array.
         * </p>
         * 
         * @param modelId
         *        The unique identifier of the model or <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference
         *        profile</a> to use to generate a response from the query results. Omit this field if you want to
         *        return the retrieved results as an array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * Contains configurations for a guardrail to apply during query and response generation for the knowledge base
         * in this configuration.
         * </p>
         * 
         * @param guardrailConfiguration
         *        Contains configurations for a guardrail to apply during query and response generation for the
         *        knowledge base in this configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration);

        /**
         * <p>
         * Contains configurations for a guardrail to apply during query and response generation for the knowledge base
         * in this configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailConfiguration.Builder} avoiding
         * the need to create one manually via {@link GuardrailConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #guardrailConfiguration(GuardrailConfiguration)}.
         * 
         * @param guardrailConfiguration
         *        a consumer that will call methods on {@link GuardrailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailConfiguration(GuardrailConfiguration)
         */
        default Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return guardrailConfiguration(GuardrailConfiguration.builder().applyMutation(guardrailConfiguration).build());
        }

        /**
         * <p>
         * The number of results to retrieve from the knowledge base.
         * </p>
         * 
         * @param numberOfResults
         *        The number of results to retrieve from the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfResults(Integer numberOfResults);

        /**
         * <p>
         * A custom prompt template to use with the knowledge base for generating responses.
         * </p>
         * 
         * @param promptTemplate
         *        A custom prompt template to use with the knowledge base for generating responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptTemplate(KnowledgeBasePromptTemplate promptTemplate);

        /**
         * <p>
         * A custom prompt template to use with the knowledge base for generating responses.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBasePromptTemplate.Builder}
         * avoiding the need to create one manually via {@link KnowledgeBasePromptTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBasePromptTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #promptTemplate(KnowledgeBasePromptTemplate)}.
         * 
         * @param promptTemplate
         *        a consumer that will call methods on {@link KnowledgeBasePromptTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptTemplate(KnowledgeBasePromptTemplate)
         */
        default Builder promptTemplate(Consumer<KnowledgeBasePromptTemplate.Builder> promptTemplate) {
            return promptTemplate(KnowledgeBasePromptTemplate.builder().applyMutation(promptTemplate).build());
        }

        /**
         * <p>
         * Contains inference configurations for the prompt.
         * </p>
         * 
         * @param inferenceConfiguration
         *        Contains inference configurations for the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfiguration(PromptInferenceConfiguration inferenceConfiguration);

        /**
         * <p>
         * Contains inference configurations for the prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptInferenceConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptInferenceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptInferenceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceConfiguration(PromptInferenceConfiguration)}.
         * 
         * @param inferenceConfiguration
         *        a consumer that will call methods on {@link PromptInferenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfiguration(PromptInferenceConfiguration)
         */
        default Builder inferenceConfiguration(Consumer<PromptInferenceConfiguration.Builder> inferenceConfiguration) {
            return inferenceConfiguration(PromptInferenceConfiguration.builder().applyMutation(inferenceConfiguration).build());
        }

        /**
         * <p>
         * The configuration for reranking the retrieved results from the knowledge base to improve relevance.
         * </p>
         * 
         * @param rerankingConfiguration
         *        The configuration for reranking the retrieved results from the knowledge base to improve relevance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rerankingConfiguration(VectorSearchRerankingConfiguration rerankingConfiguration);

        /**
         * <p>
         * The configuration for reranking the retrieved results from the knowledge base to improve relevance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VectorSearchRerankingConfiguration.Builder} avoiding the need to create one manually via
         * {@link VectorSearchRerankingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorSearchRerankingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #rerankingConfiguration(VectorSearchRerankingConfiguration)}.
         * 
         * @param rerankingConfiguration
         *        a consumer that will call methods on {@link VectorSearchRerankingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rerankingConfiguration(VectorSearchRerankingConfiguration)
         */
        default Builder rerankingConfiguration(Consumer<VectorSearchRerankingConfiguration.Builder> rerankingConfiguration) {
            return rerankingConfiguration(VectorSearchRerankingConfiguration.builder().applyMutation(rerankingConfiguration)
                    .build());
        }

        /**
         * <p>
         * The configuration for orchestrating the retrieval and generation process in the knowledge base node.
         * </p>
         * 
         * @param orchestrationConfiguration
         *        The configuration for orchestrating the retrieval and generation process in the knowledge base node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestrationConfiguration(KnowledgeBaseOrchestrationConfiguration orchestrationConfiguration);

        /**
         * <p>
         * The configuration for orchestrating the retrieval and generation process in the knowledge base node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KnowledgeBaseOrchestrationConfiguration.Builder} avoiding the need to create one manually via
         * {@link KnowledgeBaseOrchestrationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseOrchestrationConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #orchestrationConfiguration(KnowledgeBaseOrchestrationConfiguration)}.
         * 
         * @param orchestrationConfiguration
         *        a consumer that will call methods on {@link KnowledgeBaseOrchestrationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orchestrationConfiguration(KnowledgeBaseOrchestrationConfiguration)
         */
        default Builder orchestrationConfiguration(
                Consumer<KnowledgeBaseOrchestrationConfiguration.Builder> orchestrationConfiguration) {
            return orchestrationConfiguration(KnowledgeBaseOrchestrationConfiguration.builder()
                    .applyMutation(orchestrationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String modelId;

        private GuardrailConfiguration guardrailConfiguration;

        private Integer numberOfResults;

        private KnowledgeBasePromptTemplate promptTemplate;

        private PromptInferenceConfiguration inferenceConfiguration;

        private VectorSearchRerankingConfiguration rerankingConfiguration;

        private KnowledgeBaseOrchestrationConfiguration orchestrationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseFlowNodeConfiguration model) {
            knowledgeBaseId(model.knowledgeBaseId);
            modelId(model.modelId);
            guardrailConfiguration(model.guardrailConfiguration);
            numberOfResults(model.numberOfResults);
            promptTemplate(model.promptTemplate);
            inferenceConfiguration(model.inferenceConfiguration);
            rerankingConfiguration(model.rerankingConfiguration);
            orchestrationConfiguration(model.orchestrationConfiguration);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return guardrailConfiguration != null ? guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final Integer getNumberOfResults() {
            return numberOfResults;
        }

        public final void setNumberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
        }

        @Override
        public final Builder numberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
            return this;
        }

        public final KnowledgeBasePromptTemplate.Builder getPromptTemplate() {
            return promptTemplate != null ? promptTemplate.toBuilder() : null;
        }

        public final void setPromptTemplate(KnowledgeBasePromptTemplate.BuilderImpl promptTemplate) {
            this.promptTemplate = promptTemplate != null ? promptTemplate.build() : null;
        }

        @Override
        public final Builder promptTemplate(KnowledgeBasePromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public final PromptInferenceConfiguration.Builder getInferenceConfiguration() {
            return inferenceConfiguration != null ? inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(PromptInferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(PromptInferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        public final VectorSearchRerankingConfiguration.Builder getRerankingConfiguration() {
            return rerankingConfiguration != null ? rerankingConfiguration.toBuilder() : null;
        }

        public final void setRerankingConfiguration(VectorSearchRerankingConfiguration.BuilderImpl rerankingConfiguration) {
            this.rerankingConfiguration = rerankingConfiguration != null ? rerankingConfiguration.build() : null;
        }

        @Override
        public final Builder rerankingConfiguration(VectorSearchRerankingConfiguration rerankingConfiguration) {
            this.rerankingConfiguration = rerankingConfiguration;
            return this;
        }

        public final KnowledgeBaseOrchestrationConfiguration.Builder getOrchestrationConfiguration() {
            return orchestrationConfiguration != null ? orchestrationConfiguration.toBuilder() : null;
        }

        public final void setOrchestrationConfiguration(
                KnowledgeBaseOrchestrationConfiguration.BuilderImpl orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration != null ? orchestrationConfiguration.build() : null;
        }

        @Override
        public final Builder orchestrationConfiguration(KnowledgeBaseOrchestrationConfiguration orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration;
            return this;
        }

        @Override
        public KnowledgeBaseFlowNodeConfiguration build() {
            return new KnowledgeBaseFlowNodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
