/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a flow that contains connections that violate loop boundary rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidLoopBoundaryFlowValidationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<InvalidLoopBoundaryFlowValidationDetails.Builder, InvalidLoopBoundaryFlowValidationDetails> {
    private static final SdkField<String> CONNECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connection").getter(getter(InvalidLoopBoundaryFlowValidationDetails::connection))
            .setter(setter(Builder::connection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connection").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(InvalidLoopBoundaryFlowValidationDetails::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(InvalidLoopBoundaryFlowValidationDetails::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_FIELD,
            SOURCE_FIELD, TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connection;

    private final String source;

    private final String target;

    private InvalidLoopBoundaryFlowValidationDetails(BuilderImpl builder) {
        this.connection = builder.connection;
        this.source = builder.source;
        this.target = builder.target;
    }

    /**
     * <p>
     * The name of the connection that violates loop boundary rules.
     * </p>
     * 
     * @return The name of the connection that violates loop boundary rules.
     */
    public final String connection() {
        return connection;
    }

    /**
     * <p>
     * The source node of the connection that violates DoWhile loop boundary rules.
     * </p>
     * 
     * @return The source node of the connection that violates DoWhile loop boundary rules.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The target node of the connection that violates DoWhile loop boundary rules.
     * </p>
     * 
     * @return The target node of the connection that violates DoWhile loop boundary rules.
     */
    public final String target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connection());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidLoopBoundaryFlowValidationDetails)) {
            return false;
        }
        InvalidLoopBoundaryFlowValidationDetails other = (InvalidLoopBoundaryFlowValidationDetails) obj;
        return Objects.equals(connection(), other.connection()) && Objects.equals(source(), other.source())
                && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvalidLoopBoundaryFlowValidationDetails").add("Connection", connection())
                .add("Source", source()).add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connection":
            return Optional.ofNullable(clazz.cast(connection()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connection", CONNECTION_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("target", TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidLoopBoundaryFlowValidationDetails, T> g) {
        return obj -> g.apply((InvalidLoopBoundaryFlowValidationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidLoopBoundaryFlowValidationDetails> {
        /**
         * <p>
         * The name of the connection that violates loop boundary rules.
         * </p>
         * 
         * @param connection
         *        The name of the connection that violates loop boundary rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connection(String connection);

        /**
         * <p>
         * The source node of the connection that violates DoWhile loop boundary rules.
         * </p>
         * 
         * @param source
         *        The source node of the connection that violates DoWhile loop boundary rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The target node of the connection that violates DoWhile loop boundary rules.
         * </p>
         * 
         * @param target
         *        The target node of the connection that violates DoWhile loop boundary rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);
    }

    static final class BuilderImpl implements Builder {
        private String connection;

        private String source;

        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidLoopBoundaryFlowValidationDetails model) {
            connection(model.connection);
            source(model.source);
            target(model.target);
        }

        public final String getConnection() {
            return connection;
        }

        public final void setConnection(String connection) {
            this.connection = connection;
        }

        @Override
        public final Builder connection(String connection) {
            this.connection = connection;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public InvalidLoopBoundaryFlowValidationDetails build() {
            return new InvalidLoopBoundaryFlowValidationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
