/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configurations for when you choose fixed-size chunking. If you set the <code>chunkingStrategy</code> as
 * <code>NONE</code>, exclude this field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FixedSizeChunkingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FixedSizeChunkingConfiguration.Builder, FixedSizeChunkingConfiguration> {
    private static final SdkField<Integer> MAX_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxTokens").getter(getter(FixedSizeChunkingConfiguration::maxTokens)).setter(setter(Builder::maxTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxTokens").build()).build();

    private static final SdkField<Integer> OVERLAP_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("overlapPercentage").getter(getter(FixedSizeChunkingConfiguration::overlapPercentage))
            .setter(setter(Builder::overlapPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overlapPercentage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_TOKENS_FIELD,
            OVERLAP_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxTokens;

    private final Integer overlapPercentage;

    private FixedSizeChunkingConfiguration(BuilderImpl builder) {
        this.maxTokens = builder.maxTokens;
        this.overlapPercentage = builder.overlapPercentage;
    }

    /**
     * <p>
     * The maximum number of tokens to include in a chunk.
     * </p>
     * 
     * @return The maximum number of tokens to include in a chunk.
     */
    public final Integer maxTokens() {
        return maxTokens;
    }

    /**
     * <p>
     * The percentage of overlap between adjacent chunks of a data source.
     * </p>
     * 
     * @return The percentage of overlap between adjacent chunks of a data source.
     */
    public final Integer overlapPercentage() {
        return overlapPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxTokens());
        hashCode = 31 * hashCode + Objects.hashCode(overlapPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FixedSizeChunkingConfiguration)) {
            return false;
        }
        FixedSizeChunkingConfiguration other = (FixedSizeChunkingConfiguration) obj;
        return Objects.equals(maxTokens(), other.maxTokens()) && Objects.equals(overlapPercentage(), other.overlapPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FixedSizeChunkingConfiguration").add("MaxTokens", maxTokens())
                .add("OverlapPercentage", overlapPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxTokens":
            return Optional.ofNullable(clazz.cast(maxTokens()));
        case "overlapPercentage":
            return Optional.ofNullable(clazz.cast(overlapPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxTokens", MAX_TOKENS_FIELD);
        map.put("overlapPercentage", OVERLAP_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FixedSizeChunkingConfiguration, T> g) {
        return obj -> g.apply((FixedSizeChunkingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FixedSizeChunkingConfiguration> {
        /**
         * <p>
         * The maximum number of tokens to include in a chunk.
         * </p>
         * 
         * @param maxTokens
         *        The maximum number of tokens to include in a chunk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxTokens(Integer maxTokens);

        /**
         * <p>
         * The percentage of overlap between adjacent chunks of a data source.
         * </p>
         * 
         * @param overlapPercentage
         *        The percentage of overlap between adjacent chunks of a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overlapPercentage(Integer overlapPercentage);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxTokens;

        private Integer overlapPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(FixedSizeChunkingConfiguration model) {
            maxTokens(model.maxTokens);
            overlapPercentage(model.overlapPercentage);
        }

        public final Integer getMaxTokens() {
            return maxTokens;
        }

        public final void setMaxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
        }

        @Override
        public final Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public final Integer getOverlapPercentage() {
            return overlapPercentage;
        }

        public final void setOverlapPercentage(Integer overlapPercentage) {
            this.overlapPercentage = overlapPercentage;
        }

        @Override
        public final Builder overlapPercentage(Integer overlapPercentage) {
            this.overlapPercentage = overlapPercentage;
            return this;
        }

        @Override
        public FixedSizeChunkingConfiguration build() {
            return new FixedSizeChunkingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
