/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a query, each of which defines information about example queries to help the query engine
 * generate appropriate SQL queries.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CuratedQuery implements SdkPojo, Serializable, ToCopyableBuilder<CuratedQuery.Builder, CuratedQuery> {
    private static final SdkField<String> NATURAL_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("naturalLanguage").getter(getter(CuratedQuery::naturalLanguage)).setter(setter(Builder::naturalLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("naturalLanguage").build()).build();

    private static final SdkField<String> SQL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sql")
            .getter(getter(CuratedQuery::sql)).setter(setter(Builder::sql))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sql").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NATURAL_LANGUAGE_FIELD,
            SQL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String naturalLanguage;

    private final String sql;

    private CuratedQuery(BuilderImpl builder) {
        this.naturalLanguage = builder.naturalLanguage;
        this.sql = builder.sql;
    }

    /**
     * <p>
     * An example natural language query.
     * </p>
     * 
     * @return An example natural language query.
     */
    public final String naturalLanguage() {
        return naturalLanguage;
    }

    /**
     * <p>
     * The SQL equivalent of the natural language query.
     * </p>
     * 
     * @return The SQL equivalent of the natural language query.
     */
    public final String sql() {
        return sql;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(naturalLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(sql());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CuratedQuery)) {
            return false;
        }
        CuratedQuery other = (CuratedQuery) obj;
        return Objects.equals(naturalLanguage(), other.naturalLanguage()) && Objects.equals(sql(), other.sql());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CuratedQuery").add("NaturalLanguage", naturalLanguage()).add("Sql", sql()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "naturalLanguage":
            return Optional.ofNullable(clazz.cast(naturalLanguage()));
        case "sql":
            return Optional.ofNullable(clazz.cast(sql()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("naturalLanguage", NATURAL_LANGUAGE_FIELD);
        map.put("sql", SQL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CuratedQuery, T> g) {
        return obj -> g.apply((CuratedQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CuratedQuery> {
        /**
         * <p>
         * An example natural language query.
         * </p>
         * 
         * @param naturalLanguage
         *        An example natural language query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder naturalLanguage(String naturalLanguage);

        /**
         * <p>
         * The SQL equivalent of the natural language query.
         * </p>
         * 
         * @param sql
         *        The SQL equivalent of the natural language query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sql(String sql);
    }

    static final class BuilderImpl implements Builder {
        private String naturalLanguage;

        private String sql;

        private BuilderImpl() {
        }

        private BuilderImpl(CuratedQuery model) {
            naturalLanguage(model.naturalLanguage);
            sql(model.sql);
        }

        public final String getNaturalLanguage() {
            return naturalLanguage;
        }

        public final void setNaturalLanguage(String naturalLanguage) {
            this.naturalLanguage = naturalLanguage;
        }

        @Override
        public final Builder naturalLanguage(String naturalLanguage) {
            this.naturalLanguage = naturalLanguage;
            return this;
        }

        public final String getSql() {
            return sql;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        @Override
        public CuratedQuery build() {
            return new CuratedQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
