/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of filtering the data source content. For example, configuring regular expression patterns to
 * include or exclude certain content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrawlFilterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CrawlFilterConfiguration.Builder, CrawlFilterConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CrawlFilterConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<PatternObjectFilterConfiguration> PATTERN_OBJECT_FILTER_FIELD = SdkField
            .<PatternObjectFilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("patternObjectFilter")
            .getter(getter(CrawlFilterConfiguration::patternObjectFilter)).setter(setter(Builder::patternObjectFilter))
            .constructor(PatternObjectFilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternObjectFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            PATTERN_OBJECT_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final PatternObjectFilterConfiguration patternObjectFilter;

    private CrawlFilterConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.patternObjectFilter = builder.patternObjectFilter;
    }

    /**
     * <p>
     * The type of filtering that you want to apply to certain objects or content of the data source. For example, the
     * <code>PATTERN</code> type is regular expression patterns you can apply to filter your content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CrawlFilterConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of filtering that you want to apply to certain objects or content of the data source. For
     *         example, the <code>PATTERN</code> type is regular expression patterns you can apply to filter your
     *         content.
     * @see CrawlFilterConfigurationType
     */
    public final CrawlFilterConfigurationType type() {
        return CrawlFilterConfigurationType.fromValue(type);
    }

    /**
     * <p>
     * The type of filtering that you want to apply to certain objects or content of the data source. For example, the
     * <code>PATTERN</code> type is regular expression patterns you can apply to filter your content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CrawlFilterConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of filtering that you want to apply to certain objects or content of the data source. For
     *         example, the <code>PATTERN</code> type is regular expression patterns you can apply to filter your
     *         content.
     * @see CrawlFilterConfigurationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The configuration of filtering certain objects or content types of the data source.
     * </p>
     * 
     * @return The configuration of filtering certain objects or content types of the data source.
     */
    public final PatternObjectFilterConfiguration patternObjectFilter() {
        return patternObjectFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(patternObjectFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlFilterConfiguration)) {
            return false;
        }
        CrawlFilterConfiguration other = (CrawlFilterConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(patternObjectFilter(), other.patternObjectFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrawlFilterConfiguration").add("Type", typeAsString())
                .add("PatternObjectFilter", patternObjectFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "patternObjectFilter":
            return Optional.ofNullable(clazz.cast(patternObjectFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("patternObjectFilter", PATTERN_OBJECT_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrawlFilterConfiguration, T> g) {
        return obj -> g.apply((CrawlFilterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrawlFilterConfiguration> {
        /**
         * <p>
         * The type of filtering that you want to apply to certain objects or content of the data source. For example,
         * the <code>PATTERN</code> type is regular expression patterns you can apply to filter your content.
         * </p>
         * 
         * @param type
         *        The type of filtering that you want to apply to certain objects or content of the data source. For
         *        example, the <code>PATTERN</code> type is regular expression patterns you can apply to filter your
         *        content.
         * @see CrawlFilterConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrawlFilterConfigurationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of filtering that you want to apply to certain objects or content of the data source. For example,
         * the <code>PATTERN</code> type is regular expression patterns you can apply to filter your content.
         * </p>
         * 
         * @param type
         *        The type of filtering that you want to apply to certain objects or content of the data source. For
         *        example, the <code>PATTERN</code> type is regular expression patterns you can apply to filter your
         *        content.
         * @see CrawlFilterConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrawlFilterConfigurationType
         */
        Builder type(CrawlFilterConfigurationType type);

        /**
         * <p>
         * The configuration of filtering certain objects or content types of the data source.
         * </p>
         * 
         * @param patternObjectFilter
         *        The configuration of filtering certain objects or content types of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternObjectFilter(PatternObjectFilterConfiguration patternObjectFilter);

        /**
         * <p>
         * The configuration of filtering certain objects or content types of the data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link PatternObjectFilterConfiguration.Builder}
         * avoiding the need to create one manually via {@link PatternObjectFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PatternObjectFilterConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #patternObjectFilter(PatternObjectFilterConfiguration)}.
         * 
         * @param patternObjectFilter
         *        a consumer that will call methods on {@link PatternObjectFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patternObjectFilter(PatternObjectFilterConfiguration)
         */
        default Builder patternObjectFilter(Consumer<PatternObjectFilterConfiguration.Builder> patternObjectFilter) {
            return patternObjectFilter(PatternObjectFilterConfiguration.builder().applyMutation(patternObjectFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private PatternObjectFilterConfiguration patternObjectFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlFilterConfiguration model) {
            type(model.type);
            patternObjectFilter(model.patternObjectFilter);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CrawlFilterConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final PatternObjectFilterConfiguration.Builder getPatternObjectFilter() {
            return patternObjectFilter != null ? patternObjectFilter.toBuilder() : null;
        }

        public final void setPatternObjectFilter(PatternObjectFilterConfiguration.BuilderImpl patternObjectFilter) {
            this.patternObjectFilter = patternObjectFilter != null ? patternObjectFilter.build() : null;
        }

        @Override
        public final Builder patternObjectFilter(PatternObjectFilterConfiguration patternObjectFilter) {
            this.patternObjectFilter = patternObjectFilter;
            return this;
        }

        @Override
        public CrawlFilterConfiguration build() {
            return new CrawlFilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
