/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for a foundation model used to parse documents for a data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BedrockFoundationModelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BedrockFoundationModelConfiguration.Builder, BedrockFoundationModelConfiguration> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(BedrockFoundationModelConfiguration::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<ParsingPrompt> PARSING_PROMPT_FIELD = SdkField
            .<ParsingPrompt> builder(MarshallingType.SDK_POJO).memberName("parsingPrompt")
            .getter(getter(BedrockFoundationModelConfiguration::parsingPrompt)).setter(setter(Builder::parsingPrompt))
            .constructor(ParsingPrompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsingPrompt").build()).build();

    private static final SdkField<String> PARSING_MODALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parsingModality").getter(getter(BedrockFoundationModelConfiguration::parsingModalityAsString))
            .setter(setter(Builder::parsingModality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsingModality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD,
            PARSING_PROMPT_FIELD, PARSING_MODALITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelArn;

    private final ParsingPrompt parsingPrompt;

    private final String parsingModality;

    private BedrockFoundationModelConfiguration(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
        this.parsingPrompt = builder.parsingPrompt;
        this.parsingModality = builder.parsingModality;
    }

    /**
     * <p>
     * The ARN of the foundation model to use for parsing.
     * </p>
     * 
     * @return The ARN of the foundation model to use for parsing.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * Instructions for interpreting the contents of a document.
     * </p>
     * 
     * @return Instructions for interpreting the contents of a document.
     */
    public final ParsingPrompt parsingPrompt() {
        return parsingPrompt;
    }

    /**
     * <p>
     * Specifies whether to enable parsing of multimodal data, including both text and/or images.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parsingModality}
     * will return {@link ParsingModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #parsingModalityAsString}.
     * </p>
     * 
     * @return Specifies whether to enable parsing of multimodal data, including both text and/or images.
     * @see ParsingModality
     */
    public final ParsingModality parsingModality() {
        return ParsingModality.fromValue(parsingModality);
    }

    /**
     * <p>
     * Specifies whether to enable parsing of multimodal data, including both text and/or images.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parsingModality}
     * will return {@link ParsingModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #parsingModalityAsString}.
     * </p>
     * 
     * @return Specifies whether to enable parsing of multimodal data, including both text and/or images.
     * @see ParsingModality
     */
    public final String parsingModalityAsString() {
        return parsingModality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(parsingPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(parsingModalityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockFoundationModelConfiguration)) {
            return false;
        }
        BedrockFoundationModelConfiguration other = (BedrockFoundationModelConfiguration) obj;
        return Objects.equals(modelArn(), other.modelArn()) && Objects.equals(parsingPrompt(), other.parsingPrompt())
                && Objects.equals(parsingModalityAsString(), other.parsingModalityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BedrockFoundationModelConfiguration").add("ModelArn", modelArn())
                .add("ParsingPrompt", parsingPrompt()).add("ParsingModality", parsingModalityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "parsingPrompt":
            return Optional.ofNullable(clazz.cast(parsingPrompt()));
        case "parsingModality":
            return Optional.ofNullable(clazz.cast(parsingModalityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("parsingPrompt", PARSING_PROMPT_FIELD);
        map.put("parsingModality", PARSING_MODALITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockFoundationModelConfiguration, T> g) {
        return obj -> g.apply((BedrockFoundationModelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BedrockFoundationModelConfiguration> {
        /**
         * <p>
         * The ARN of the foundation model to use for parsing.
         * </p>
         * 
         * @param modelArn
         *        The ARN of the foundation model to use for parsing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * Instructions for interpreting the contents of a document.
         * </p>
         * 
         * @param parsingPrompt
         *        Instructions for interpreting the contents of a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsingPrompt(ParsingPrompt parsingPrompt);

        /**
         * <p>
         * Instructions for interpreting the contents of a document.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParsingPrompt.Builder} avoiding the need
         * to create one manually via {@link ParsingPrompt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParsingPrompt.Builder#build()} is called immediately and its
         * result is passed to {@link #parsingPrompt(ParsingPrompt)}.
         * 
         * @param parsingPrompt
         *        a consumer that will call methods on {@link ParsingPrompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parsingPrompt(ParsingPrompt)
         */
        default Builder parsingPrompt(Consumer<ParsingPrompt.Builder> parsingPrompt) {
            return parsingPrompt(ParsingPrompt.builder().applyMutation(parsingPrompt).build());
        }

        /**
         * <p>
         * Specifies whether to enable parsing of multimodal data, including both text and/or images.
         * </p>
         * 
         * @param parsingModality
         *        Specifies whether to enable parsing of multimodal data, including both text and/or images.
         * @see ParsingModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParsingModality
         */
        Builder parsingModality(String parsingModality);

        /**
         * <p>
         * Specifies whether to enable parsing of multimodal data, including both text and/or images.
         * </p>
         * 
         * @param parsingModality
         *        Specifies whether to enable parsing of multimodal data, including both text and/or images.
         * @see ParsingModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParsingModality
         */
        Builder parsingModality(ParsingModality parsingModality);
    }

    static final class BuilderImpl implements Builder {
        private String modelArn;

        private ParsingPrompt parsingPrompt;

        private String parsingModality;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockFoundationModelConfiguration model) {
            modelArn(model.modelArn);
            parsingPrompt(model.parsingPrompt);
            parsingModality(model.parsingModality);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final ParsingPrompt.Builder getParsingPrompt() {
            return parsingPrompt != null ? parsingPrompt.toBuilder() : null;
        }

        public final void setParsingPrompt(ParsingPrompt.BuilderImpl parsingPrompt) {
            this.parsingPrompt = parsingPrompt != null ? parsingPrompt.build() : null;
        }

        @Override
        public final Builder parsingPrompt(ParsingPrompt parsingPrompt) {
            this.parsingPrompt = parsingPrompt;
            return this;
        }

        public final String getParsingModality() {
            return parsingModality;
        }

        public final void setParsingModality(String parsingModality) {
            this.parsingModality = parsingModality;
        }

        @Override
        public final Builder parsingModality(String parsingModality) {
            this.parsingModality = parsingModality;
            return this;
        }

        @Override
        public final Builder parsingModality(ParsingModality parsingModality) {
            this.parsingModality(parsingModality == null ? null : parsingModality.toString());
            return this;
        }

        @Override
        public BedrockFoundationModelConfiguration build() {
            return new BedrockFoundationModelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
