/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.StepType;
import software.amazon.awssdk.services.bedrockagent.model.TransformationFunction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Transformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Transformation> {
    private static final SdkField<TransformationFunction> TRANSFORMATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("transformationFunction").getter(Transformation.getter(Transformation::transformationFunction)).setter(Transformation.setter(Builder::transformationFunction)).constructor(TransformationFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformationFunction").build()}).build();
    private static final SdkField<String> STEP_TO_APPLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepToApply").getter(Transformation.getter(Transformation::stepToApplyAsString)).setter(Transformation.setter(Builder::stepToApply)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepToApply").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMATION_FUNCTION_FIELD, STEP_TO_APPLY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Transformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TransformationFunction transformationFunction;
    private final String stepToApply;

    private Transformation(BuilderImpl builder) {
        this.transformationFunction = builder.transformationFunction;
        this.stepToApply = builder.stepToApply;
    }

    public final TransformationFunction transformationFunction() {
        return this.transformationFunction;
    }

    public final StepType stepToApply() {
        return StepType.fromValue(this.stepToApply);
    }

    public final String stepToApplyAsString() {
        return this.stepToApply;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transformationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepToApplyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transformation)) {
            return false;
        }
        Transformation other = (Transformation)obj;
        return Objects.equals(this.transformationFunction(), other.transformationFunction()) && Objects.equals(this.stepToApplyAsString(), other.stepToApplyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Transformation").add("TransformationFunction", (Object)this.transformationFunction()).add("StepToApply", (Object)this.stepToApplyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transformationFunction": {
                return Optional.ofNullable(clazz.cast(this.transformationFunction()));
            }
            case "stepToApply": {
                return Optional.ofNullable(clazz.cast(this.stepToApplyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("transformationFunction", TRANSFORMATION_FUNCTION_FIELD);
        map.put("stepToApply", STEP_TO_APPLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Transformation, T> g) {
        return obj -> g.apply((Transformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TransformationFunction transformationFunction;
        private String stepToApply;

        private BuilderImpl() {
        }

        private BuilderImpl(Transformation model) {
            this.transformationFunction(model.transformationFunction);
            this.stepToApply(model.stepToApply);
        }

        public final TransformationFunction.Builder getTransformationFunction() {
            return this.transformationFunction != null ? this.transformationFunction.toBuilder() : null;
        }

        public final void setTransformationFunction(TransformationFunction.BuilderImpl transformationFunction) {
            this.transformationFunction = transformationFunction != null ? transformationFunction.build() : null;
        }

        @Override
        public final Builder transformationFunction(TransformationFunction transformationFunction) {
            this.transformationFunction = transformationFunction;
            return this;
        }

        public final String getStepToApply() {
            return this.stepToApply;
        }

        public final void setStepToApply(String stepToApply) {
            this.stepToApply = stepToApply;
        }

        @Override
        public final Builder stepToApply(String stepToApply) {
            this.stepToApply = stepToApply;
            return this;
        }

        @Override
        public final Builder stepToApply(StepType stepToApply) {
            this.stepToApply(stepToApply == null ? null : stepToApply.toString());
            return this;
        }

        public Transformation build() {
            return new Transformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Transformation> {
        public Builder transformationFunction(TransformationFunction var1);

        default public Builder transformationFunction(Consumer<TransformationFunction.Builder> transformationFunction) {
            return this.transformationFunction((TransformationFunction)((TransformationFunction.Builder)TransformationFunction.builder().applyMutation(transformationFunction)).build());
        }

        public Builder stepToApply(String var1);

        public Builder stepToApply(StepType var1);
    }
}

