/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.SharePointAuthType;
import software.amazon.awssdk.services.bedrockagent.model.SharePointHostType;
import software.amazon.awssdk.services.bedrockagent.model.SharePointSiteUrlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SharePointSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SharePointSourceConfiguration> {
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tenantId").getter(SharePointSourceConfiguration.getter(SharePointSourceConfiguration::tenantId)).setter(SharePointSourceConfiguration.setter(Builder::tenantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantId").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(SharePointSourceConfiguration.getter(SharePointSourceConfiguration::domain)).setter(SharePointSourceConfiguration.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<List<String>> SITE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("siteUrls").getter(SharePointSourceConfiguration.getter(SharePointSourceConfiguration::siteUrls)).setter(SharePointSourceConfiguration.setter(Builder::siteUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("siteUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HOST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostType").getter(SharePointSourceConfiguration.getter(SharePointSourceConfiguration::hostTypeAsString)).setter(SharePointSourceConfiguration.setter(Builder::hostType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostType").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(SharePointSourceConfiguration.getter(SharePointSourceConfiguration::authTypeAsString)).setter(SharePointSourceConfiguration.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialsSecretArn").getter(SharePointSourceConfiguration.getter(SharePointSourceConfiguration::credentialsSecretArn)).setter(SharePointSourceConfiguration.setter(Builder::credentialsSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_ID_FIELD, DOMAIN_FIELD, SITE_URLS_FIELD, HOST_TYPE_FIELD, AUTH_TYPE_FIELD, CREDENTIALS_SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SharePointSourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tenantId;
    private final String domain;
    private final List<String> siteUrls;
    private final String hostType;
    private final String authType;
    private final String credentialsSecretArn;

    private SharePointSourceConfiguration(BuilderImpl builder) {
        this.tenantId = builder.tenantId;
        this.domain = builder.domain;
        this.siteUrls = builder.siteUrls;
        this.hostType = builder.hostType;
        this.authType = builder.authType;
        this.credentialsSecretArn = builder.credentialsSecretArn;
    }

    public final String tenantId() {
        return this.tenantId;
    }

    public final String domain() {
        return this.domain;
    }

    public final boolean hasSiteUrls() {
        return this.siteUrls != null && !(this.siteUrls instanceof SdkAutoConstructList);
    }

    public final List<String> siteUrls() {
        return this.siteUrls;
    }

    public final SharePointHostType hostType() {
        return SharePointHostType.fromValue(this.hostType);
    }

    public final String hostTypeAsString() {
        return this.hostType;
    }

    public final SharePointAuthType authType() {
        return SharePointAuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final String credentialsSecretArn() {
        return this.credentialsSecretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSiteUrls() ? this.siteUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hostTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsSecretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharePointSourceConfiguration)) {
            return false;
        }
        SharePointSourceConfiguration other = (SharePointSourceConfiguration)obj;
        return Objects.equals(this.tenantId(), other.tenantId()) && Objects.equals(this.domain(), other.domain()) && this.hasSiteUrls() == other.hasSiteUrls() && Objects.equals(this.siteUrls(), other.siteUrls()) && Objects.equals(this.hostTypeAsString(), other.hostTypeAsString()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.credentialsSecretArn(), other.credentialsSecretArn());
    }

    public final String toString() {
        return ToString.builder((String)"SharePointSourceConfiguration").add("TenantId", (Object)this.tenantId()).add("Domain", (Object)this.domain()).add("SiteUrls", this.hasSiteUrls() ? this.siteUrls() : null).add("HostType", (Object)this.hostTypeAsString()).add("AuthType", (Object)this.authTypeAsString()).add("CredentialsSecretArn", (Object)this.credentialsSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tenantId": {
                return Optional.ofNullable(clazz.cast(this.tenantId()));
            }
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "siteUrls": {
                return Optional.ofNullable(clazz.cast(this.siteUrls()));
            }
            case "hostType": {
                return Optional.ofNullable(clazz.cast(this.hostTypeAsString()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "credentialsSecretArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsSecretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", TENANT_ID_FIELD);
        map.put("domain", DOMAIN_FIELD);
        map.put("siteUrls", SITE_URLS_FIELD);
        map.put("hostType", HOST_TYPE_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("credentialsSecretArn", CREDENTIALS_SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SharePointSourceConfiguration, T> g) {
        return obj -> g.apply((SharePointSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tenantId;
        private String domain;
        private List<String> siteUrls = DefaultSdkAutoConstructList.getInstance();
        private String hostType;
        private String authType;
        private String credentialsSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SharePointSourceConfiguration model) {
            this.tenantId(model.tenantId);
            this.domain(model.domain);
            this.siteUrls(model.siteUrls);
            this.hostType(model.hostType);
            this.authType(model.authType);
            this.credentialsSecretArn(model.credentialsSecretArn);
        }

        public final String getTenantId() {
            return this.tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Collection<String> getSiteUrls() {
            if (this.siteUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.siteUrls;
        }

        public final void setSiteUrls(Collection<String> siteUrls) {
            this.siteUrls = SharePointSiteUrlsCopier.copy(siteUrls);
        }

        @Override
        public final Builder siteUrls(Collection<String> siteUrls) {
            this.siteUrls = SharePointSiteUrlsCopier.copy(siteUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder siteUrls(String ... siteUrls) {
            this.siteUrls(Arrays.asList(siteUrls));
            return this;
        }

        public final String getHostType() {
            return this.hostType;
        }

        public final void setHostType(String hostType) {
            this.hostType = hostType;
        }

        @Override
        public final Builder hostType(String hostType) {
            this.hostType = hostType;
            return this;
        }

        @Override
        public final Builder hostType(SharePointHostType hostType) {
            this.hostType(hostType == null ? null : hostType.toString());
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(SharePointAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getCredentialsSecretArn() {
            return this.credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public SharePointSourceConfiguration build() {
            return new SharePointSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SharePointSourceConfiguration> {
        public Builder tenantId(String var1);

        public Builder domain(String var1);

        public Builder siteUrls(Collection<String> var1);

        public Builder siteUrls(String ... var1);

        public Builder hostType(String var1);

        public Builder hostType(SharePointHostType var1);

        public Builder authType(String var1);

        public Builder authType(SharePointAuthType var1);

        public Builder credentialsSecretArn(String var1);
    }
}

