/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.SupportedLanguages;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InlineCodeFlowNodeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InlineCodeFlowNodeConfiguration> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(InlineCodeFlowNodeConfiguration.getter(InlineCodeFlowNodeConfiguration::code)).setter(InlineCodeFlowNodeConfiguration.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(InlineCodeFlowNodeConfiguration.getter(InlineCodeFlowNodeConfiguration::languageAsString)).setter(InlineCodeFlowNodeConfiguration.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, LANGUAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InlineCodeFlowNodeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String code;
    private final String language;

    private InlineCodeFlowNodeConfiguration(BuilderImpl builder) {
        this.code = builder.code;
        this.language = builder.language;
    }

    public final String code() {
        return this.code;
    }

    public final SupportedLanguages language() {
        return SupportedLanguages.fromValue(this.language);
    }

    public final String languageAsString() {
        return this.language;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineCodeFlowNodeConfiguration)) {
            return false;
        }
        InlineCodeFlowNodeConfiguration other = (InlineCodeFlowNodeConfiguration)obj;
        return Objects.equals(this.code(), other.code()) && Objects.equals(this.languageAsString(), other.languageAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InlineCodeFlowNodeConfiguration").add("Code", (Object)(this.code() == null ? null : "*** Sensitive Data Redacted ***")).add("Language", (Object)this.languageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("code", CODE_FIELD);
        map.put("language", LANGUAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InlineCodeFlowNodeConfiguration, T> g) {
        return obj -> g.apply((InlineCodeFlowNodeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(InlineCodeFlowNodeConfiguration model) {
            this.code(model.code);
            this.language(model.language);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(SupportedLanguages language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public InlineCodeFlowNodeConfiguration build() {
            return new InlineCodeFlowNodeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InlineCodeFlowNodeConfiguration> {
        public Builder code(String var1);

        public Builder language(String var1);

        public Builder language(SupportedLanguages var1);
    }
}

