/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.PromptGenAiResource;
import software.amazon.awssdk.services.bedrockagent.model.PromptInferenceConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.PromptMetadataEntry;
import software.amazon.awssdk.services.bedrockagent.model.PromptMetadataListCopier;
import software.amazon.awssdk.services.bedrockagent.model.PromptTemplateConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.PromptTemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PromptVariant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PromptVariant> {
    private static final SdkField<Document> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("additionalModelRequestFields").getter(PromptVariant.getter(PromptVariant::additionalModelRequestFields)).setter(PromptVariant.setter(Builder::additionalModelRequestFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields").build()}).build();
    private static final SdkField<PromptGenAiResource> GEN_AI_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("genAiResource").getter(PromptVariant.getter(PromptVariant::genAiResource)).setter(PromptVariant.setter(Builder::genAiResource)).constructor(PromptGenAiResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("genAiResource").build()}).build();
    private static final SdkField<PromptInferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfiguration").getter(PromptVariant.getter(PromptVariant::inferenceConfiguration)).setter(PromptVariant.setter(Builder::inferenceConfiguration)).constructor(PromptInferenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build()}).build();
    private static final SdkField<List<PromptMetadataEntry>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metadata").getter(PromptVariant.getter(PromptVariant::metadata)).setter(PromptVariant.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptMetadataEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(PromptVariant.getter(PromptVariant::modelId)).setter(PromptVariant.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PromptVariant.getter(PromptVariant::name)).setter(PromptVariant.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<PromptTemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("templateConfiguration").getter(PromptVariant.getter(PromptVariant::templateConfiguration)).setter(PromptVariant.setter(Builder::templateConfiguration)).constructor(PromptTemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateConfiguration").build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateType").getter(PromptVariant.getter(PromptVariant::templateTypeAsString)).setter(PromptVariant.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD, GEN_AI_RESOURCE_FIELD, INFERENCE_CONFIGURATION_FIELD, METADATA_FIELD, MODEL_ID_FIELD, NAME_FIELD, TEMPLATE_CONFIGURATION_FIELD, TEMPLATE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PromptVariant.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Document additionalModelRequestFields;
    private final PromptGenAiResource genAiResource;
    private final PromptInferenceConfiguration inferenceConfiguration;
    private final List<PromptMetadataEntry> metadata;
    private final String modelId;
    private final String name;
    private final PromptTemplateConfiguration templateConfiguration;
    private final String templateType;

    private PromptVariant(BuilderImpl builder) {
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
        this.genAiResource = builder.genAiResource;
        this.inferenceConfiguration = builder.inferenceConfiguration;
        this.metadata = builder.metadata;
        this.modelId = builder.modelId;
        this.name = builder.name;
        this.templateConfiguration = builder.templateConfiguration;
        this.templateType = builder.templateType;
    }

    public final Document additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public final PromptGenAiResource genAiResource() {
        return this.genAiResource;
    }

    public final PromptInferenceConfiguration inferenceConfiguration() {
        return this.inferenceConfiguration;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructList);
    }

    public final List<PromptMetadataEntry> metadata() {
        return this.metadata;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String name() {
        return this.name;
    }

    public final PromptTemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    public final PromptTemplateType templateType() {
        return PromptTemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalModelRequestFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.genAiResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptVariant)) {
            return false;
        }
        PromptVariant other = (PromptVariant)obj;
        return Objects.equals(this.additionalModelRequestFields(), other.additionalModelRequestFields()) && Objects.equals(this.genAiResource(), other.genAiResource()) && Objects.equals(this.inferenceConfiguration(), other.inferenceConfiguration()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PromptVariant").add("AdditionalModelRequestFields", (Object)this.additionalModelRequestFields()).add("GenAiResource", (Object)(this.genAiResource() == null ? null : "*** Sensitive Data Redacted ***")).add("InferenceConfiguration", (Object)this.inferenceConfiguration()).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).add("ModelId", (Object)this.modelId()).add("Name", (Object)this.name()).add("TemplateConfiguration", (Object)this.templateConfiguration()).add("TemplateType", (Object)this.templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalModelRequestFields": {
                return Optional.ofNullable(clazz.cast(this.additionalModelRequestFields()));
            }
            case "genAiResource": {
                return Optional.ofNullable(clazz.cast(this.genAiResource()));
            }
            case "inferenceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfiguration()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "templateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
            case "templateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        map.put("genAiResource", GEN_AI_RESOURCE_FIELD);
        map.put("inferenceConfiguration", INFERENCE_CONFIGURATION_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("templateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
        map.put("templateType", TEMPLATE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PromptVariant, T> g) {
        return obj -> g.apply((PromptVariant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Document additionalModelRequestFields;
        private PromptGenAiResource genAiResource;
        private PromptInferenceConfiguration inferenceConfiguration;
        private List<PromptMetadataEntry> metadata = DefaultSdkAutoConstructList.getInstance();
        private String modelId;
        private String name;
        private PromptTemplateConfiguration templateConfiguration;
        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptVariant model) {
            this.additionalModelRequestFields(model.additionalModelRequestFields);
            this.genAiResource(model.genAiResource);
            this.inferenceConfiguration(model.inferenceConfiguration);
            this.metadata(model.metadata);
            this.modelId(model.modelId);
            this.name(model.name);
            this.templateConfiguration(model.templateConfiguration);
            this.templateType(model.templateType);
        }

        public final Document getAdditionalModelRequestFields() {
            return this.additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
        }

        @Override
        public final Builder additionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
            return this;
        }

        public final PromptGenAiResource.Builder getGenAiResource() {
            return this.genAiResource != null ? this.genAiResource.toBuilder() : null;
        }

        public final void setGenAiResource(PromptGenAiResource.BuilderImpl genAiResource) {
            this.genAiResource = genAiResource != null ? genAiResource.build() : null;
        }

        @Override
        public final Builder genAiResource(PromptGenAiResource genAiResource) {
            this.genAiResource = genAiResource;
            return this;
        }

        public final PromptInferenceConfiguration.Builder getInferenceConfiguration() {
            return this.inferenceConfiguration != null ? this.inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(PromptInferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(PromptInferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        public final List<PromptMetadataEntry.Builder> getMetadata() {
            List<PromptMetadataEntry.Builder> result = PromptMetadataListCopier.copyToBuilder(this.metadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadata(Collection<PromptMetadataEntry.BuilderImpl> metadata) {
            this.metadata = PromptMetadataListCopier.copyFromBuilder(metadata);
        }

        @Override
        public final Builder metadata(Collection<PromptMetadataEntry> metadata) {
            this.metadata = PromptMetadataListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(PromptMetadataEntry ... metadata) {
            this.metadata(Arrays.asList(metadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(Consumer<PromptMetadataEntry.Builder> ... metadata) {
            this.metadata(Stream.of(metadata).map(c -> (PromptMetadataEntry)((PromptMetadataEntry.Builder)PromptMetadataEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PromptTemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(PromptTemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(PromptTemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(PromptTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public PromptVariant build() {
            return new PromptVariant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PromptVariant> {
        public Builder additionalModelRequestFields(Document var1);

        public Builder genAiResource(PromptGenAiResource var1);

        default public Builder genAiResource(Consumer<PromptGenAiResource.Builder> genAiResource) {
            return this.genAiResource((PromptGenAiResource)((PromptGenAiResource.Builder)PromptGenAiResource.builder().applyMutation(genAiResource)).build());
        }

        public Builder inferenceConfiguration(PromptInferenceConfiguration var1);

        default public Builder inferenceConfiguration(Consumer<PromptInferenceConfiguration.Builder> inferenceConfiguration) {
            return this.inferenceConfiguration((PromptInferenceConfiguration)((PromptInferenceConfiguration.Builder)PromptInferenceConfiguration.builder().applyMutation(inferenceConfiguration)).build());
        }

        public Builder metadata(Collection<PromptMetadataEntry> var1);

        public Builder metadata(PromptMetadataEntry ... var1);

        public Builder metadata(Consumer<PromptMetadataEntry.Builder> ... var1);

        public Builder modelId(String var1);

        public Builder name(String var1);

        public Builder templateConfiguration(PromptTemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<PromptTemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((PromptTemplateConfiguration)((PromptTemplateConfiguration.Builder)PromptTemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder templateType(String var1);

        public Builder templateType(PromptTemplateType var1);
    }
}

