/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.SharePointCrawlerConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.SharePointSourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SharePointDataSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SharePointDataSourceConfiguration> {
    private static final SdkField<SharePointCrawlerConfiguration> CRAWLER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("crawlerConfiguration").getter(SharePointDataSourceConfiguration.getter(SharePointDataSourceConfiguration::crawlerConfiguration)).setter(SharePointDataSourceConfiguration.setter(Builder::crawlerConfiguration)).constructor(SharePointCrawlerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crawlerConfiguration").build()}).build();
    private static final SdkField<SharePointSourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceConfiguration").getter(SharePointDataSourceConfiguration.getter(SharePointDataSourceConfiguration::sourceConfiguration)).setter(SharePointDataSourceConfiguration.setter(Builder::sourceConfiguration)).constructor(SharePointSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_CONFIGURATION_FIELD, SOURCE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SharePointDataSourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SharePointCrawlerConfiguration crawlerConfiguration;
    private final SharePointSourceConfiguration sourceConfiguration;

    private SharePointDataSourceConfiguration(BuilderImpl builder) {
        this.crawlerConfiguration = builder.crawlerConfiguration;
        this.sourceConfiguration = builder.sourceConfiguration;
    }

    public final SharePointCrawlerConfiguration crawlerConfiguration() {
        return this.crawlerConfiguration;
    }

    public final SharePointSourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharePointDataSourceConfiguration)) {
            return false;
        }
        SharePointDataSourceConfiguration other = (SharePointDataSourceConfiguration)obj;
        return Objects.equals(this.crawlerConfiguration(), other.crawlerConfiguration()) && Objects.equals(this.sourceConfiguration(), other.sourceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SharePointDataSourceConfiguration").add("CrawlerConfiguration", (Object)this.crawlerConfiguration()).add("SourceConfiguration", (Object)this.sourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crawlerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.crawlerConfiguration()));
            }
            case "sourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("crawlerConfiguration", CRAWLER_CONFIGURATION_FIELD);
        map.put("sourceConfiguration", SOURCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SharePointDataSourceConfiguration, T> g) {
        return obj -> g.apply((SharePointDataSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SharePointCrawlerConfiguration crawlerConfiguration;
        private SharePointSourceConfiguration sourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SharePointDataSourceConfiguration model) {
            this.crawlerConfiguration(model.crawlerConfiguration);
            this.sourceConfiguration(model.sourceConfiguration);
        }

        public final SharePointCrawlerConfiguration.Builder getCrawlerConfiguration() {
            return this.crawlerConfiguration != null ? this.crawlerConfiguration.toBuilder() : null;
        }

        public final void setCrawlerConfiguration(SharePointCrawlerConfiguration.BuilderImpl crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration != null ? crawlerConfiguration.build() : null;
        }

        @Override
        public final Builder crawlerConfiguration(SharePointCrawlerConfiguration crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration;
            return this;
        }

        public final SharePointSourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SharePointSourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SharePointSourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public SharePointDataSourceConfiguration build() {
            return new SharePointDataSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SharePointDataSourceConfiguration> {
        public Builder crawlerConfiguration(SharePointCrawlerConfiguration var1);

        default public Builder crawlerConfiguration(Consumer<SharePointCrawlerConfiguration.Builder> crawlerConfiguration) {
            return this.crawlerConfiguration((SharePointCrawlerConfiguration)((SharePointCrawlerConfiguration.Builder)SharePointCrawlerConfiguration.builder().applyMutation(crawlerConfiguration)).build());
        }

        public Builder sourceConfiguration(SharePointSourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<SharePointSourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((SharePointSourceConfiguration)((SharePointSourceConfiguration.Builder)SharePointSourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }
    }
}

