/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IncompatibleLoopNodeType {
    INPUT("Input"),
    CONDITION("Condition"),
    ITERATOR("Iterator"),
    COLLECTOR("Collector"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IncompatibleLoopNodeType> VALUE_MAP;
    private final String value;

    private IncompatibleLoopNodeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IncompatibleLoopNodeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IncompatibleLoopNodeType> knownValues() {
        EnumSet<IncompatibleLoopNodeType> knownValues = EnumSet.allOf(IncompatibleLoopNodeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IncompatibleLoopNodeType.class, IncompatibleLoopNodeType::toString);
    }
}

