/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a system prompt to provide context to the model or to describe how it should behave. For more information,
 * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a prompt
 * using Prompt management</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemContentBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<SystemContentBlock.Builder, SystemContentBlock> {
    private static final SdkField<CachePointBlock> CACHE_POINT_FIELD = SdkField
            .<CachePointBlock> builder(MarshallingType.SDK_POJO).memberName("cachePoint")
            .getter(getter(SystemContentBlock::cachePoint)).setter(setter(Builder::cachePoint))
            .constructor(CachePointBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachePoint").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(SystemContentBlock::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CACHE_POINT_FIELD, TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CachePointBlock cachePoint;

    private final String text;

    private final Type type;

    private SystemContentBlock(BuilderImpl builder) {
        this.cachePoint = builder.cachePoint;
        this.text = builder.text;
        this.type = builder.type;
    }

    /**
     * <p>
     * Creates a cache checkpoint within a tool designation
     * </p>
     * 
     * @return Creates a cache checkpoint within a tool designation
     */
    public final CachePointBlock cachePoint() {
        return cachePoint;
    }

    /**
     * <p>
     * The text in the system prompt.
     * </p>
     * 
     * @return The text in the system prompt.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cachePoint());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemContentBlock)) {
            return false;
        }
        SystemContentBlock other = (SystemContentBlock) obj;
        return Objects.equals(cachePoint(), other.cachePoint()) && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SystemContentBlock").add("CachePoint", cachePoint()).add("Text", text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cachePoint":
            return Optional.ofNullable(clazz.cast(cachePoint()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cachePoint()} initialized to the given value.
     *
     * <p>
     * Creates a cache checkpoint within a tool designation
     * </p>
     * 
     * @param cachePoint
     *        Creates a cache checkpoint within a tool designation
     */
    public static SystemContentBlock fromCachePoint(CachePointBlock cachePoint) {
        return builder().cachePoint(cachePoint).build();
    }

    /**
     * Create an instance of this class with {@link #cachePoint()} initialized to the given value.
     *
     * <p>
     * Creates a cache checkpoint within a tool designation
     * </p>
     * 
     * @param cachePoint
     *        Creates a cache checkpoint within a tool designation
     */
    public static SystemContentBlock fromCachePoint(Consumer<CachePointBlock.Builder> cachePoint) {
        CachePointBlock.Builder builder = CachePointBlock.builder();
        cachePoint.accept(builder);
        return fromCachePoint(builder.build());
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * The text in the system prompt.
     * </p>
     * 
     * @param text
     *        The text in the system prompt.
     */
    public static SystemContentBlock fromText(String text) {
        return builder().text(text).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cachePoint", CACHE_POINT_FIELD);
        map.put("text", TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SystemContentBlock, T> g) {
        return obj -> g.apply((SystemContentBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemContentBlock> {
        /**
         * <p>
         * Creates a cache checkpoint within a tool designation
         * </p>
         * 
         * @param cachePoint
         *        Creates a cache checkpoint within a tool designation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePoint(CachePointBlock cachePoint);

        /**
         * <p>
         * Creates a cache checkpoint within a tool designation
         * </p>
         * This is a convenience method that creates an instance of the {@link CachePointBlock.Builder} avoiding the
         * need to create one manually via {@link CachePointBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CachePointBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #cachePoint(CachePointBlock)}.
         * 
         * @param cachePoint
         *        a consumer that will call methods on {@link CachePointBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachePoint(CachePointBlock)
         */
        default Builder cachePoint(Consumer<CachePointBlock.Builder> cachePoint) {
            return cachePoint(CachePointBlock.builder().applyMutation(cachePoint).build());
        }

        /**
         * <p>
         * The text in the system prompt.
         * </p>
         * 
         * @param text
         *        The text in the system prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private CachePointBlock cachePoint;

        private String text;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SystemContentBlock model) {
            cachePoint(model.cachePoint);
            text(model.text);
        }

        public final CachePointBlock.Builder getCachePoint() {
            return cachePoint != null ? cachePoint.toBuilder() : null;
        }

        public final void setCachePoint(CachePointBlock.BuilderImpl cachePoint) {
            Object oldValue = this.cachePoint;
            this.cachePoint = cachePoint != null ? cachePoint.build() : null;
            handleUnionValueChange(Type.CACHE_POINT, oldValue, this.cachePoint);
        }

        @Override
        public final Builder cachePoint(CachePointBlock cachePoint) {
            Object oldValue = this.cachePoint;
            this.cachePoint = cachePoint;
            handleUnionValueChange(Type.CACHE_POINT, oldValue, this.cachePoint);
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        @Override
        public SystemContentBlock build() {
            return new SystemContentBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SystemContentBlock#type()
     */
    public enum Type {
        CACHE_POINT,

        TEXT,

        UNKNOWN_TO_SDK_VERSION
    }
}
