/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a table for the query engine to consider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryGenerationTable implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryGenerationTable.Builder, QueryGenerationTable> {
    private static final SdkField<List<QueryGenerationColumn>> COLUMNS_FIELD = SdkField
            .<List<QueryGenerationColumn>> builder(MarshallingType.LIST)
            .memberName("columns")
            .getter(getter(QueryGenerationTable::columns))
            .setter(setter(Builder::columns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryGenerationColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryGenerationColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(QueryGenerationTable::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> INCLUSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inclusion").getter(getter(QueryGenerationTable::inclusionAsString)).setter(setter(Builder::inclusion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(QueryGenerationTable::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMNS_FIELD,
            DESCRIPTION_FIELD, INCLUSION_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<QueryGenerationColumn> columns;

    private final String description;

    private final String inclusion;

    private final String name;

    private QueryGenerationTable(BuilderImpl builder) {
        this.columns = builder.columns;
        this.description = builder.description;
        this.inclusion = builder.inclusion;
        this.name = builder.name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Columns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumns() {
        return columns != null && !(columns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, each of which defines information about a column in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumns} method.
     * </p>
     * 
     * @return An array of objects, each of which defines information about a column in the table.
     */
    public final List<QueryGenerationColumn> columns() {
        return columns;
    }

    /**
     * <p>
     * A description of the table that helps the query engine understand the contents of the table.
     * </p>
     * 
     * @return A description of the table that helps the query engine understand the contents of the table.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether to include or exclude the table during query generation. If you specify <code>EXCLUDE</code>,
     * the table will be ignored. If you specify <code>INCLUDE</code>, all other tables will be ignored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inclusion} will
     * return {@link IncludeExclude#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inclusionAsString}.
     * </p>
     * 
     * @return Specifies whether to include or exclude the table during query generation. If you specify
     *         <code>EXCLUDE</code>, the table will be ignored. If you specify <code>INCLUDE</code>, all other tables
     *         will be ignored.
     * @see IncludeExclude
     */
    public final IncludeExclude inclusion() {
        return IncludeExclude.fromValue(inclusion);
    }

    /**
     * <p>
     * Specifies whether to include or exclude the table during query generation. If you specify <code>EXCLUDE</code>,
     * the table will be ignored. If you specify <code>INCLUDE</code>, all other tables will be ignored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inclusion} will
     * return {@link IncludeExclude#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inclusionAsString}.
     * </p>
     * 
     * @return Specifies whether to include or exclude the table during query generation. If you specify
     *         <code>EXCLUDE</code>, the table will be ignored. If you specify <code>INCLUDE</code>, all other tables
     *         will be ignored.
     * @see IncludeExclude
     */
    public final String inclusionAsString() {
        return inclusion;
    }

    /**
     * <p>
     * The name of the table for which the other fields in this object apply.
     * </p>
     * 
     * @return The name of the table for which the other fields in this object apply.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColumns() ? columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(inclusionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryGenerationTable)) {
            return false;
        }
        QueryGenerationTable other = (QueryGenerationTable) obj;
        return hasColumns() == other.hasColumns() && Objects.equals(columns(), other.columns())
                && Objects.equals(description(), other.description())
                && Objects.equals(inclusionAsString(), other.inclusionAsString()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryGenerationTable").add("Columns", hasColumns() ? columns() : null)
                .add("Description", description()).add("Inclusion", inclusionAsString()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columns":
            return Optional.ofNullable(clazz.cast(columns()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "inclusion":
            return Optional.ofNullable(clazz.cast(inclusionAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("columns", COLUMNS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inclusion", INCLUSION_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryGenerationTable, T> g) {
        return obj -> g.apply((QueryGenerationTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryGenerationTable> {
        /**
         * <p>
         * An array of objects, each of which defines information about a column in the table.
         * </p>
         * 
         * @param columns
         *        An array of objects, each of which defines information about a column in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Collection<QueryGenerationColumn> columns);

        /**
         * <p>
         * An array of objects, each of which defines information about a column in the table.
         * </p>
         * 
         * @param columns
         *        An array of objects, each of which defines information about a column in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(QueryGenerationColumn... columns);

        /**
         * <p>
         * An array of objects, each of which defines information about a column in the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.QueryGenerationColumn.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.QueryGenerationColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.QueryGenerationColumn.Builder#build()} is called
         * immediately and its result is passed to {@link #columns(List<QueryGenerationColumn>)}.
         * 
         * @param columns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.QueryGenerationColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columns(java.util.Collection<QueryGenerationColumn>)
         */
        Builder columns(Consumer<QueryGenerationColumn.Builder>... columns);

        /**
         * <p>
         * A description of the table that helps the query engine understand the contents of the table.
         * </p>
         * 
         * @param description
         *        A description of the table that helps the query engine understand the contents of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether to include or exclude the table during query generation. If you specify
         * <code>EXCLUDE</code>, the table will be ignored. If you specify <code>INCLUDE</code>, all other tables will
         * be ignored.
         * </p>
         * 
         * @param inclusion
         *        Specifies whether to include or exclude the table during query generation. If you specify
         *        <code>EXCLUDE</code>, the table will be ignored. If you specify <code>INCLUDE</code>, all other tables
         *        will be ignored.
         * @see IncludeExclude
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeExclude
         */
        Builder inclusion(String inclusion);

        /**
         * <p>
         * Specifies whether to include or exclude the table during query generation. If you specify
         * <code>EXCLUDE</code>, the table will be ignored. If you specify <code>INCLUDE</code>, all other tables will
         * be ignored.
         * </p>
         * 
         * @param inclusion
         *        Specifies whether to include or exclude the table during query generation. If you specify
         *        <code>EXCLUDE</code>, the table will be ignored. If you specify <code>INCLUDE</code>, all other tables
         *        will be ignored.
         * @see IncludeExclude
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeExclude
         */
        Builder inclusion(IncludeExclude inclusion);

        /**
         * <p>
         * The name of the table for which the other fields in this object apply.
         * </p>
         * 
         * @param name
         *        The name of the table for which the other fields in this object apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private List<QueryGenerationColumn> columns = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String inclusion;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryGenerationTable model) {
            columns(model.columns);
            description(model.description);
            inclusion(model.inclusion);
            name(model.name);
        }

        public final List<QueryGenerationColumn.Builder> getColumns() {
            List<QueryGenerationColumn.Builder> result = QueryGenerationColumnsCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<QueryGenerationColumn.BuilderImpl> columns) {
            this.columns = QueryGenerationColumnsCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<QueryGenerationColumn> columns) {
            this.columns = QueryGenerationColumnsCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(QueryGenerationColumn... columns) {
            columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<QueryGenerationColumn.Builder>... columns) {
            columns(Stream.of(columns).map(c -> QueryGenerationColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInclusion() {
            return inclusion;
        }

        public final void setInclusion(String inclusion) {
            this.inclusion = inclusion;
        }

        @Override
        public final Builder inclusion(String inclusion) {
            this.inclusion = inclusion;
            return this;
        }

        @Override
        public final Builder inclusion(IncludeExclude inclusion) {
            this.inclusion(inclusion == null ? null : inclusion.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public QueryGenerationTable build() {
            return new QueryGenerationTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
