/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the storage configuration of the knowledge base in Amazon Neptune Analytics. For more
 * information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-neptune.html">Create a vector index
 * in Amazon Neptune Analytics</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NeptuneAnalyticsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NeptuneAnalyticsConfiguration.Builder, NeptuneAnalyticsConfiguration> {
    private static final SdkField<NeptuneAnalyticsFieldMapping> FIELD_MAPPING_FIELD = SdkField
            .<NeptuneAnalyticsFieldMapping> builder(MarshallingType.SDK_POJO).memberName("fieldMapping")
            .getter(getter(NeptuneAnalyticsConfiguration::fieldMapping)).setter(setter(Builder::fieldMapping))
            .constructor(NeptuneAnalyticsFieldMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()).build();

    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphArn").getter(getter(NeptuneAnalyticsConfiguration::graphArn)).setter(setter(Builder::graphArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_MAPPING_FIELD,
            GRAPH_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NeptuneAnalyticsFieldMapping fieldMapping;

    private final String graphArn;

    private NeptuneAnalyticsConfiguration(BuilderImpl builder) {
        this.fieldMapping = builder.fieldMapping;
        this.graphArn = builder.graphArn;
    }

    /**
     * <p>
     * Contains the names of the fields to which to map information about the vector store.
     * </p>
     * 
     * @return Contains the names of the fields to which to map information about the vector store.
     */
    public final NeptuneAnalyticsFieldMapping fieldMapping() {
        return fieldMapping;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Neptune Analytics vector store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Neptune Analytics vector store.
     */
    public final String graphArn() {
        return graphArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldMapping());
        hashCode = 31 * hashCode + Objects.hashCode(graphArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeptuneAnalyticsConfiguration)) {
            return false;
        }
        NeptuneAnalyticsConfiguration other = (NeptuneAnalyticsConfiguration) obj;
        return Objects.equals(fieldMapping(), other.fieldMapping()) && Objects.equals(graphArn(), other.graphArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NeptuneAnalyticsConfiguration").add("FieldMapping", fieldMapping())
                .add("GraphArn", graphArn() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldMapping":
            return Optional.ofNullable(clazz.cast(fieldMapping()));
        case "graphArn":
            return Optional.ofNullable(clazz.cast(graphArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fieldMapping", FIELD_MAPPING_FIELD);
        map.put("graphArn", GRAPH_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NeptuneAnalyticsConfiguration, T> g) {
        return obj -> g.apply((NeptuneAnalyticsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NeptuneAnalyticsConfiguration> {
        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * 
         * @param fieldMapping
         *        Contains the names of the fields to which to map information about the vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMapping(NeptuneAnalyticsFieldMapping fieldMapping);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * This is a convenience method that creates an instance of the {@link NeptuneAnalyticsFieldMapping.Builder}
         * avoiding the need to create one manually via {@link NeptuneAnalyticsFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NeptuneAnalyticsFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMapping(NeptuneAnalyticsFieldMapping)}.
         * 
         * @param fieldMapping
         *        a consumer that will call methods on {@link NeptuneAnalyticsFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMapping(NeptuneAnalyticsFieldMapping)
         */
        default Builder fieldMapping(Consumer<NeptuneAnalyticsFieldMapping.Builder> fieldMapping) {
            return fieldMapping(NeptuneAnalyticsFieldMapping.builder().applyMutation(fieldMapping).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Neptune Analytics vector store.
         * </p>
         * 
         * @param graphArn
         *        The Amazon Resource Name (ARN) of the Neptune Analytics vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphArn(String graphArn);
    }

    static final class BuilderImpl implements Builder {
        private NeptuneAnalyticsFieldMapping fieldMapping;

        private String graphArn;

        private BuilderImpl() {
        }

        private BuilderImpl(NeptuneAnalyticsConfiguration model) {
            fieldMapping(model.fieldMapping);
            graphArn(model.graphArn);
        }

        public final NeptuneAnalyticsFieldMapping.Builder getFieldMapping() {
            return fieldMapping != null ? fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(NeptuneAnalyticsFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(NeptuneAnalyticsFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public final String getGraphArn() {
            return graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        @Override
        public NeptuneAnalyticsConfiguration build() {
            return new NeptuneAnalyticsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
