/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the metadata associate with the content to ingest into a knowledge base. Choose a
 * <code>type</code> and include the field that corresponds to it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentMetadata.Builder, DocumentMetadata> {
    private static final SdkField<List<MetadataAttribute>> INLINE_ATTRIBUTES_FIELD = SdkField
            .<List<MetadataAttribute>> builder(MarshallingType.LIST)
            .memberName("inlineAttributes")
            .getter(getter(DocumentMetadata::inlineAttributes))
            .setter(setter(Builder::inlineAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetadataAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetadataAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomS3Location> S3_LOCATION_FIELD = SdkField
            .<CustomS3Location> builder(MarshallingType.SDK_POJO).memberName("s3Location")
            .getter(getter(DocumentMetadata::s3Location)).setter(setter(Builder::s3Location))
            .constructor(CustomS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DocumentMetadata::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_ATTRIBUTES_FIELD,
            S3_LOCATION_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MetadataAttribute> inlineAttributes;

    private final CustomS3Location s3Location;

    private final String type;

    private DocumentMetadata(BuilderImpl builder) {
        this.inlineAttributes = builder.inlineAttributes;
        this.s3Location = builder.s3Location;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the InlineAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInlineAttributes() {
        return inlineAttributes != null && !(inlineAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, each of which defines a metadata attribute to associate with the content to ingest. You
     * define the attributes inline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInlineAttributes} method.
     * </p>
     * 
     * @return An array of objects, each of which defines a metadata attribute to associate with the content to ingest.
     *         You define the attributes inline.
     */
    public final List<MetadataAttribute> inlineAttributes() {
        return inlineAttributes;
    }

    /**
     * <p>
     * The Amazon S3 location of the file containing metadata to associate with the content to ingest.
     * </p>
     * 
     * @return The Amazon S3 location of the file containing metadata to associate with the content to ingest.
     */
    public final CustomS3Location s3Location() {
        return s3Location;
    }

    /**
     * <p>
     * The type of the source source from which to add metadata.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the source source from which to add metadata.
     * @see MetadataSourceType
     */
    public final MetadataSourceType type() {
        return MetadataSourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the source source from which to add metadata.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the source source from which to add metadata.
     * @see MetadataSourceType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInlineAttributes() ? inlineAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata) obj;
        return hasInlineAttributes() == other.hasInlineAttributes()
                && Objects.equals(inlineAttributes(), other.inlineAttributes())
                && Objects.equals(s3Location(), other.s3Location()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentMetadata").add("InlineAttributes", hasInlineAttributes() ? inlineAttributes() : null)
                .add("S3Location", s3Location()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inlineAttributes":
            return Optional.ofNullable(clazz.cast(inlineAttributes()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inlineAttributes", INLINE_ATTRIBUTES_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentMetadata, T> g) {
        return obj -> g.apply((DocumentMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentMetadata> {
        /**
         * <p>
         * An array of objects, each of which defines a metadata attribute to associate with the content to ingest. You
         * define the attributes inline.
         * </p>
         * 
         * @param inlineAttributes
         *        An array of objects, each of which defines a metadata attribute to associate with the content to
         *        ingest. You define the attributes inline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineAttributes(Collection<MetadataAttribute> inlineAttributes);

        /**
         * <p>
         * An array of objects, each of which defines a metadata attribute to associate with the content to ingest. You
         * define the attributes inline.
         * </p>
         * 
         * @param inlineAttributes
         *        An array of objects, each of which defines a metadata attribute to associate with the content to
         *        ingest. You define the attributes inline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineAttributes(MetadataAttribute... inlineAttributes);

        /**
         * <p>
         * An array of objects, each of which defines a metadata attribute to associate with the content to ingest. You
         * define the attributes inline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.MetadataAttribute.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.MetadataAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.MetadataAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #inlineAttributes(List<MetadataAttribute>)}.
         * 
         * @param inlineAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.MetadataAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inlineAttributes(java.util.Collection<MetadataAttribute>)
         */
        Builder inlineAttributes(Consumer<MetadataAttribute.Builder>... inlineAttributes);

        /**
         * <p>
         * The Amazon S3 location of the file containing metadata to associate with the content to ingest.
         * </p>
         * 
         * @param s3Location
         *        The Amazon S3 location of the file containing metadata to associate with the content to ingest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(CustomS3Location s3Location);

        /**
         * <p>
         * The Amazon S3 location of the file containing metadata to associate with the content to ingest.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomS3Location.Builder} avoiding the
         * need to create one manually via {@link CustomS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomS3Location.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Location(CustomS3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link CustomS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(CustomS3Location)
         */
        default Builder s3Location(Consumer<CustomS3Location.Builder> s3Location) {
            return s3Location(CustomS3Location.builder().applyMutation(s3Location).build());
        }

        /**
         * <p>
         * The type of the source source from which to add metadata.
         * </p>
         * 
         * @param type
         *        The type of the source source from which to add metadata.
         * @see MetadataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataSourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the source source from which to add metadata.
         * </p>
         * 
         * @param type
         *        The type of the source source from which to add metadata.
         * @see MetadataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataSourceType
         */
        Builder type(MetadataSourceType type);
    }

    static final class BuilderImpl implements Builder {
        private List<MetadataAttribute> inlineAttributes = DefaultSdkAutoConstructList.getInstance();

        private CustomS3Location s3Location;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadata model) {
            inlineAttributes(model.inlineAttributes);
            s3Location(model.s3Location);
            type(model.type);
        }

        public final List<MetadataAttribute.Builder> getInlineAttributes() {
            List<MetadataAttribute.Builder> result = DocumentMetadataInlineAttributesListCopier
                    .copyToBuilder(this.inlineAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInlineAttributes(Collection<MetadataAttribute.BuilderImpl> inlineAttributes) {
            this.inlineAttributes = DocumentMetadataInlineAttributesListCopier.copyFromBuilder(inlineAttributes);
        }

        @Override
        public final Builder inlineAttributes(Collection<MetadataAttribute> inlineAttributes) {
            this.inlineAttributes = DocumentMetadataInlineAttributesListCopier.copy(inlineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineAttributes(MetadataAttribute... inlineAttributes) {
            inlineAttributes(Arrays.asList(inlineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineAttributes(Consumer<MetadataAttribute.Builder>... inlineAttributes) {
            inlineAttributes(Stream.of(inlineAttributes).map(c -> MetadataAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CustomS3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        public final void setS3Location(CustomS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(CustomS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MetadataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public DocumentMetadata build() {
            return new DocumentMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
