/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about content defined inline in bytes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ByteContentDoc implements SdkPojo, Serializable, ToCopyableBuilder<ByteContentDoc.Builder, ByteContentDoc> {
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("data").getter(getter(ByteContentDoc::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mimeType").getter(getter(ByteContentDoc::mimeType)).setter(setter(Builder::mimeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mimeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, MIME_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes data;

    private final String mimeType;

    private ByteContentDoc(BuilderImpl builder) {
        this.data = builder.data;
        this.mimeType = builder.mimeType;
    }

    /**
     * <p>
     * The base64-encoded string of the content.
     * </p>
     * 
     * @return The base64-encoded string of the content.
     */
    public final SdkBytes data() {
        return data;
    }

    /**
     * <p>
     * The MIME type of the content. For a list of MIME types, see <a
     * href="https://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. The following MIME types
     * are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * text/plain
     * </p>
     * </li>
     * <li>
     * <p>
     * text/html
     * </p>
     * </li>
     * <li>
     * <p>
     * text/csv
     * </p>
     * </li>
     * <li>
     * <p>
     * text/vtt
     * </p>
     * </li>
     * <li>
     * <p>
     * message/rfc822
     * </p>
     * </li>
     * <li>
     * <p>
     * application/xhtml+xml
     * </p>
     * </li>
     * <li>
     * <p>
     * application/pdf
     * </p>
     * </li>
     * <li>
     * <p>
     * application/msword
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.ms-word.document.macroenabled.12
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.ms-word.template.macroenabled.12
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.ms-excel
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.ms-excel.addin.macroenabled.12
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.ms-excel.sheet.macroenabled.12
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.ms-excel.template.macroenabled.12
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.ms-excel.sheet.binary.macroenabled.12
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.ms-spreadsheetml
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.openxmlformats-officedocument.spreadsheetml.template
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.openxmlformats-officedocument.wordprocessingml.document
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.openxmlformats-officedocument.wordprocessingml.template
     * </p>
     * </li>
     * </ul>
     * 
     * @return The MIME type of the content. For a list of MIME types, see <a
     *         href="https://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. The following MIME
     *         types are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         text/plain
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         text/html
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         text/csv
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         text/vtt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         message/rfc822
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/xhtml+xml
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/pdf
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/msword
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.ms-word.document.macroenabled.12
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.ms-word.template.macroenabled.12
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.ms-excel
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.ms-excel.addin.macroenabled.12
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.ms-excel.sheet.macroenabled.12
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.ms-excel.template.macroenabled.12
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.ms-excel.sheet.binary.macroenabled.12
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.ms-spreadsheetml
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.openxmlformats-officedocument.spreadsheetml.template
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.openxmlformats-officedocument.wordprocessingml.document
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.openxmlformats-officedocument.wordprocessingml.template
     *         </p>
     *         </li>
     */
    public final String mimeType() {
        return mimeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(mimeType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteContentDoc)) {
            return false;
        }
        ByteContentDoc other = (ByteContentDoc) obj;
        return Objects.equals(data(), other.data()) && Objects.equals(mimeType(), other.mimeType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ByteContentDoc").add("Data", data() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MimeType", mimeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "mimeType":
            return Optional.ofNullable(clazz.cast(mimeType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("data", DATA_FIELD);
        map.put("mimeType", MIME_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ByteContentDoc, T> g) {
        return obj -> g.apply((ByteContentDoc) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ByteContentDoc> {
        /**
         * <p>
         * The base64-encoded string of the content.
         * </p>
         * 
         * @param data
         *        The base64-encoded string of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(SdkBytes data);

        /**
         * <p>
         * The MIME type of the content. For a list of MIME types, see <a
         * href="https://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. The following MIME
         * types are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * text/plain
         * </p>
         * </li>
         * <li>
         * <p>
         * text/html
         * </p>
         * </li>
         * <li>
         * <p>
         * text/csv
         * </p>
         * </li>
         * <li>
         * <p>
         * text/vtt
         * </p>
         * </li>
         * <li>
         * <p>
         * message/rfc822
         * </p>
         * </li>
         * <li>
         * <p>
         * application/xhtml+xml
         * </p>
         * </li>
         * <li>
         * <p>
         * application/pdf
         * </p>
         * </li>
         * <li>
         * <p>
         * application/msword
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.ms-word.document.macroenabled.12
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.ms-word.template.macroenabled.12
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.ms-excel
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.ms-excel.addin.macroenabled.12
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.ms-excel.sheet.macroenabled.12
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.ms-excel.template.macroenabled.12
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.ms-excel.sheet.binary.macroenabled.12
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.ms-spreadsheetml
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.openxmlformats-officedocument.spreadsheetml.template
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.openxmlformats-officedocument.wordprocessingml.document
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.openxmlformats-officedocument.wordprocessingml.template
         * </p>
         * </li>
         * </ul>
         * 
         * @param mimeType
         *        The MIME type of the content. For a list of MIME types, see <a
         *        href="https://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. The following
         *        MIME types are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        text/plain
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        text/html
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        text/csv
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        text/vtt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        message/rfc822
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/xhtml+xml
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/pdf
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/msword
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.ms-word.document.macroenabled.12
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.ms-word.template.macroenabled.12
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.ms-excel
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.ms-excel.addin.macroenabled.12
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.ms-excel.sheet.macroenabled.12
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.ms-excel.template.macroenabled.12
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.ms-excel.sheet.binary.macroenabled.12
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.ms-spreadsheetml
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.openxmlformats-officedocument.spreadsheetml.template
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.openxmlformats-officedocument.wordprocessingml.document
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.openxmlformats-officedocument.wordprocessingml.template
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mimeType(String mimeType);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes data;

        private String mimeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteContentDoc model) {
            data(model.data);
            mimeType(model.mimeType);
        }

        public final ByteBuffer getData() {
            return data == null ? null : data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            data(data == null ? null : SdkBytes.fromByteBuffer(data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final String getMimeType() {
            return mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public ByteContentDoc build() {
            return new ByteContentDoc(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
