/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobSummariesCopier;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIngestionJobsResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, ListIngestionJobsResponse> {
    private static final SdkField<List<IngestionJobSummary>> INGESTION_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ingestionJobSummaries").getter(ListIngestionJobsResponse.getter(ListIngestionJobsResponse::ingestionJobSummaries)).setter(ListIngestionJobsResponse.setter(Builder::ingestionJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IngestionJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListIngestionJobsResponse.getter(ListIngestionJobsResponse::nextToken)).setter(ListIngestionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGESTION_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIngestionJobsResponse.memberNameToFieldInitializer();
    private final List<IngestionJobSummary> ingestionJobSummaries;
    private final String nextToken;

    private ListIngestionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.ingestionJobSummaries = builder.ingestionJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIngestionJobSummaries() {
        return this.ingestionJobSummaries != null && !(this.ingestionJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<IngestionJobSummary> ingestionJobSummaries() {
        return this.ingestionJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIngestionJobSummaries() ? this.ingestionJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestionJobsResponse)) {
            return false;
        }
        ListIngestionJobsResponse other = (ListIngestionJobsResponse)((Object)obj);
        return this.hasIngestionJobSummaries() == other.hasIngestionJobSummaries() && Objects.equals(this.ingestionJobSummaries(), other.ingestionJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIngestionJobsResponse").add("IngestionJobSummaries", this.hasIngestionJobSummaries() ? this.ingestionJobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ingestionJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.ingestionJobSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ingestionJobSummaries", INGESTION_JOB_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIngestionJobsResponse, T> g) {
        return obj -> g.apply((ListIngestionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private List<IngestionJobSummary> ingestionJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIngestionJobsResponse model) {
            super(model);
            this.ingestionJobSummaries(model.ingestionJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<IngestionJobSummary.Builder> getIngestionJobSummaries() {
            List<IngestionJobSummary.Builder> result = IngestionJobSummariesCopier.copyToBuilder(this.ingestionJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngestionJobSummaries(Collection<IngestionJobSummary.BuilderImpl> ingestionJobSummaries) {
            this.ingestionJobSummaries = IngestionJobSummariesCopier.copyFromBuilder(ingestionJobSummaries);
        }

        @Override
        public final Builder ingestionJobSummaries(Collection<IngestionJobSummary> ingestionJobSummaries) {
            this.ingestionJobSummaries = IngestionJobSummariesCopier.copy(ingestionJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestionJobSummaries(IngestionJobSummary ... ingestionJobSummaries) {
            this.ingestionJobSummaries(Arrays.asList(ingestionJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestionJobSummaries(Consumer<IngestionJobSummary.Builder> ... ingestionJobSummaries) {
            this.ingestionJobSummaries(Stream.of(ingestionJobSummaries).map(c -> (IngestionJobSummary)((IngestionJobSummary.Builder)IngestionJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIngestionJobsResponse build() {
            return new ListIngestionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIngestionJobsResponse> {
        public Builder ingestionJobSummaries(Collection<IngestionJobSummary> var1);

        public Builder ingestionJobSummaries(IngestionJobSummary ... var1);

        public Builder ingestionJobSummaries(Consumer<IngestionJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

